/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/


package com.clustercontrol.performance.bean;

/**
 * 収集進捗状況を定義するクラス
 *
 * @version 1.0
 * @since 1.0
 */
public final class CollectorRunStatus {
	/**
	 * 実行準備状態
	 * 　QuartzRAMのジョブは登録されていない
	 * 　収集開始時刻（cc_collector_profile の start_date）はNULL
	 * 　収集終了時刻（cc_collector_profile の stop_date） はNULL
	 */
	public final static int READY = 0;

	/**
	 * 実行中状態
	 * 　QuartzRAMのジョブが登録されている
	 * 　収集開始時刻（cc_collector_profile の start_date）は設定済み
	 * 　収集終了時刻（cc_collector_profile の stop_date） はNULL
	 */
	public final static int RUNNING = 100;

	/**
	 * 性能管理機能では未定義
	 */
	public final static int END_PROCESSING = 101;

	/**
	 * 中断状態
	 * 　QuartzRAMのジョブは登録されていない
	 * 　収集開始時刻（cc_collector_profile の start_date）は設定済み
	 * 　収集終了時刻（cc_collector_profile の stop_date） はNULL
	 */
	public final static int SUSPEND = 200;

	/**
	 * 終了状態
	 * 　QuartzRAMのジョブは登録されていない
	 * 　収集開始時刻（cc_collector_profile の start_date）は設定済み
	 * 　収集終了時刻（cc_collector_profile の stop_date） は設定済み
	 */
	public final static int FINISHED = 300;
	
	/**
	 * 異常状態（実行準備、実行中、中断、終了以外の状態）
	 */
	public final static int ERROR = 400;
}
