/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.bean;

/**
 * メールテンプレート情報一覧のテーブル定義を定数として格納するクラス<BR>
 * 
 * メールテンプレート情報一覧ダイアログのテーブルの表示項目と表示順を定義します。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class MailTemplateTableDefine {
	
    /** メールテンプレートID。 */
    public static final int MAIL_TEMPLATE_ID = 0;

    /** 説明。 */
    public static final int DESCRIPTION = 1;

    /** 新規作成ユーザ。 */
    public static final int CREATE_USER = 2;
    
    /** 作成日時。 */
	public static final int CREATE_TIME = 3;
	
	/** 最終変更ユーザ。 */
	public static final int UPDATE_USER = 4;
	
	/** 最終変更日時。 */
	public static final int UPDATE_TIME = 5;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = MAIL_TEMPLATE_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

}
