/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

/**
 * 通知メール情報を保持するクラスです。
 */
public abstract class NotifyCommandInfo  extends NotifyInfoDetail
{
	private static String _dtoVersion = "1";
	
	public String getDtoVerion(){
		return _dtoVersion;
	}
	
	/**
	 * 実行コマンドを返します。
	 * @return 実行コマンド
	 */
	abstract public String getCommand();

	/**
	 * 実行コマンドを設定します。
	 * @param command 実行コマンド
	 */
	abstract public void setCommand(String command);
	
	/**
	 * 実効ユーザを返します。
	 * @return 実効ユーザ
	 */
	abstract public String getEffectiveUser();

	/**
	 * 実効ユーザを設定します。
	 * @param user 実効ユーザ
	 */
	abstract public void setEffectiveUser(String user);
	
	/**
	 * コマンド実行時に環境変数を読み込むか否かのフラグを取得します。
	 * 具体的にはsuコマンドを実行する際に'-'をつけるか否か
	 * 
	 * @return 環境変数を読み込むか否かのフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getSetEnvironment();
	
	/**
	 * コマンド実行時に環境変数を読み込むか否かのフラグを設定する。
	 * 具体的にはsuコマンドを実行する際に'-'をつけるか否か
	 * 
	 * @param setEnv 環境変数を読み込むか否かのフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setSetEnvironment(Integer setEnv);
	
	/**
	 * コマンド実行のタイムアウト値を取得します。
	 * コマンド実行後、この値を超えた場合は強制的に終了されます。
	 * 
	 * @return タイムアウト値
	 */
	abstract public Long getTimeout();

	/**
	 * コマンド実行のタイムアウト値を設定します。
	 * コマンド実行後、この値を超えた場合は強制的に終了されます。
	 * 
	 * @param timeout タイムアウト値
	 */
	abstract public void setTimeout(Long timeout);
}
