/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.bean;

import java.util.ArrayList;

import com.clustercontrol.monitor.run.bean.MonitorInfo;

/**
 * SNMPTRAP監視設定情報のBeanクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorSnmpTrapInfo extends MonitorInfo {
	private static final long serialVersionUID = -3796051402161611015L;
	
	public final static int SPECIFIC_OID = 0;
	public final static int ALL_OID  = 1;
	public final static int UNREGISTERED_OID = 2;
	
	protected int checkMode = SPECIFIC_OID;
	
	protected String communityName;
	protected ArrayList<MonitorSnmpTrapOidInfo> oidInfos;
	
	public MonitorSnmpTrapInfo(){
		
	}
    /**
     * コミュニティ名を取得します。<BR>
     * return コミュニティ名
     */
	public String getCommunityName() {
		return communityName;
	}
	/**
	 * コミュニティ名を設定します。<BR>
	 * @param communityName
	 */
	public void setCommunityName(String communityName) {
		this.communityName = communityName;
	}
	/**
	 * 監視対象のOID(複数)を取得します。
	 * @return　MonitorSnmpTrapOidInfoのArrayList
	 * @see com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo
	 */
	public ArrayList<MonitorSnmpTrapOidInfo> getOidInfos() {
		return oidInfos;
	}

	public void setOidInfos(ArrayList<MonitorSnmpTrapOidInfo> oidInfos) {
		this.oidInfos = oidInfos;
	}

	public int getCheckMode() {
		return checkMode;
	}

	public void setCheckMode(int checkMode) {
		this.checkMode = checkMode;
	}
}
