#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
#
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../lib/hinemos_agent.cfg
AGENT_LIB=${HINEMOS_AGENT_HOME}/lib
TIMEOUT=10

# change current directory
cd ${HINEMOS_AGENT_HOME}/var/log

# check process
if [ -f ${HINEMOS_JOB_AGENT_PID} ]
then
	read PID < ${HINEMOS_JOB_AGENT_PID}
	if [ `ps --no-headers --pid ${PID} e | grep "${JAVA_HOME}/bin/java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
	then
		echo "Hinemos Job Agent is running..."
		exit 1
	fi
fi

## tune JVM Heap Memory
JAVA_OPTS="-Xms16m -Xmx64m"

## JVM GC logging
#DATE_POSTFIX=""
#DATE_POSTFIX=".`date +%Y-%m-%d-%H%M%S`"
#JAVA_OPTS="${JAVA_OPTS} -Xloggc:${HINEMOS_AGENT_HOME}/var/log/job_agent_gc.log${DATE_POSTFIX} -verbose:gc -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintClassHistogram"

## for jconsole
#JAVA_OPTS="${JAVA_OPTS} -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=7102 -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false"

## startup
nohup ${JAVA_HOME}/bin/java ${JAVA_OPTS} -cp ${AGENT_LIB}/job_agent:${AGENT_LIB}/job_agent/JobAgent.jar:${AGENT_LIB}/commons-logging-1.1.jar:${AGENT_LIB}/javassist.jar:${AGENT_LIB}/jboss-aop-jdk50.jar:${AGENT_LIB}/jboss-messaging-client.jar:${AGENT_LIB}/jboss-remoting.jar:${AGENT_LIB}/jbossall-client.jar:${AGENT_LIB}/log4j-1.2.15.jar:${AGENT_LIB}/trove.jar:${AGENT_LIB}/HinemosIF.jar:${AGENT_LIB}/HinemosCommon.jar com.clustercontrol.agent.Agent ${AGENT_LIB}/job_agent/Agent.properties ${AGENT_LIB}/job_agent/log4j.properties > ${HINEMOS_AGENT_HOME}/var/log/job_agent_stdouterr.log 2>&1 &
echo $! > ${HINEMOS_JOB_AGENT_PID}

## check process
read PID < ${HINEMOS_JOB_AGENT_PID}
for TIME in `seq 1 ${TIMEOUT}`
do
	if [ `ps --no-headers --pid ${PID} e | grep "${JAVA_HOME}/bin/java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
	then
		echo "Hinemos Job Agent started."
		exit 0
	fi
	sleep 1
done

echo "Hinemos Job Agent startup failed."
exit 1
