/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.bean.UserConstant;
import com.clustercontrol.accesscontrol.bean.UserRoleList;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserRoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ユーザ情報を生成するファクトリクラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class UserProperty {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog(UserProperty.class);

	/** Roleリスト */
	private final static List<String> m_roles = new ArrayList<String>();
	
	/** ReadRoleリスト */
	public final static List<String> m_readRoles = new ArrayList<String>();

	/** WriteRoleリスト */
	public final static List<String> m_writeRoles = new ArrayList<String>();
	
	/** ExecRoleリスト */
	public final static List<String> m_execRoles = new ArrayList<String>();
	
	static {
		/** ローカル変数 */
		String serverName = null;
		Properties properties = null;
		String etcdir = null;
		String propertyFile = null;

		/** メイン処理 */
		m_log.debug("initialize RoleConstant...");

		serverName = System.getProperty("jboss.server.name");
		properties = new Properties();
		etcdir = System.getProperty("hinemos.manager.etc.dir");
		propertyFile = etcdir + File.separator + "option.properties";

		m_roles.add(RoleConstant.HINEMOS_USER);
		m_roles.add(RoleConstant.REPOSITORY_READ);
		m_roles.add(RoleConstant.REPOSITORY_WRITE);
		m_roles.add(RoleConstant.ACCESSCONTROL_READ);
		m_roles.add(RoleConstant.ACCESSCONTROL_WRITE);
		m_roles.add(RoleConstant.JOBMANAGEMENT_READ);
		m_roles.add(RoleConstant.JOBMANAGEMENT_WRITE);
		m_roles.add(RoleConstant.JOBMANAGEMENT_EXECUTE);
		m_roles.add(RoleConstant.COLLECTIVERUN_READ);
		m_roles.add(RoleConstant.COLLECTIVERUN_WRITE);
		m_roles.add(RoleConstant.COLLECTIVERUN_EXECUTE);
		m_roles.add(RoleConstant.PERFORMANCE_READ);
		m_roles.add(RoleConstant.PERFORMANCE_WRITE);
		m_roles.add(RoleConstant.PERFORMANCE_EXECUTE);
		m_roles.add(RoleConstant.MONITOR_READ);
		m_roles.add(RoleConstant.MONITOR_WRITE);
		m_roles.add(RoleConstant.SYSLOGNG_MONITOR_READ);
		m_roles.add(RoleConstant.SYSLOGNG_MONITOR_WRITE);
		m_roles.add(RoleConstant.AGENT_MONITOR_READ);
		m_roles.add(RoleConstant.AGENT_MONITOR_WRITE);
		m_roles.add(RoleConstant.HTTP_MONITOR_READ);
		m_roles.add(RoleConstant.HTTP_MONITOR_WRITE);
		m_roles.add(RoleConstant.PROCESS_MONITOR_READ);
		m_roles.add(RoleConstant.PROCESS_MONITOR_WRITE);
		m_roles.add(RoleConstant.SQL_MONITOR_READ);
		m_roles.add(RoleConstant.SQL_MONITOR_WRITE);
		m_roles.add(RoleConstant.SNMP_MONITOR_READ);
		m_roles.add(RoleConstant.SNMP_MONITOR_WRITE);
		m_roles.add(RoleConstant.PING_MONITOR_READ);
		m_roles.add(RoleConstant.PING_MONITOR_WRITE);
		m_roles.add(RoleConstant.PORT_MONITOR_READ);
		m_roles.add(RoleConstant.PORT_MONITOR_WRITE);
		m_roles.add(RoleConstant.CALENDAR_READ);
		m_roles.add(RoleConstant.CALENDAR_WRITE);
		m_roles.add(RoleConstant.NOTIFY_READ);
		m_roles.add(RoleConstant.NOTIFY_WRITE);
		m_roles.add(RoleConstant.PRIORITY_JUDGMENT_READ);
		m_roles.add(RoleConstant.PRIORITY_JUDGMENT_WRITE);
		m_roles.add(RoleConstant.LOG_TRANSFER_READ);
		m_roles.add(RoleConstant.LOG_TRANSFER_WRITE);
		m_roles.add(RoleConstant.SNMPTRAP_MONITOR_READ);
		m_roles.add(RoleConstant.SNMPTRAP_MONITOR_WRITE);
		m_roles.add(RoleConstant.MAINTENANCE_READ);
		m_roles.add(RoleConstant.MAINTENANCE_WRITE);
		m_roles.add(RoleConstant.WEB_SERVICE_EXECUTE);

		/** WriteRoleリスト */
		// 参照権限
		m_readRoles.add(RoleConstant.REPOSITORY_READ);
		m_readRoles.add(RoleConstant.ACCESSCONTROL_READ);
		m_readRoles.add(RoleConstant.JOBMANAGEMENT_READ);
		m_readRoles.add(RoleConstant.COLLECTIVERUN_READ);
		m_readRoles.add(RoleConstant.PERFORMANCE_READ);
		m_readRoles.add(RoleConstant.MONITOR_READ);
		m_readRoles.add(RoleConstant.SYSLOGNG_MONITOR_READ);
		m_readRoles.add(RoleConstant.AGENT_MONITOR_READ);
		m_readRoles.add(RoleConstant.HTTP_MONITOR_READ);
		m_readRoles.add(RoleConstant.PROCESS_MONITOR_READ);
		m_readRoles.add(RoleConstant.SQL_MONITOR_READ);
		m_readRoles.add(RoleConstant.SNMP_MONITOR_READ);
		m_readRoles.add(RoleConstant.PING_MONITOR_READ);
		m_readRoles.add(RoleConstant.PORT_MONITOR_READ);
		m_readRoles.add(RoleConstant.CALENDAR_READ);
		m_readRoles.add(RoleConstant.NOTIFY_READ);
		m_readRoles.add(RoleConstant.PRIORITY_JUDGMENT_READ);
		m_readRoles.add(RoleConstant.LOG_TRANSFER_READ);
		m_readRoles.add(RoleConstant.SNMPTRAP_MONITOR_READ);
		m_readRoles.add(RoleConstant.MAINTENANCE_READ);

		// 設定権限
		m_writeRoles.add(RoleConstant.REPOSITORY_WRITE);
		m_writeRoles.add(RoleConstant.ACCESSCONTROL_WRITE);
		m_writeRoles.add(RoleConstant.JOBMANAGEMENT_WRITE);
		m_writeRoles.add(RoleConstant.COLLECTIVERUN_WRITE);
		m_writeRoles.add(RoleConstant.PERFORMANCE_WRITE);
		m_writeRoles.add(RoleConstant.MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.SYSLOGNG_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.AGENT_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.HTTP_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.PROCESS_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.SQL_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.SNMP_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.PING_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.PORT_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.CALENDAR_WRITE);
		m_writeRoles.add(RoleConstant.NOTIFY_WRITE);
		m_writeRoles.add(RoleConstant.PRIORITY_JUDGMENT_WRITE);
		m_writeRoles.add(RoleConstant.LOG_TRANSFER_WRITE);
		m_writeRoles.add(RoleConstant.SNMPTRAP_MONITOR_WRITE);
		m_writeRoles.add(RoleConstant.MAINTENANCE_WRITE);

		// 実行権限
		m_execRoles.add(RoleConstant.JOBMANAGEMENT_EXECUTE);
		m_execRoles.add(RoleConstant.COLLECTIVERUN_EXECUTE);
		m_execRoles.add(RoleConstant.PERFORMANCE_EXECUTE);
		m_execRoles.add(RoleConstant.VMMANAGEMENT_EXECUTE);
		m_execRoles.add(RoleConstant.WEB_SERVICE_EXECUTE);

		// VM Option関連
		try {
			properties.load(new FileInputStream(propertyFile));
			m_roles.add(RoleConstant.VMMANAGEMENT_READ);
			m_roles.add(RoleConstant.VMMANAGEMENT_WRITE);
			m_roles.add(RoleConstant.VMMANAGEMENT_EXECUTE);

			m_readRoles.add(RoleConstant.VMMANAGEMENT_READ);
			m_writeRoles.add(RoleConstant.VMMANAGEMENT_WRITE);
			m_execRoles.add(RoleConstant.VMMANAGEMENT_EXECUTE);
		} catch (Exception e) {
			m_log.info("skipped roles of Hinemos VM Option.");
		}

		// HA Option関連
		if (serverName != null && serverName.equals("all")) {
			m_log.info("adding roles of Hinemos HA Option...");
			m_roles.add(RoleConstant.TROUBLE_DETECTION_READ);
			m_roles.add(RoleConstant.TROUBLE_DETECTION_WRITE);
			m_readRoles.add(RoleConstant.TROUBLE_DETECTION_READ);
			m_writeRoles.add(RoleConstant.TROUBLE_DETECTION_WRITE);
		}
	}
	
	/**
	 * 指定されたユーザIDの情報が設定されたユーザ情報を生成する。
	 * <p>
	 * <ol>
	 *  <li>項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成する。</li>
	 *  <li>各項目のプロパティをツリー状に定義する。</li>
	 *  <li>指定されたユーザIDの情報をプロパティに設定する。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義する項目は、下記の通り。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>ユーザID（子。テキスト）</li>
	 *   <li>名前（子。テキスト）</li>
	 *   <li>説明（子。テキスト）</li>
	 *   <li>作成日時（子。テキスト）</li>
	 *   <li>新規作成ユーザ（子。テキスト）</li>
	 *   <li>最終更新日時（子。テキスト）</li>
	 *   <li>最終更新ユーザ（子。テキスト）</li>
	 *   <li>アクセス権（子。テキスト）</li>
	 *   <ul>
	 *    <li>リポジトリ - 参照（孫。チェックボックス）</li>
	 *    <li>リポジトリ - 設定（孫。チェックボックス）</li>
	 *    <li>アクセス - 参照（孫。チェックボックス）</li>
	 *    <li>アクセス - 設定（孫。チェックボックス）</li>
	 *    <li>監視管理 - 参照（孫。チェックボックス）</li>
	 *    <li>監視管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 参照（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 実行（孫。チェックボックス）</li>
	 *    <li>性能管理 - 参照（孫。チェックボックス）</li>
	 *    <li>性能管理 - 設定（孫。チェックボックス）</li>
	 *    <li>性能管理 - 実行（孫。チェックボックス）</li>
	 *    <li>一括制御 - 参照（孫。チェックボックス）</li>
	 *    <li>一括制御 - 設定（孫。チェックボックス）</li>
	 *    <li>一括制御 - 実行（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 参照（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 設定（孫。チェックボックス）</li>
	 *    <li>PING監視 - 参照（孫。チェックボックス）</li>
	 *    <li>PING監視 - 設定（孫。チェックボックス）</li>
	 *    <li>サービス・ポート監視 - 参照（孫。チェックボックス）</li>
	 *    <li>サービス・ポート監視 - 設定（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 参照（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 設定（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 参照（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 設定（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 参照（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 設定（孫。チェックボックス）</li>
	 *    <li>カレンダ - 参照（孫。チェックボックス）</li>
	 *    <li>カレンダ - 設定（孫。チェックボックス）</li>
	 *    <li>通知 - 参照（孫。チェックボックス）</li>
	 *    <li>通知 - 設定（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 参照（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 設定（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 参照（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 設定（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 実行（孫。チェックボックス）</li>
	 *    <li>障害検知 - 参照（孫。チェックボックス）</li>
	 *    <li>障害検知 - 設定（孫。チェックボックス）</li>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param userId ユーザID
	 * @param mode 編集モード
	 * @param locale ロケール情報
	 * @return ユーザ情報
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see #getProperty(int, Locale)
	 */
	public static Property getProperty(String userId, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		ArrayList propertyList = null;
		
		if(userId != null && userId.compareTo("") != 0){
			//User取得
			UserLocal user = UserUtil.getLocalHome().findByPrimaryKey(userId);
			
			if(user != null){
				//UID
				propertyList = PropertyUtil.getProperty(property, UserConstant.UID);
				((Property)propertyList.get(0)).setValue(user.getUserId());
				//名前
				propertyList = PropertyUtil.getProperty(property, UserConstant.NAME);
				if(user.getUserName() != null && user.getUserName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getUserName());
				}
				//説明
				propertyList = PropertyUtil.getProperty(property, UserConstant.DESCRIPTION);
				if(user.getDescription() != null && user.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getDescription());
				}
				//登録者
				propertyList = PropertyUtil.getProperty(property, UserConstant.CREATOR_NAME);
				if(user.getCreateUserId() != null && user.getCreateUserId().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getCreateUserId());
				}
				//登録日時
				propertyList = PropertyUtil.getProperty(property, UserConstant.CREATE_TIME);
				if(user.getCreateDatetime() != null){
					((Property)propertyList.get(0)).setValue( new Date(user.getCreateDatetime().getTime()) );
				}
				//更新者
				propertyList = PropertyUtil.getProperty(property, UserConstant.MODIFIER_NAME);
				if(user.getModifyUserId() != null && user.getModifyUserId().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(user.getModifyUserId());
				}
				//更新日時
				propertyList = PropertyUtil.getProperty(property, UserConstant.MODIFY_TIME);
				if(user.getModifyDatetime() != null){
					((Property)propertyList.get(0)).setValue( new Date(user.getModifyDatetime().getTime()) );
				}
				
				//アクセス権限
				propertyList = PropertyUtil.getProperty(property, UserConstant.ACCESS);
				Property accessProperty = (Property)propertyList.get(0);
				
				//所属Roleを取得
				for (UserRoleLocal role : (Collection<UserRoleLocal>)user.getUserRole()) {
					propertyList = PropertyUtil.getProperty(accessProperty, role.getUserRole());
					if(propertyList.size() > 0) {
						((Property)propertyList.get(0)).setValue(Boolean.valueOf(true));
					}
				}
			}
		}
		
		return property;
	}
	
	/**
	 * ユーザ用プロパティを返す。
	 * <p>
	 * <ol>
	 *  <li>項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成する。</li>
	 *  <li>各項目のプロパティをツリー状に定義する。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義する項目は、下記の通り。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>ユーザID（子。テキスト）</li>
	 *   <li>名前（子。テキスト）</li>
	 *   <li>説明（子。テキスト）</li>
	 *   <li>作成日時（子。テキスト）</li>
	 *   <li>新規作成ユーザ（子。テキスト）</li>
	 *   <li>最終更新日時（子。テキスト）</li>
	 *   <li>最終更新ユーザ（子。テキスト）</li>
	 *   <li>アクセス権（子。テキスト）</li>
	 *   <ul>
	 *    <li>リポジトリ - 参照（孫。チェックボックス）</li>
	 *    <li>リポジトリ - 設定（孫。チェックボックス）</li>
	 *    <li>アクセス - 参照（孫。チェックボックス）</li>
	 *    <li>アクセス - 設定（孫。チェックボックス）</li>
	 *    <li>監視管理 - 参照（孫。チェックボックス）</li>
	 *    <li>監視管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 参照（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 実行（孫。チェックボックス）</li>
	 *    <li>性能管理 - 参照（孫。チェックボックス）</li>
	 *    <li>性能管理 - 設定（孫。チェックボックス）</li>
	 *    <li>性能管理 - 実行（孫。チェックボックス）</li>
	 *    <li>一括制御 - 参照（孫。チェックボックス）</li>
	 *    <li>一括制御 - 設定（孫。チェックボックス）</li>
	 *    <li>一括制御 - 実行（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 参照（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 設定（孫。チェックボックス）</li>
	 *    <li>PING監視 - 参照（孫。チェックボックス）</li>
	 *    <li>PING監視 - 設定（孫。チェックボックス）</li>
	 *    <li>サービス・ポート監視 - 参照（孫。チェックボックス）</li>
	 *    <li>サービス・ポート監視 - 設定（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 参照（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 設定（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 参照（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 設定（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 参照（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 設定（孫。チェックボックス）</li>
	 *    <li>カレンダ - 参照（孫。チェックボックス）</li>
	 *    <li>カレンダ - 設定（孫。チェックボックス）</li>
	 *    <li>通知 - 参照（孫。チェックボックス）</li>
	 *    <li>通知 - 設定（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 参照（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 設定（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 参照（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 設定（孫。チェックボックス）</li>
	 *    <li>仮想化管理 - 実行（孫。チェックボックス）</li>
	 *    <li>障害検知 - 参照（孫。チェックボックス）</li>
	 *    <li>障害検知 - 設定（孫。チェックボックス）</li>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param mode 編集モード
	 * @param locale ロケール情報
	 * @return ユーザ情報
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 */
	public static Property getProperty(int mode, Locale locale) {
		//UID
		Property uid =
			new Property(UserConstant.UID, Messages.getString("user.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//名前
		Property name =
			new Property(UserConstant.NAME, Messages.getString("name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property description =
			new Property(UserConstant.DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//登録日時
		Property createTime =
			new Property(UserConstant.CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(UserConstant.CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(UserConstant.MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(UserConstant.MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//アクセス権限
		Property access =
			new Property(UserConstant.ACCESS, Messages.getString("access.permission", locale), PropertyConstant.EDITOR_TEXT);
		//リポジトリ参照
		Property repositoryRead =
			new Property(RoleConstant.REPOSITORY_READ, Messages.getString("repository.read", locale), PropertyConstant.EDITOR_BOOL);
		//リポジトリ設定
		Property repositoryWrite =
			new Property(RoleConstant.REPOSITORY_WRITE, Messages.getString("repository.write", locale), PropertyConstant.EDITOR_BOOL);
		//アクセス参照
		Property accessRead =
			new Property(RoleConstant.ACCESSCONTROL_READ, Messages.getString("accesscontrol.read", locale), PropertyConstant.EDITOR_BOOL);
		//アクセス設定
		Property accessWrite =
			new Property(RoleConstant.ACCESSCONTROL_WRITE, Messages.getString("accesscontrol.write", locale), PropertyConstant.EDITOR_BOOL);
		//状態監視参照
		Property monitorRead =
			new Property(RoleConstant.MONITOR_READ, Messages.getString("monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//状態監視設定
		Property monitorWrite =
			new Property(RoleConstant.MONITOR_WRITE, Messages.getString("monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ管理参照
		Property jobManagementRead =
			new Property(RoleConstant.JOBMANAGEMENT_READ, Messages.getString("jobmanagement.read", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ設定
		Property jobManagementWrite =
			new Property(RoleConstant.JOBMANAGEMENT_WRITE, Messages.getString("jobmanagement.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ実行
		Property jobManagementExecute =
			new Property(RoleConstant.JOBMANAGEMENT_EXECUTE, Messages.getString("jobmanagement.execute", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理参照
		Property performanceRead =
			new Property(RoleConstant.PERFORMANCE_READ, Messages.getString("performance.read", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理設定
		Property performanceWrite =
			new Property(RoleConstant.PERFORMANCE_WRITE, Messages.getString("performance.write", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理実行
		Property performanceExecute =
			new Property(RoleConstant.PERFORMANCE_EXECUTE, Messages.getString("performance.execute", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御参照
		Property collectiverunRead =
			new Property(RoleConstant.COLLECTIVERUN_READ, Messages.getString("collectiverun.read", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御設定
		Property collectiverunWrite =
			new Property(RoleConstant.COLLECTIVERUN_WRITE, Messages.getString("collectiverun.write", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御実行
		Property collectiverunExecute =
			new Property(RoleConstant.COLLECTIVERUN_EXECUTE, Messages.getString("collectiverun.execute", locale), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視参照
		Property syslogngMonitorRead =
			new Property(RoleConstant.SYSLOGNG_MONITOR_READ, Messages.getString("syslogng.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視設定
		Property syslogngMonitorWrite =
			new Property(RoleConstant.SYSLOGNG_MONITOR_WRITE, Messages.getString("syslogng.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//Ping監視参照
		Property pingMonitorRead =
			new Property(RoleConstant.PING_MONITOR_READ, Messages.getString("ping.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//Ping監視設定
		Property pingMonitorWrite =
			new Property(RoleConstant.PING_MONITOR_WRITE, Messages.getString("ping.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//サービス・ポート監視参照
		Property portMonitorRead =
			new Property(RoleConstant.PORT_MONITOR_READ, Messages.getString("port.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//サービス・ポート監視設定
		Property portMonitorWrite =
			new Property(RoleConstant.PORT_MONITOR_WRITE, Messages.getString("port.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//プロセス監視参照
		Property processMonitorRead =
			new Property(RoleConstant.PROCESS_MONITOR_READ, Messages.getString("process.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//プロセス監視設定
		Property processMonitorWrite =
			new Property(RoleConstant.PROCESS_MONITOR_WRITE, Messages.getString("process.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SNMP監視参照
		Property snmpMonitorRead =
			new Property(RoleConstant.SNMP_MONITOR_READ, Messages.getString("snmp.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SNMP監視設定
		Property snmpMonitorWrite =
			new Property(RoleConstant.SNMP_MONITOR_WRITE, Messages.getString("snmp.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視参照
		Property snmptrapMonitorRead =
			new Property(RoleConstant.SNMPTRAP_MONITOR_READ, Messages.getString("snmptrap.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視設定
		Property snmptrapMonitorWrite =
			new Property(RoleConstant.SNMPTRAP_MONITOR_WRITE, Messages.getString("snmptrap.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SQL監視参照
		Property sqlMonitorRead =
			new Property(RoleConstant.SQL_MONITOR_READ, Messages.getString("sql.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SQL監視設定
		Property sqlMonitorWrite =
			new Property(RoleConstant.SQL_MONITOR_WRITE, Messages.getString("sql.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//エージェント監視参照
		Property agentMonitorRead =
			new Property(RoleConstant.AGENT_MONITOR_READ, Messages.getString("agent.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//エージェント監視設定
		Property agentMonitorWrite =
			new Property(RoleConstant.AGENT_MONITOR_WRITE, Messages.getString("agent.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//HTTP監視参照
		Property httpMonitorRead =
			new Property(RoleConstant.HTTP_MONITOR_READ, Messages.getString("http.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//HTTP監視設定
		Property httpMonitorWrite =
			new Property(RoleConstant.HTTP_MONITOR_WRITE, Messages.getString("http.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//ログ転送参照
		Property logTransferRead =
			new Property(RoleConstant.LOG_TRANSFER_READ, Messages.getString("logtransfer.read", locale), PropertyConstant.EDITOR_BOOL);
		//ログ転送設定
		Property logTransferWrite =
			new Property(RoleConstant.LOG_TRANSFER_WRITE, Messages.getString("logtransfer.write", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ参照
		Property calendarRead =
			new Property(RoleConstant.CALENDAR_READ, Messages.getString("calendar.read", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ設定
		Property calendarWrite =
			new Property(RoleConstant.CALENDAR_WRITE, Messages.getString("calendar.write", locale), PropertyConstant.EDITOR_BOOL);
		//通知参照
		Property notifyRead =
			new Property(RoleConstant.NOTIFY_READ, Messages.getString("notify.id.read", locale), PropertyConstant.EDITOR_BOOL);
		//通知設定
		Property notifyWrite =
			new Property(RoleConstant.NOTIFY_WRITE, Messages.getString("notify.id.write", locale), PropertyConstant.EDITOR_BOOL);
		//重要度判定参照
		Property priorityJudgmentRead =
			new Property(RoleConstant.PRIORITY_JUDGMENT_READ, Messages.getString("priority.judgment.read", locale), PropertyConstant.EDITOR_BOOL);
		//重要度判定設定
		Property priorityJudgmentWrite =
			new Property(RoleConstant.PRIORITY_JUDGMENT_WRITE, Messages.getString("priority.judgment.write", locale), PropertyConstant.EDITOR_BOOL);
		//メンテナンス参照
		Property maintenanceRead =
			new Property(RoleConstant.MAINTENANCE_READ, Messages.getString("maintenance.read", locale), PropertyConstant.EDITOR_BOOL);
		//メンテナンス設定
		Property maintenanceWrite =
			new Property(RoleConstant.MAINTENANCE_WRITE, Messages.getString("maintenance.write", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理参照
		Property vmManagementRead =
			new Property(RoleConstant.VMMANAGEMENT_READ, Messages.getString("vm.management.read", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理設定
		Property vmManagementWrite =
			new Property(RoleConstant.VMMANAGEMENT_WRITE, Messages.getString("vm.management.write", locale), PropertyConstant.EDITOR_BOOL);
		//仮想化管理実行
		Property vmManagementExecute =
			new Property(RoleConstant.VMMANAGEMENT_EXECUTE, Messages.getString("vm.management.execute", locale), PropertyConstant.EDITOR_BOOL);
		//障害検知参照
		Property troubleDetectionRead =
			new Property(RoleConstant.TROUBLE_DETECTION_READ, Messages.getString("trouble.detection.read", locale), PropertyConstant.EDITOR_BOOL);
		//障害検知設定
		Property troubleDetectionWrite =
			new Property(RoleConstant.TROUBLE_DETECTION_WRITE, Messages.getString("trouble.detection.write", locale), PropertyConstant.EDITOR_BOOL);

		//Webサービス実行
		Property webServiceExecute =
			new Property(RoleConstant.WEB_SERVICE_EXECUTE, Messages.getString("web.service.execute", locale), PropertyConstant.EDITOR_BOOL);
		
		//値を初期化
		uid.setValue("");
		name.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		access.setValue("");
		repositoryRead.setValue(Boolean.valueOf(true));
		repositoryWrite.setValue(Boolean.valueOf(false));
		accessRead.setValue(Boolean.valueOf(false));
		accessWrite.setValue(Boolean.valueOf(false));
		monitorRead.setValue(Boolean.valueOf(false));
		monitorWrite.setValue(Boolean.valueOf(false));
		jobManagementRead.setValue(Boolean.valueOf(false));
		jobManagementWrite.setValue(Boolean.valueOf(false));
		jobManagementExecute.setValue(Boolean.valueOf(false));
		performanceRead.setValue(Boolean.valueOf(false));
		performanceWrite.setValue(Boolean.valueOf(false));
		performanceExecute.setValue(Boolean.valueOf(false));
		collectiverunRead.setValue(Boolean.valueOf(false));
		collectiverunWrite.setValue(Boolean.valueOf(false));
		collectiverunExecute.setValue(Boolean.valueOf(false));
		syslogngMonitorRead.setValue(Boolean.valueOf(false));
		syslogngMonitorWrite.setValue(Boolean.valueOf(false));
		pingMonitorRead.setValue(Boolean.valueOf(false));
		pingMonitorWrite.setValue(Boolean.valueOf(false));
		portMonitorRead.setValue(Boolean.valueOf(false));
		portMonitorWrite.setValue(Boolean.valueOf(false));
		processMonitorRead.setValue(Boolean.valueOf(false));
		processMonitorWrite.setValue(Boolean.valueOf(false));
		snmpMonitorRead.setValue(Boolean.valueOf(false));
		snmpMonitorWrite.setValue(Boolean.valueOf(false));
		snmptrapMonitorRead.setValue(Boolean.valueOf(false));
		snmptrapMonitorWrite.setValue(Boolean.valueOf(false));
		sqlMonitorRead.setValue(Boolean.valueOf(false));
		sqlMonitorWrite.setValue(Boolean.valueOf(false));
		agentMonitorRead.setValue(Boolean.valueOf(false));
		agentMonitorWrite.setValue(Boolean.valueOf(false));
		httpMonitorRead.setValue(Boolean.valueOf(false));
		httpMonitorWrite.setValue(Boolean.valueOf(false));
		logTransferRead.setValue(Boolean.valueOf(false));
		logTransferWrite.setValue(Boolean.valueOf(false));
		calendarRead.setValue(Boolean.valueOf(false));
		calendarWrite.setValue(Boolean.valueOf(false));
		notifyRead.setValue(Boolean.valueOf(false));
		notifyWrite.setValue(Boolean.valueOf(false));
		priorityJudgmentRead.setValue(Boolean.valueOf(false));
		priorityJudgmentWrite.setValue(Boolean.valueOf(false));
		maintenanceRead.setValue(Boolean.valueOf(false));
		maintenanceWrite.setValue(Boolean.valueOf(false));
		vmManagementRead.setValue(Boolean.valueOf(false));
		vmManagementWrite.setValue(Boolean.valueOf(false));
		vmManagementExecute.setValue(Boolean.valueOf(false));
		troubleDetectionRead.setValue(Boolean.valueOf(false));
		troubleDetectionWrite.setValue(Boolean.valueOf(false));
		webServiceExecute.setValue(Boolean.valueOf(false));
		
		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			uid.setModify(PropertyConstant.MODIFY_OK);
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorRead.setModify(PropertyConstant.MODIFY_OK);
			monitorWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceWrite.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			portMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			portMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			logTransferRead.setModify(PropertyConstant.MODIFY_OK);
			logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
			maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
			maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementRead.setModify(PropertyConstant.MODIFY_OK);
			vmManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
			webServiceExecute.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			name.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
			accessRead.setModify(PropertyConstant.MODIFY_OK);
			accessWrite.setModify(PropertyConstant.MODIFY_OK);
			monitorRead.setModify(PropertyConstant.MODIFY_OK);
			monitorWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
			jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			performanceRead.setModify(PropertyConstant.MODIFY_OK);
			performanceWrite.setModify(PropertyConstant.MODIFY_OK);
			performanceExecute.setModify(PropertyConstant.MODIFY_OK);
			collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
			collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
			collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			portMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			portMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
			httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
			logTransferRead.setModify(PropertyConstant.MODIFY_OK);
			logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
			calendarRead.setModify(PropertyConstant.MODIFY_OK);
			calendarWrite.setModify(PropertyConstant.MODIFY_OK);
			notifyRead.setModify(PropertyConstant.MODIFY_OK);
			notifyWrite.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
			priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
			maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
			maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementRead.setModify(PropertyConstant.MODIFY_OK);
			vmManagementWrite.setModify(PropertyConstant.MODIFY_OK);
			vmManagementExecute.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
			troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
			webServiceExecute.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		property.addChildren(access);
		
		// アクセス権限ツリー
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorRead);
		access.addChildren(monitorWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceWrite);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(syslogngMonitorRead);
		access.addChildren(syslogngMonitorWrite);
		access.addChildren(pingMonitorRead);
		access.addChildren(pingMonitorWrite);
		access.addChildren(portMonitorRead);
		access.addChildren(portMonitorWrite);
		access.addChildren(processMonitorRead);
		access.addChildren(processMonitorWrite);
		access.addChildren(snmpMonitorRead);
		access.addChildren(snmpMonitorWrite);
		access.addChildren(snmptrapMonitorRead);
		access.addChildren(snmptrapMonitorWrite);
		access.addChildren(sqlMonitorRead);
		access.addChildren(sqlMonitorWrite);
		access.addChildren(agentMonitorRead);
		access.addChildren(agentMonitorWrite);
		access.addChildren(httpMonitorRead);
		access.addChildren(httpMonitorWrite);
		access.addChildren(logTransferRead);
		access.addChildren(logTransferWrite);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(priorityJudgmentRead);
		access.addChildren(priorityJudgmentWrite);
		access.addChildren(maintenanceRead);
		access.addChildren(maintenanceWrite);
		
		// VM管理オプションが適用されている場合
		if(HinemosProperties.isVmOptionEnable()){
			access.addChildren(vmManagementRead);
			access.addChildren(vmManagementWrite);
			access.addChildren(vmManagementExecute);
		}

		// Webサービス適用されている場合
		if(HinemosProperties.isWebServiceEnable()){
			access.addChildren(webServiceExecute);
		}
		
		return property;
	}
	
	/**
	 * 権限名の配列を返します。
	 * 
	 * @return 権限名の配列
	 */
	public static UserRoleList getRoleList() {
		return new UserRoleList(m_roles, m_readRoles, m_writeRoles, m_execRoles);
	}
}
