/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.bean;

/**
 * 実績グラフの表示範囲を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class GraphDisplayRange {
    private long startTime;

    private long endTime;

    /**
     * 実績グラフの表示範囲を保持するクラスのインスタンスを返す。
     *
     */
    public GraphDisplayRange() {
    }

    /**
     * 実績グラフの表示範囲を保持するクラスのインスタンスを返す。
     * 
     * @param startTime 表示範囲の開始時刻
     * @param endTime 表示範囲の終了時刻
     */
    public GraphDisplayRange(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    /**
     * 表示の最終時刻(ミリ秒) を戻します。
     * 
     * @return 表示の最終時刻(ミリ秒) を戻します。
     */
    public long getEndTime() {
        return endTime;
    }

    /**
     * 表示の最終時刻(ミリ秒) を設定。
     * 
     * @param endTime 表示の最終時刻(ミリ秒) を設定。
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * 表示の開始時刻(ミリ秒) を戻します。
     * 
     * @return 表示の開始時刻(ミリ秒) を戻します。
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * 表示の開始時刻(ミリ秒) を設定。
     * 
     * @param startTime 表示の開始時刻(ミリ秒) を設定。
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}