/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.nodemap.bean;

/**
 * 描画に利用するためのスコープ要素。
 * @since 1.0.0
 */
public class ScopeElement extends FacilityElement {
	private static final long serialVersionUID = 4185973963552875205L;
	
	// タイプ名定義
	public static final String TYPE = "scope";

	public static final String DEFAULT_ICON_IMEGE = "scope";
	
	public ScopeElement(String parentId, String facilityId, String facilityName, String iconImage, boolean valid) {
		setParentId(parentId);
		setFacilityId(facilityId);
		setFacilityName(facilityName);
		
		/*
		 * 将来、下記はsetIconImage(iconImage)にする予定。
		 * 現在、iconImageはnullになってしまう。
		 */
		setIconImage(DEFAULT_ICON_IMEGE);
		// スコープ単位での有効/無効は指定できないため、常に有効
		setValid(valid);
	}
	
	public String getTypeName(){
		return TYPE;
	}
}
