/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.PendingAction;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;

public class VirtualSocket
extends Socket {
    protected static final Logger log = Logger.getLogger(VirtualSocket.class);
    protected static Thread closingThread;
    private Map configuration = new HashMap();
    private MultiplexingManager manager;
    private Protocol protocol;
    private Socket actualSocket;
    private SocketId remoteSocketId;
    private SocketId localSocketId;
    private MultiplexingInputStream inputStream;
    private MultiplexingOutputStream outputStream;
    private Set disconnectListeners = new HashSet();
    private boolean bound = false;
    private boolean closed = false;
    private boolean connected = false;
    private boolean inputShutdown = false;
    private boolean outputShutdown = false;
    private boolean receivedDisconnectMessage = false;
    private int timeout;
    private Socket dummySocket;
    private boolean functional = true;
    private boolean trace;
    private boolean debug;
    private boolean info;

    public VirtualSocket(MultiplexingManager manager, SocketId remoteSocketId, Map configuration) throws IOException {
        this.manager = manager;
        this.actualSocket = manager.getSocket();
        this.remoteSocketId = remoteSocketId;
        this.configuration.putAll(configuration);
        this.protocol = manager.getProtocol();
        this.localSocketId = new SocketId();
        this.inputStream = manager.registerSocket(this);
        this.outputStream = manager.getAnOutputStream(this, remoteSocketId);
        this.bound = true;
        this.connected = true;
        this.trace = log.isTraceEnabled();
        this.debug = log.isDebugEnabled();
        this.info = log.isInfoEnabled();
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public VirtualSocket(Map configuration) {
        this.configuration.putAll(configuration);
    }

    public VirtualSocket() {
        log.debug("created unbound virtual socket");
    }

    public VirtualSocket(String host, int port) throws UnknownHostException, IOException {
        InetSocketAddress address = null;
        address = host == null ? new InetSocketAddress(InetAddress.getByName(null), port) : new InetSocketAddress(host, port);
        this.connect(address);
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public VirtualSocket(String host, int port, boolean stream) throws IOException {
        if (!stream) {
            throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
        }
        InetSocketAddress address = null;
        address = host == null ? new InetSocketAddress(InetAddress.getByName(null), port) : new InetSocketAddress(host, port);
        this.connect(address);
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public VirtualSocket(InetAddress address, int port) throws IOException {
        this.connect(new InetSocketAddress(address, port));
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public VirtualSocket(InetAddress host, int port, boolean stream) throws IOException {
        if (!stream) {
            throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
        }
        this.connect(new InetSocketAddress(host, port));
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public VirtualSocket(SocketImpl impl) throws SocketException {
        throw new SocketException("VirtualSocket does not use SocketImpl");
    }

    public VirtualSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(host), port, localAddr, localPort);
    }

    public VirtualSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this();
        this.connect(new InetSocketAddress(address, port), new InetSocketAddress(localAddr, localPort), 0);
        if (this.debug) {
            log.debug("created virtual socket on port: " + this.localSocketId.getPort());
        }
    }

    public void bind(SocketAddress address) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        if (inetAddress != null && inetAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.manager = MultiplexingManager.getaManagerByLocalAddress(inetAddress, this.configuration);
        this.actualSocket = this.manager.getSocket();
        this.localSocketId = new SocketId();
        if (this.debug) {
            log.debug("bound virtual socket to port: " + this.localSocketId.getPort());
        }
        this.bound = true;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug("closing: " + this.localSocketId);
        this.closed = true;
        if (this.connected && !this.receivedDisconnectMessage) {
            this.protocol.disconnect(this.remoteSocketId);
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        if (this.localSocketId != null) {
            this.localSocketId.releasePort();
        }
        if (this.manager.isSocketRegistered(this.localSocketId)) {
            MultiplexingManager.addToPendingActions(new PendingClose(this));
        }
        if (this.debug) {
            log.debug("virtual socket closed on port: " + this.localSocketId.getPort());
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, null, this.timeout);
    }

    public void connect(SocketAddress socketAddress, int timeout) throws IOException {
        this.connect(socketAddress, null, timeout);
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.actualSocket == null || !this.connected) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.inputStream;
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.actualSocket == null) {
            return false;
        }
        return this.actualSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        if (this.actualSocket == null) {
            if (this.dummySocket == null) {
                this.dummySocket = new Socket();
            }
            return this.dummySocket.getLocalAddress();
        }
        InetAddress address = this.actualSocket.getLocalAddress();
        try {
            if ("0.0.0.0".equals(address.getHostAddress())) {
                return InetAddress.getByName("localhost");
            }
        }
        catch (UnknownHostException e) {
            return address;
        }
        return address;
    }

    public int getLocalPort() {
        if (this.actualSocket == null) {
            return -1;
        }
        return this.actualSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        SocketAddress address = this.actualSocket.getLocalSocketAddress();
        InetSocketAddress socketAddress = null;
        if (address instanceof InetSocketAddress && ("0.0.0.0".equals((socketAddress = (InetSocketAddress)address).getHostName()) || socketAddress.getAddress() == null)) {
            return new InetSocketAddress("localhost", socketAddress.getPort());
        }
        return address;
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.actualSocket == null || !this.connected) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.outputStream;
    }

    public int getPort() {
        if (this.actualSocket == null) {
            return 0;
        }
        return this.actualSocket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.actualSocket == null) {
            if (this.dummySocket == null) {
                this.dummySocket = new Socket();
            }
            return this.dummySocket.getReceiveBufferSize();
        }
        return this.actualSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.actualSocket == null) {
            return null;
        }
        return this.actualSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.actualSocket == null) {
            return false;
        }
        return this.actualSocket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        if (this.actualSocket == null) {
            if (this.dummySocket == null) {
                this.dummySocket = new Socket();
            }
            return this.dummySocket.getSendBufferSize();
        }
        return this.actualSocket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        if (this.actualSocket == null) {
            return -1;
        }
        return this.actualSocket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.actualSocket == null) {
            return false;
        }
        return this.actualSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        if (this.actualSocket == null) {
            return 0;
        }
        return this.actualSocket.getTrafficClass();
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    public void sendUrgentData(int data) throws IOException {
        log.warn("sendUrgentData() called: ignored");
        if (this.isClosed()) {
            throw new IOException("Socket Closed");
        }
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setKeepAlive(on);
        }
    }

    public void setOOBInline(boolean on) throws SocketException {
        log.warn("setOOBInLine() called: ignored");
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setReuseAddress(on);
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setSendBufferSize(size);
        }
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setSoLinger(on, linger);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = timeout;
        if (this.inputStream != null) {
            this.inputStream.setTimeout(timeout);
        }
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setTcpNoDelay(on);
        }
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.actualSocket != null) {
            this.actualSocket.setTrafficClass(tc);
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.inputStream.setEOF();
        this.inputShutdown = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.outputStream.shutdown();
        this.outputShutdown = true;
        this.protocol.notifyOutputShutdown(this.remoteSocketId);
    }

    public String toString() {
        StringBuffer answer = new StringBuffer().append("VirtualSocket[");
        if (this.actualSocket == null) {
            answer.append("unbound");
        } else {
            answer.append(this.actualSocket.toString());
        }
        return answer.append("]").toString();
    }

    public void addDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.add(listener);
    }

    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, int timeout) throws IOException {
        log.debug("entering connect()");
        long start = System.currentTimeMillis();
        int timeLeft = 0;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (remoteInetSocketAddress.isUnresolved()) {
                security.checkConnect(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort());
            } else {
                security.checkConnect(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
            }
        }
        if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
            throw new SocketTimeoutException("connect timed out");
        }
        if (this.manager == null) {
            if (localAddress == null) {
                this.manager = MultiplexingManager.getaShareableManager(remoteInetSocketAddress, timeLeft, this.configuration);
            } else {
                InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
                this.manager = MultiplexingManager.getaShareableManagerByAddressPair(remoteInetSocketAddress, localInetSocketAddress, timeLeft, this.configuration);
            }
        }
        try {
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("connect timed out");
            }
            this.manager.connect(remoteInetSocketAddress, timeLeft);
            this.actualSocket = this.manager.getSocket();
            this.protocol = this.manager.getProtocol();
            if (!this.bound) {
                this.localSocketId = new SocketId();
                this.bound = true;
            }
            this.inputStream = this.manager.registerSocket(this);
            this.inputStream.setTimeout(timeout);
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("connect timed out");
            }
            this.remoteSocketId = this.protocol.connect(this.inputStream, this.localSocketId, timeLeft);
            this.outputStream = new MultiplexingOutputStream(this.manager, this, this.remoteSocketId);
        }
        catch (IOException e) {
            try {
                this.manager.unRegisterSocket(this);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("connect timed out");
            }
            throw e;
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.setTimeout(this.timeout);
            }
        }
        this.connected = true;
    }

    public MultiplexingManager getMultiplexingManager() {
        return this.manager;
    }

    public int getVirtualPort() {
        return this.remoteSocketId.getPort();
    }

    public int getLocalVirtualPort() {
        return this.localSocketId.getPort();
    }

    public SocketId getLocalSocketId() {
        return this.localSocketId;
    }

    public Socket getRealSocket() {
        return this.actualSocket;
    }

    public SocketId getRemoteSocketId() {
        return this.localSocketId;
    }

    public boolean isFunctional() {
        return this.functional;
    }

    public void removeDisconnectListener(DisconnectListener listener) {
        if (!this.disconnectListeners.remove(listener)) {
            log.error("attempt to remove unregistered DisconnectListener: " + listener);
        }
    }

    public void setConfiguration(Map configuration) {
        this.configuration.putAll(configuration);
    }

    protected Socket getActualSocket() {
        return this.actualSocket;
    }

    protected void setActualSocket(Socket actualSocket) {
        this.actualSocket = actualSocket;
    }

    protected void setBound(boolean bound) {
        this.bound = bound;
    }

    protected void setClosed(boolean closed) {
        this.closed = closed;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    protected void setInputShutdown(boolean inputShutdown) {
        this.inputShutdown = inputShutdown;
    }

    protected void setInputStream(MultiplexingInputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected void setLocalSocketId(SocketId localSocketId) {
        this.localSocketId = localSocketId;
    }

    protected MultiplexingManager getManager() {
        return this.manager;
    }

    protected void setManager(MultiplexingManager manager) {
        this.manager = manager;
    }

    protected void setOutputShutdown(boolean outputShutdown) {
        this.outputShutdown = outputShutdown;
    }

    protected void setOutputStream(MultiplexingOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected Protocol getProtocol() {
        return this.protocol;
    }

    protected void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    protected boolean hasReceivedDisconnectMessage() {
        return this.receivedDisconnectMessage;
    }

    protected void setReceivedDisconnectMessage(boolean receivedDisconnectMessage) {
        this.receivedDisconnectMessage = receivedDisconnectMessage;
    }

    protected void setRemoteSocketId(SocketId remoteSocketId) {
        this.remoteSocketId = remoteSocketId;
    }

    protected void doClose() {
        if (this.debug) {
            log.debug("doClose()" + this.localSocketId.getPort());
        }
        try {
            if (this.manager.isSocketRegistered(this.getLocalSocketId())) {
                this.manager.unRegisterSocket(this);
            }
            if (this.debug) {
                log.debug("virtual socket closed on port: " + this.remoteSocketId.getPort());
            }
        }
        catch (Exception e) {
            log.error("error closing socket: " + this);
            log.error(e);
        }
    }

    protected void handleRemoteOutputShutDown() throws IOException {
        try {
            this.inputStream.handleRemoteShutdown();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void handleRemoteDisconnect() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.debug) {
            log.debug("remote virtual socket disconnecting: local port: " + this.getLocalVirtualPort());
        }
        this.receivedDisconnectMessage = true;
        if (this.inputStream != null) {
            this.inputStream.handleRemoteShutdown();
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.handleRemoteDisconnect();
        }
        MultiplexingManager.addToPendingActions(new PendingRemoteDisconnect(this));
        log.debug("handleRemoteDisconnect(): done.");
    }

    protected void notifyOfException() {
        this.functional = false;
    }

    protected class PendingClose
    extends PendingAction {
        public PendingClose(Object o) {
            super(o);
        }

        public void doAction() {
            ((VirtualSocket)this.o).doClose();
        }
    }

    protected class PendingRemoteDisconnect
    extends PendingAction {
        public PendingRemoteDisconnect(Object o) {
            super(o);
        }

        void doAction() {
            VirtualSocket vs = (VirtualSocket)this.o;
            Set disconnectListeners = vs.disconnectListeners;
            Iterator it = disconnectListeners.iterator();
            while (it.hasNext()) {
                ((DisconnectListener)it.next()).notifyDisconnected(vs);
            }
        }
    }

    public static interface DisconnectListener {
        public void notifyDisconnected(VirtualSocket var1);
    }
}

