/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobInfoDAOImpl
implements JobInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobInfoDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobInfoPK pk, JobInfoBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobInfo data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setDescription(res.getString("description"));
                ejb.setJob_id(res.getString("job_id"));
                ejb.setJob_name(res.getString("job_name"));
                ejb.setJob_type(res.getInt("job_type"));
                if (res.getTimestamp("reg_date") != null) {
                    ejb.setReg_date(new Date(res.getTimestamp("reg_date").getTime()));
                } else {
                    ejb.setReg_date(null);
                }
                ejb.setReg_user(res.getString("reg_user"));
                ejb.setSession_id(res.getString("session_id"));
                if (res.getTimestamp("update_date") != null) {
                    ejb.setUpdate_date(new Date(res.getTimestamp("update_date").getTime()));
                } else {
                    ejb.setUpdate_date(null);
                }
                ejb.setUpdate_user(res.getString("update_user"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_info SET ");
                sql.append("job_name = ?, ");
                sql.append("description = ?, ");
                sql.append("job_type = ?, ");
                sql.append("reg_date = ?, ");
                sql.append("update_date = ?, ");
                sql.append("reg_user = ?, ");
                sql.append("update_user = ? ");
                sql.append("WHERE session_id = ? AND ");
                sql.append("job_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getJob_name());
                stmt.setString(2, ejb.getDescription());
                stmt.setInt(3, ejb.getJob_type());
                if (ejb.getReg_date() instanceof Date) {
                    stmt.setTimestamp(4, new Timestamp(ejb.getReg_date().getTime()));
                } else {
                    stmt.setTimestamp(4, null);
                }
                if (ejb.getUpdate_date() instanceof Date) {
                    stmt.setTimestamp(5, new Timestamp(ejb.getUpdate_date().getTime()));
                } else {
                    stmt.setTimestamp(5, null);
                }
                stmt.setString(6, ejb.getReg_user());
                stmt.setString(7, ejb.getUpdate_user());
                stmt.setString(8, ejb.getSession_id());
                stmt.setString(9, ejb.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobInfoPK create(JobInfoBean ejb) throws CreateException, EJBException {
        JobInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("job_name, ");
                sql.append("description, ");
                sql.append("job_type, ");
                sql.append("reg_date, ");
                sql.append("update_date, ");
                sql.append("reg_user, ");
                sql.append("update_user) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getSession_id());
                stmt.setString(2, ejb.getJob_id());
                stmt.setString(3, ejb.getJob_name());
                stmt.setString(4, ejb.getDescription());
                stmt.setInt(5, ejb.getJob_type());
                if (ejb.getReg_date() instanceof Date) {
                    stmt.setTimestamp(6, new Timestamp(ejb.getReg_date().getTime()));
                } else {
                    stmt.setTimestamp(6, null);
                }
                if (ejb.getUpdate_date() instanceof Date) {
                    stmt.setTimestamp(7, new Timestamp(ejb.getUpdate_date().getTime()));
                } else {
                    stmt.setTimestamp(7, null);
                }
                stmt.setString(8, ejb.getReg_user());
                stmt.setString(9, ejb.getUpdate_user());
                int row = stmt.executeUpdate();
                pk = new JobInfoPK(ejb.getSession_id(), ejb.getJob_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobInfoPK> ret = new ArrayList<JobInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT session_id, job_id FROM cc_job_info";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobInfoPK pk = new JobInfoPK(res.getString("session_id"), res.getString("job_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobInfoPK findByPrimaryKey(JobInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT session_id, job_id FROM cc_job_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobInfoPK jobInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection connMaster = null;
        Statement stmt = null;
        Statement stmtMaster = null;
        String jobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                connMaster = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("job_name, ");
                sql.append("description, ");
                sql.append("job_type, ");
                sql.append("reg_date, ");
                sql.append("update_date, ");
                sql.append("reg_user, ");
                sql.append("update_user) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                StringBuilder sqlMaster = new StringBuilder();
                sqlMaster.append("SELECT * FROM cc_job_mst ");
                sqlMaster.append("WHERE cc_job_mst.job_id = ?");
                stmtMaster = connMaster.prepareStatement(sqlMaster.toString());
                for (Hashtable ht : jobs) {
                    jobId = (String)ht.get("jobId");
                    stmtMaster.setString(1, jobId);
                    ResultSet resMaster = stmtMaster.executeQuery();
                    if (resMaster.next()) {
                        stmt.setString(2, resMaster.getString("job_id"));
                        stmt.setString(3, resMaster.getString("job_name"));
                        stmt.setString(4, resMaster.getString("description"));
                        stmt.setInt(5, resMaster.getInt("job_type"));
                        stmt.setTimestamp(6, resMaster.getTimestamp("reg_date"));
                        stmt.setTimestamp(7, resMaster.getTimestamp("update_date"));
                        stmt.setString(8, resMaster.getString("reg_user"));
                        stmt.setString(9, resMaster.getString("update_user"));
                        int row = stmt.executeUpdate();
                        if (row != 1) {
                            String msg = "result row is not 1";
                            m_log.error((Object)("makeSession() error : " + sessionId + ", " + resMaster.getString("job_id") + " SQLException"));
                            throw new EJBException(msg);
                        }
                    }
                    resMaster.close();
                }
                Object var16_16 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (stmtMaster != null) {
            stmtMaster.close();
        }
        if (connMaster != null) {
            connMaster.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

