/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.bean;

import com.clustercontrol.bean.FacilityInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FacilityTreeItem
implements Serializable {
    private static final long serialVersionUID = 1663475778653652044L;
    public static final String SEPARATOR = ">";
    private FacilityTreeItem parent = null;
    private FacilityInfo data = null;
    private List childrens = null;

    public FacilityTreeItem(FacilityTreeItem parent, FacilityInfo data) {
        this.setParent(parent);
        this.setData(data);
        if (parent != null) {
            parent.addChildren(this);
        }
        this.childrens = new ArrayList();
    }

    public FacilityTreeItem getParent() {
        return this.parent;
    }

    public void setParent(FacilityTreeItem parent) {
        this.parent = parent;
    }

    public FacilityInfo getData() {
        return this.data;
    }

    public void setData(FacilityInfo data) {
        this.data = data;
    }

    public void addChildren(FacilityTreeItem child) {
        child.setParent(this);
        this.childrens.add(child);
    }

    public int size() {
        return this.childrens.size();
    }

    public FacilityTreeItem[] getChildren() {
        FacilityTreeItem[] result = new FacilityTreeItem[this.size()];
        return this.childrens.toArray(result);
    }

    public boolean removeChild(String facilityId) {
        for (int i = 0; i < this.childrens.size(); ++i) {
            if (!facilityId.equals(((FacilityTreeItem)this.childrens.get(i)).getData().getFacilityId())) continue;
            this.childrens.remove(i);
            return true;
        }
        return false;
    }

    public boolean keepChild(String facilityId) {
        boolean ret = false;
        if (facilityId == null) {
            return ret;
        }
        for (int i = 0; i < this.childrens.size(); ++i) {
            if (facilityId.equals(((FacilityTreeItem)this.childrens.get(i)).getData().getFacilityId())) continue;
            this.childrens.remove(i);
            this.keepChild(facilityId);
            ret = true;
            break;
        }
        return ret;
    }

    public synchronized FacilityTreeItem deepCopy() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(this);
        out.flush();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        return (FacilityTreeItem)in.readObject();
    }
}

