/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.logagent.TransferLogManager;
import com.clustercontrol.logagent.util.LoggerSyslog;
import com.clustercontrol.util.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferLogThread
extends Thread {
    private static final String UNCHANGED_STATS_PERIOD = "unchanged.stats.period";
    private static final String FILE_MAX_SIZE = "file.max.size";
    private static final String LOG_ENCODING = "log.file.encoding";
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    public static final String HINEMOS_LOG_AGENT = "hinemos_log_agent";
    protected TransferLogManager m_transferLogManager;
    protected String m_filePath;
    protected int m_runInterval;
    protected int m_existenceFlg = 0;
    protected int m_unchangedStatsPeriod = 0;
    protected long m_fileMaxSize = 0L;
    protected boolean m_stopFlg = false;
    protected LoggerSyslog m_syslog = null;
    static Log log = LogFactory.getLog(TransferLogThread.class);
    private String m_logEncoding = "UTF-8";

    public TransferLogThread(TransferLogManager transferLogManager, Properties props, String path, int interval, int flg) {
        this.m_transferLogManager = transferLogManager;
        this.m_filePath = path;
        this.m_runInterval = interval * 1000;
        this.m_existenceFlg = flg;
        String sleepInterval = props.getProperty(UNCHANGED_STATS_PERIOD, "5");
        try {
            this.m_unchangedStatsPeriod = Integer.parseInt(sleepInterval) * 1000;
        }
        catch (NumberFormatException e) {
            log.error((Object)"TransferLogManager() : unchanged.stats.period", (Throwable)e);
        }
        String fileMaxSize = props.getProperty(FILE_MAX_SIZE, "2147483648");
        try {
            this.m_fileMaxSize = Long.parseLong(fileMaxSize);
        }
        catch (NumberFormatException e) {
            log.error((Object)"TransferLogManager() : file.max.size", (Throwable)e);
        }
        this.m_logEncoding = props.getProperty(LOG_ENCODING);
        if (this.m_logEncoding == null) {
            this.m_logEncoding = System.getProperty("file.encoding");
        }
        this.m_syslog = new LoggerSyslog(props);
    }

    public void run() {
        log.info((Object)("monitor start.  logfile : " + this.m_filePath + "  interval : " + this.m_runInterval + "s" + "  logfile encoding : " + this.m_logEncoding + "  syslog encoding : " + System.getProperty("file.encoding")));
        long filesize = 0L;
        long tmp_filesize = 0L;
        long n_unchanged_stats = 0L;
        byte[] cbuf = new byte[1024];
        byte[] carryOverBuf = new byte[]{};
        byte[] appendedBuf = null;
        File name = new File(this.m_filePath);
        RandomAccessFile fr = this.openFile(name, true, false);
        if (fr == null) {
            return;
        }
        String logPrefix = "hinemos_log_agent(" + this.m_filePath + "):";
        while (true) {
            try {
                Thread.sleep(this.m_runInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.m_stopFlg) {
                this.closeFile(fr);
                return;
            }
            try {
                tmp_filesize = fr.length();
                if (filesize == tmp_filesize) {
                    if (++n_unchanged_stats * (long)this.m_runInterval < (long)this.m_unchangedStatsPeriod) continue;
                    if (fr.length() != name.length() && tmp_filesize == fr.length()) {
                        log.info((Object)(this.m_filePath + ":\u30d5\u30a1\u30a4\u30eb\u304c\u5207\u66ff\u308a\u307e\u3057\u305f"));
                        this.closeFile(fr);
                        fr = this.openFile(name, false, false);
                        if (fr == null) {
                            return;
                        }
                        filesize = 0L;
                        carryOverBuf = new byte[]{};
                    }
                    n_unchanged_stats = 0L;
                    continue;
                }
                n_unchanged_stats = 0L;
                if (filesize < tmp_filesize) {
                    int read;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run() : " + this.m_filePath + " filesize " + filesize + "    tmp_filesize " + tmp_filesize));
                    }
                    StringBuffer sb = new StringBuffer();
                    while ((read = fr.read(cbuf)) != -1) {
                        int carryOverStart = read;
                        boolean returnCode = false;
                        for (int i = read - 1; i >= 0; --i) {
                            if (cbuf[i] != 10 && cbuf[i] != 13) continue;
                            carryOverStart = i + 1;
                            returnCode = true;
                            break;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run() : " + this.m_filePath + " read " + read + "    carryOverStart " + carryOverStart));
                        }
                        appendedBuf = new byte[carryOverBuf.length + carryOverStart];
                        ByteBuffer.wrap(carryOverBuf).get(appendedBuf, 0, carryOverBuf.length);
                        ByteBuffer.wrap(cbuf).get(appendedBuf, carryOverBuf.length, carryOverStart);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("run() : " + this.m_filePath + " appendedBuf size " + appendedBuf.length));
                        }
                        if (!returnCode) {
                            log.debug((Object)("run() : " + this.m_filePath + " return code is not exist"));
                            carryOverBuf = new byte[appendedBuf.length];
                            ByteBuffer.wrap(appendedBuf).get(carryOverBuf);
                            continue;
                        }
                        carryOverBuf = new byte[read - carryOverStart];
                        try {
                            if (read > carryOverStart) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("run() : " + this.m_filePath + " carryOverBuf size " + carryOverBuf.length));
                                }
                                ByteBuffer.wrap(cbuf, carryOverStart, carryOverBuf.length).get(carryOverBuf);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("run() : " + e.getMessage()), (Throwable)e);
                        }
                        try {
                            sb.append(new String(appendedBuf, 0, appendedBuf.length, this.m_logEncoding));
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error((Object)("run() : " + this.m_filePath + " " + e.getMessage()));
                        }
                    }
                    String tmpString = sb.toString();
                    String[] result = tmpString.split("\\n");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run() : " + this.m_filePath + " " + sb));
                        log.debug((Object)("run() : " + this.m_filePath + " size " + sb.length()));
                        log.debug((Object)("run() : " + this.m_filePath + " result size " + result.length));
                    }
                    if (sb.length() != 0) {
                        for (int x = 0; x < result.length; ++x) {
                            this.m_syslog.log(logPrefix + result[x]);
                        }
                    }
                    filesize = tmp_filesize;
                    continue;
                }
                if (filesize <= tmp_filesize) continue;
                log.info((Object)(this.m_filePath + ":\u5207\u8a70\u3081\u3089\u308c\u307e\u3057\u305f"));
                fr.seek(0L);
                filesize = 0L;
                carryOverBuf = new byte[]{};
                continue;
            }
            catch (IOException e) {
                log.error((Object)("run() : " + e.getMessage()));
                Object[] args = new Object[]{this.m_filePath};
                this.sendMessage(2, Messages.getString((String)"log.agent"), MESSAGE_ID_WARNING, Messages.getString((String)"message.log.agent.4"), Messages.getString((String)"message.log.agent.1", (Object[])args) + "\n" + e.getMessage());
                this.closeFile(fr);
                fr = this.openFile(name, false, true);
                if (fr == null) {
                    return;
                }
                filesize = 0L;
                carryOverBuf = new byte[]{};
                continue;
            }
            break;
        }
    }

    public void requestStop() {
        this.m_stopFlg = true;
        this.interrupt();
        log.info((Object)("monitor stop.   logfile : " + this.m_filePath + "  interval : " + this.m_runInterval + "s" + "  logfile encoding : " + this.m_logEncoding + "  syslog encoding : " + System.getProperty("file.encoding")));
    }

    private void sendMessage(int priority, String app, String msgId, String msg, String msgOrg) {
        this.m_transferLogManager.sendMessage(this.m_filePath, priority, app, msgId, msg, msgOrg);
    }

    private void closeFile(RandomAccessFile fr) {
        if (fr != null) {
            try {
                fr.close();
            }
            catch (IOException e) {
                log.debug((Object)("run() : " + e.getMessage()));
            }
        }
    }

    private RandomAccessFile openFile(File name, boolean init, boolean isOnErr) {
        boolean err = isOnErr;
        RandomAccessFile fr = null;
        do {
            Object[] args;
            try {
                fr = new RandomAccessFile(name, "r");
                long filesize = fr.length();
                if (filesize > this.m_fileMaxSize) {
                    Object[] args1 = new Object[]{this.m_filePath};
                    Object[] args2 = new Object[]{filesize};
                    this.sendMessage(3, Messages.getString((String)"log.agent"), MESSAGE_ID_INFO, Messages.getString((String)"message.log.agent.3"), Messages.getString((String)"message.log.agent.1", (Object[])args1) + ", " + Messages.getString((String)"message.log.agent.5", (Object[])args2));
                }
                if (init) {
                    fr.seek(filesize);
                }
                return fr;
            }
            catch (FileNotFoundException e) {
                if (init && !err) {
                    if (this.m_existenceFlg == 1) {
                        args = new Object[]{this.m_filePath};
                        this.sendMessage(3, Messages.getString((String)"log.agent"), MESSAGE_ID_INFO, Messages.getString((String)"message.log.agent.2"), Messages.getString((String)"message.log.agent.1", (Object[])args));
                    }
                    err = true;
                }
            }
            catch (SecurityException e) {
                if (!err) {
                    args = new Object[]{this.m_filePath};
                    this.sendMessage(2, Messages.getString((String)"log.agent"), MESSAGE_ID_WARNING, Messages.getString((String)"message.log.agent.4"), Messages.getString((String)"message.log.agent.1", (Object[])args) + "\n" + e.getMessage());
                    err = true;
                }
            }
            catch (IOException e) {
                if (!err) {
                    args = new Object[]{this.m_filePath};
                    this.sendMessage(3, Messages.getString((String)"log.agent"), MESSAGE_ID_INFO, Messages.getString((String)"message.log.agent.4"), Messages.getString((String)"message.log.agent.1", (Object[])args));
                    err = true;
                }
                this.closeFile(fr);
            }
            init = false;
            try {
                Thread.sleep(this.m_runInterval);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (!this.m_stopFlg);
        return null;
    }

    public void setCondition(int chkExistence, int interval) {
        this.m_existenceFlg = chkExistence;
        this.m_runInterval = interval * 1000;
    }

    public static void main(String[] args) {
    }
}

