/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoUtil;
import com.clustercontrol.repository.util.SendTopic;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyFacility {
    protected static Log m_log = LogFactory.getLog(ModifyFacility.class);
    public static int DEFAULT_SORT_ORDER = 100;

    public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
        this.addScope(parentFacilityId, property, DEFAULT_SORT_ORDER);
    }

    public void addScope(String parentFacilityId, Property property, int sortOrder) throws RemoveException, CreateException, NamingException {
        this.addScope(parentFacilityId, property, sortOrder, true);
    }

    public void addScope(String parentFacilityId, Property property, int sortOrder, boolean sendFlg) throws RemoveException, CreateException, NamingException {
        FacilityLocal facility;
        AccessLock.lock((String)"REPOSITORY");
        ArrayList facilityId = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
        ArrayList facilityName = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
        ArrayList description = PropertyUtil.getPropertyValue((Property)property, (String)"notes");
        try {
            facility = FacilityUtil.getLocalHome().create((String)facilityId.get(0), (String)facilityName.get(0), 0);
            facility.setDescription(this.checkString(description.get(0)));
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            m_log.debug((Object)("addScope() : " + e.getMessage()));
            throw e;
        }
        try {
            FacilityTreeLocal facilityTree = FacilityTreeUtil.getLocalHome().create((String)facilityId.get(0), 0, parentFacilityId, new Integer(sortOrder), new Boolean(false));
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            try {
                facility.remove();
            }
            catch (EJBException e1) {
                m_log.debug((Object)("addScope() : " + e.getMessage()));
                throw e1;
            }
            m_log.debug((Object)("addScope() : " + e.getMessage()));
            throw e;
        }
        if (sendFlg) {
            SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
        }
    }

    public void modifyScope(Property property) throws NamingException, FinderException {
        this.modifyScope(property, true);
    }

    public void modifyScope(Property property, boolean sendFlg) throws NamingException, FinderException {
        AccessLock.lock((String)"REPOSITORY");
        ArrayList facilityId = null;
        try {
            facilityId = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            ArrayList facilityName = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
            ArrayList description = PropertyUtil.getPropertyValue((Property)property, (String)"notes");
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId((String)facilityId.get(0));
            facility.setCn(this.checkString(facilityName.get(0)));
            facility.setDescription(this.checkString(description.get(0)));
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            m_log.debug((Object)("modifyScope() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            m_log.debug((Object)("modifyScope() : " + e.getMessage()));
            throw e;
        }
    }

    public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException, FinderException {
        this.assignNodeScope(parentFacilityId, facilityIds, true);
    }

    public void assignNodeScope(String parentFacilityId, String[] facilityIds, boolean sendFlg) throws NamingException, CreateException, FinderException {
        AccessLock.lock((String)"REPOSITORY");
        String facilityId = null;
        try {
            for (int i = 0; i < facilityIds.length; ++i) {
                facilityId = facilityIds[i];
                FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
                Boolean valid = facility.getValid();
                FacilityTreeLocal facilityTree = FacilityTreeUtil.getLocalHome().create(facilityId, 1, parentFacilityId, new Integer(DEFAULT_SORT_ORDER + 100), valid);
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId, parentFacilityId};
            apllog.put("SYS", "015", args);
            m_log.debug((Object)("assignNodeScope() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId, parentFacilityId};
            apllog.put("SYS", "015", args);
            m_log.debug((Object)("assignNodeScope() : " + e.getMessage()));
            throw e;
        }
    }

    public void addNode(Property property, String user) throws NamingException, CreateException {
        this.addNode(property, user, true);
    }

    public void addNode(Property property, String user, boolean sendFlg) throws NamingException, CreateException {
        AccessLock.lock((String)"REPOSITORY");
        String facilityId = null;
        try {
            String snmpOID;
            String displayName;
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            facilityId = this.checkString(values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
            String facilityName = this.checkString(values.get(0));
            FacilityLocal facility = FacilityUtil.getLocalHome().create(facilityId, facilityName, 1);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"characterSet");
            facility.setCharSet(this.checkString(values.get(0)));
            facility.setCreateTimestamp(now);
            facility.setCreatorsName(user);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            facility.setDescription(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"valid");
            facility.setValid((Boolean)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"dhcpClient");
            facility.setDhcpClient((Boolean)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"hostName");
            facility.setHost(this.checkArrayList(values));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
            facility.setIpNetworkNumber(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
            facility.setIpNetworkNumberV6(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressVersion");
            facility.setIpProtocolNumber(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressType");
            facility.setIpType(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"hardwareType");
            facility.setMachine(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"administrator");
            facility.setManagerName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"contact");
            facility.setManagerContact(this.checkString(values.get(0)));
            facility.setModifiersName(user);
            facility.setModifyTimestamp(now);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"nodeName");
            facility.setNodeName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osName");
            facility.setOsName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease");
            facility.setOsRelease(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osVersion");
            facility.setOsVersion(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"platformFamilyName");
            facility.setPlatform(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpPort");
            facility.setSnmpPort(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpCommunity");
            facility.setSnmpCommunity(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpVersion");
            facility.setSnmpVersion(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpTimeout");
            facility.setSnmpTimeout(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpRetries");
            facility.setSnmpRetries(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpProxy");
            facility.setSnmpProxy(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"note");
            facility.setNote(this.checkArrayList(values));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"iconImage");
            facility.setIconImage(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationNodeType");
            facility.setVirtNodeType(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vMManagementNode");
            facility.setVMManagementNode(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"VMINDEX");
            facility.setVmIndex(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"VMName");
            facility.setVmName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationSolution");
            facility.setVirtSolution(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmId");
            facility.setVmId(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmUser");
            facility.setVmUser(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmUserPassword");
            facility.setVmUserpassword(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmProtocol");
            facility.setVmProtocol(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUser");
            facility.setWbemUser(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUserPassword");
            facility.setWbemUserPassword(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemPort");
            facility.setWbemPort(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemProtocol");
            facility.setWbemProtocol(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemTimeout");
            facility.setWbemTimeout(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemRetries");
            facility.setWbemRetries(this.checkInteger(values.get(0)));
            facility.setSortValue(new Integer(DEFAULT_SORT_ORDER));
            ArrayList deviceList = PropertyUtil.getProperty((Property)property, (String)"device");
            for (int i = 0; i < deviceList.size(); ++i) {
                Property deviceProperty = (Property)deviceList.get(i);
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceIndex");
                Integer deviceIndex = this.checkInteger(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceType");
                String deviceType = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDisplayName");
                displayName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceName");
                String deviceName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceOID");
                snmpOID = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDescription");
                String description = this.checkString(values.get(0));
                if (deviceIndex == null && deviceName == null && deviceType == null && snmpOID == null && description == null) continue;
                DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(deviceIndex, deviceName, deviceType, snmpOID, description, facilityId, displayName);
            }
            ArrayList fileSystemList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
            for (int i = 0; i < fileSystemList.size(); ++i) {
                Property fileSystemProperty = (Property)fileSystemList.get(i);
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemIndex");
                Integer cn = this.checkInteger(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDisplayName");
                displayName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemMountPoint");
                String fileSystemMountPoint = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemOID");
                snmpOID = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemType");
                String fileSystemType = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDescription");
                String description = this.checkString(values.get(0));
                if (cn == null) continue;
                FileSystemInfoLocal fileSystem = FileSystemInfoUtil.getLocalHome().create(cn, fileSystemMountPoint, fileSystemType, snmpOID, description, facilityId, displayName);
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("addNode() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyNode(Property property, String user) throws NamingException, FinderException, CreateException {
        this.modifyNode(property, user, true);
    }

    public void modifyNode(Property property, String user, boolean sendFlg) throws NamingException, FinderException, CreateException {
        AccessLock.lock((String)"REPOSITORY");
        String facilityId = null;
        try {
            String snmpOID;
            String displayName;
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            facilityId = (String)values.get(0);
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
            facility.setCn(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"characterSet");
            facility.setCharSet(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            facility.setDescription(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"valid");
            facility.setValid((Boolean)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"dhcpClient");
            facility.setDhcpClient((Boolean)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"hostName");
            facility.setHost(this.checkArrayList(values));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
            facility.setIpNetworkNumber(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
            facility.setIpNetworkNumberV6(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressVersion");
            facility.setIpProtocolNumber(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressType");
            facility.setIpType(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"hardwareType");
            facility.setMachine(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"administrator");
            facility.setManagerName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"contact");
            facility.setManagerContact(this.checkString(values.get(0)));
            facility.setModifiersName(user);
            facility.setModifyTimestamp(now);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"nodeName");
            facility.setNodeName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osName");
            facility.setOsName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease");
            facility.setOsRelease(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osVersion");
            facility.setOsVersion(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"platformFamilyName");
            facility.setPlatform(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpPort");
            facility.setSnmpPort(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpCommunity");
            facility.setSnmpCommunity(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpVersion");
            facility.setSnmpVersion(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpTimeout");
            facility.setSnmpTimeout(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpRetries");
            facility.setSnmpRetries(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpProxy");
            facility.setSnmpProxy(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"note");
            facility.setNote(this.checkArrayList(values));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"iconImage");
            facility.setIconImage(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationNodeType");
            facility.setVirtNodeType(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vMManagementNode");
            facility.setVMManagementNode(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"VMINDEX");
            facility.setVmIndex(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"VMName");
            facility.setVmName(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"virtualizationSolution");
            facility.setVirtSolution(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmId");
            facility.setVmId(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmUser");
            facility.setVmUser(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmUserPassword");
            facility.setVmUserpassword(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"vmProtocol");
            facility.setVmProtocol(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUser");
            facility.setWbemUser(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUserPassword");
            facility.setWbemUserPassword(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemPort");
            facility.setWbemPort(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemProtocol");
            facility.setWbemProtocol(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemTimeout");
            facility.setWbemTimeout(this.checkInteger(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemRetries");
            facility.setWbemRetries(this.checkInteger(values.get(0)));
            try {
                Collection ct = facility.getDeviceInfo();
                Iterator itr = ct.iterator();
                DeviceInfoLocal device = null;
                while (itr.hasNext()) {
                    device = (DeviceInfoLocal)itr.next();
                    device.remove();
                }
            }
            catch (EJBException e) {
                m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            }
            catch (RemoveException e) {
                m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            }
            ArrayList deviceList = PropertyUtil.getProperty((Property)property, (String)"device");
            for (int i = 0; i < deviceList.size(); ++i) {
                Property deviceProperty = (Property)deviceList.get(i);
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceIndex");
                Integer deviceIndex = this.checkInteger(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceType");
                String deviceType = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDisplayName");
                displayName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceName");
                String deviceName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceOID");
                snmpOID = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDescription");
                String description = this.checkString(values.get(0));
                if (deviceIndex == null && deviceName == null && deviceType == null && snmpOID == null && description == null) continue;
                DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(deviceIndex, deviceName, deviceType, snmpOID, description, facilityId, displayName);
            }
            try {
                Collection ct = facility.getFileSystemInfo();
                Iterator itr = ct.iterator();
                FileSystemInfoLocal fileSystem = null;
                while (itr.hasNext()) {
                    fileSystem = (FileSystemInfoLocal)itr.next();
                    fileSystem.remove();
                }
            }
            catch (EJBException e) {
                m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            }
            catch (RemoveException e) {
                m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            }
            ArrayList fileSystemList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
            for (int i = 0; i < fileSystemList.size(); ++i) {
                Property fileSystemProperty = (Property)fileSystemList.get(i);
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemIndex");
                Integer cn = this.checkInteger(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDisplayName");
                displayName = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemMountPoint");
                String fileSystemMountPoint = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemOID");
                snmpOID = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemType");
                String fileSystemType = this.checkString(values.get(0));
                values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDescription");
                String description = this.checkString(values.get(0));
                if (cn == null) continue;
                FileSystemInfoLocal fileSystem = FileSystemInfoUtil.getLocalHome().create(cn, fileSystemMountPoint, fileSystemType, snmpOID, description, facilityId, displayName);
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "011", args);
            m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "011", args);
            m_log.debug((Object)("modifyNode() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyAllNode(Property property, String parentFacilityId, String user) throws NamingException, FinderException {
        this.modifyAllNode(property, parentFacilityId, user, true);
    }

    public void modifyAllNode(Property property, String parentFacilityId, String user, boolean sendFlg) throws NamingException, FinderException {
        AccessLock.lock((String)"REPOSITORY");
        try {
            Collection collection = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
                FacilityLocal facility = ft.getFacility();
                try {
                    FileSystemInfoLocal fileSystem;
                    ArrayList values = null;
                    Date now = new Date();
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
                    if (this.checkString(values.get(0)) != null) {
                        facility.setCn(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"characterSet")).get(0)) != null) {
                        facility.setCharSet(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"description")).get(0)) != null) {
                        facility.setDescription(this.checkString(values.get(0)));
                    }
                    if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"valid")).get(0) != null && values.get(0) instanceof Boolean) {
                        facility.setValid((Boolean)values.get(0));
                    }
                    if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"dhcpClient")).get(0) != null && values.get(0) instanceof Boolean) {
                        facility.setDhcpClient((Boolean)values.get(0));
                    }
                    if (this.checkArrayList((values = PropertyUtil.getPropertyValue((Property)property, (String)"hostName")).get(0)) != null) {
                        facility.setHost(this.checkArrayList(values));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4")).get(0)) != null) {
                        facility.setIpNetworkNumber(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6")).get(0)) != null) {
                        facility.setIpNetworkNumberV6(this.checkString(values.get(0)));
                    }
                    if (this.checkInteger((values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressVersion")).get(0)) != null) {
                        facility.setIpProtocolNumber(this.checkInteger(values.get(0)));
                    }
                    if (this.checkInteger((values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressType")).get(0)) != null) {
                        facility.setIpType(this.checkInteger(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"hardwareType")).get(0)) != null) {
                        facility.setMachine(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"administrator")).get(0)) != null) {
                        facility.setManagerName(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"contact")).get(0)) != null) {
                        facility.setManagerContact(this.checkString(values.get(0)));
                    }
                    facility.setModifiersName(user);
                    facility.setModifyTimestamp(now);
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"nodeName");
                    if (this.checkString(values.get(0)) != null) {
                        facility.setNodeName(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"osName")).get(0)) != null) {
                        facility.setOsName(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease")).get(0)) != null) {
                        facility.setOsRelease(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"osVersion")).get(0)) != null) {
                        facility.setOsVersion(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"platformFamilyName")).get(0)) != null) {
                        facility.setPlatform(this.checkString(values.get(0)));
                    }
                    if (this.checkInteger((values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpPort")).get(0)) != null) {
                        facility.setSnmpPort(this.checkInteger(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpCommunity")).get(0)) != null) {
                        facility.setSnmpCommunity(this.checkString(values.get(0)));
                    }
                    if (this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"snmpVersion")).get(0)) != null) {
                        facility.setSnmpVersion(this.checkString(values.get(0)));
                    }
                    values = PropertyUtil.getProperty((Property)property, (String)"snmpTimeout");
                    facility.setSnmpTimeout(this.checkInteger(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"snmpRetries");
                    facility.setSnmpRetries(this.checkInteger(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"snmpRetries");
                    facility.setSnmpProxy(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"note");
                    facility.setNote(this.checkArrayList(values));
                    values = PropertyUtil.getProperty((Property)property, (String)"iconImage");
                    facility.setIconImage(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"virtualizationNodeType");
                    facility.setVirtNodeType(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"vMManagementNode");
                    facility.setVMManagementNode(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"VMINDEX");
                    facility.setVmIndex(this.checkInteger(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"VMName");
                    facility.setVmName(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"virtualizationSolution");
                    facility.setVirtSolution(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"vmId");
                    facility.setVmId(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"vmUser");
                    facility.setVmUser(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"vmUserPassword");
                    facility.setVmUserpassword(this.checkString(values.get(0)));
                    values = PropertyUtil.getProperty((Property)property, (String)"vmProtocol");
                    facility.setVmProtocol(this.checkString(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUser");
                    facility.setWbemUser(this.checkString(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemUserPassword");
                    facility.setWbemUserPassword(this.checkString(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemPort");
                    facility.setWbemPort(this.checkInteger(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemProtocol");
                    facility.setWbemProtocol(this.checkString(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemTimeout");
                    facility.setWbemTimeout(this.checkInteger(values.get(0)));
                    values = PropertyUtil.getPropertyValue((Property)property, (String)"wbemRetries");
                    facility.setWbemRetries(this.checkInteger(values.get(0)));
                    ArrayList deviceList = PropertyUtil.getProperty((Property)property, (String)"device");
                    Property deviceProperty = (Property)deviceList.get(0);
                    values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceName");
                    if (deviceList.size() > 0 && this.checkString(values.get(0)) != null) {
                        try {
                            Collection ct = facility.getDeviceInfo();
                            Iterator itr1 = ct.iterator();
                            DeviceInfoLocal device = null;
                            while (itr.hasNext()) {
                                device = (DeviceInfoLocal)itr1.next();
                                device.remove();
                            }
                        }
                        catch (EJBException e) {
                            m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
                        }
                        catch (RemoveException e) {
                            m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
                        }
                    }
                    for (int i = 0; i < deviceList.size(); ++i) {
                        DeviceInfoLocal device;
                        deviceProperty = (Property)deviceList.get(i);
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceIndex");
                        Integer deviceIndex = this.checkInteger(values.get(0));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceType");
                        String deviceType = this.checkString(values.get(0));
                        if (deviceIndex == null || deviceType == null || deviceType.equals("") || (device = DeviceInfoUtil.getLocalHome().create(deviceIndex, deviceType, facility.getFacilityId())) == null) continue;
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDisplayName");
                        device.setDisplayName(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceName");
                        device.setDeviceName(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceIndex");
                        device.setDeviceIndex(this.checkInteger(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceOID");
                        device.setSnmpOID(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceType");
                        device.setDeviceType(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceDescription");
                        device.setDescription(this.checkString(values.get(0)));
                    }
                    ArrayList fileSystemList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
                    Property fileSystemProperty = (Property)fileSystemList.get(0);
                    values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemIndex");
                    if (fileSystemList.size() > 0 && this.checkString(values.get(0)) != null) {
                        try {
                            Collection ct = facility.getDeviceInfo();
                            Iterator itr1 = ct.iterator();
                            fileSystem = null;
                            while (itr.hasNext()) {
                                fileSystem = (FileSystemInfoLocal)itr1.next();
                                fileSystem.remove();
                            }
                        }
                        catch (EJBException e) {
                            m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
                        }
                        catch (RemoveException e) {
                            m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
                        }
                    }
                    for (int i = 0; i < fileSystemList.size(); ++i) {
                        fileSystemProperty = (Property)fileSystemList.get(i);
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemIndex");
                        Integer cn = this.checkInteger(values.get(0));
                        if (cn == null || (fileSystem = FileSystemInfoUtil.getLocalHome().create(cn, facility.getFacilityId())) == null) continue;
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDisplayName");
                        fileSystem.setDisplayName(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemMountPoint");
                        fileSystem.setFileSystemMountPoint(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemOID");
                        fileSystem.setSnmpOID(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemType");
                        fileSystem.setFileSystemType(this.checkString(values.get(0)));
                        values = PropertyUtil.getPropertyValue((Property)fileSystemProperty, (String)"fileSystemDescription");
                        fileSystem.setDescription(this.checkString(values.get(0)));
                    }
                }
                catch (CreateException e) {
                    m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
                }
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (EJBException e) {
            m_log.debug((Object)("modifyAllNode() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyFacilityTreeValid(Property property) throws FinderException, NamingException {
        this.modifyFacilityTreeValid(property, true);
    }

    public void modifyFacilityTreeValid(Property property, boolean sendFlg) throws FinderException, NamingException {
        AccessLock.lock((String)"REPOSITORY");
        String facilityId = null;
        ArrayList values = null;
        Date now = new Date();
        try {
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            facilityId = (String)values.get(0);
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"valid");
            Boolean postValid = (Boolean)values.get(0);
            Collection collection = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId, postValid == false);
            for (FacilityTreeLocal facilitytree : collection) {
                facilitytree.setValid(postValid);
            }
            if (sendFlg) {
                SendTopic.sendTopic("topic/clustercontrolRepositoryUpdate");
            }
        }
        catch (FinderException e) {
            m_log.error((Object)"modifyFacilityTreeValid() : findByFacilityId() failure ", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)"modifyFacilityTreeValid() : getLocalHome() failure ", (Throwable)e);
            throw e;
        }
    }

    public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
        AccessLock.lock((String)"REPOSITORY");
        try {
            Object attribute;
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            if (attributes.get("cn") != null) {
                attribute = (String)attributes.get("cn");
                facility.setCn((String)attribute);
            }
            if (attributes.get("description") != null) {
                attribute = (String)attributes.get("description");
                facility.setDescription((String)attribute);
            }
            if (attributes.get("ccValid") != null) {
                attribute = (Boolean)attributes.get("ccValid");
                facility.setValid((Boolean)attribute);
            }
            if (attributes.get("ccAgentControl") != null) {
                attribute = (Boolean)attributes.get("ccAgentControl");
                facility.setAgentControl((Boolean)attribute);
            }
            if (attributes.get("ccAgentWatch") != null) {
                attribute = (Boolean)attributes.get("ccAgentWatch");
                facility.setAgentWatch((Boolean)attribute);
            }
            if (attributes.get("ccAgentWatchStatus") != null) {
                attribute = (Boolean)attributes.get("ccAgentWatchStatus");
                facility.setAgentWatchStatus((Boolean)attribute);
            }
            if (attributes.get("ccCharSet") != null) {
                attribute = (String)attributes.get("ccCharSet");
                facility.setCharSet((String)attribute);
            }
            if (attributes.get("ccCreateTimestamp") != null) {
                attribute = (Date)attributes.get("ccCreateTimestamp");
                facility.setCreateTimestamp((Date)attribute);
            }
            if (attributes.get("ccCreatorsName") != null) {
                attribute = (String)attributes.get("ccCreatorsName");
                facility.setCreatorsName((String)attribute);
            }
            if (attributes.get("ccDhcpClient") != null) {
                attribute = (Boolean)attributes.get("ccDhcpClient");
                facility.setDhcpClient((Boolean)attribute);
            }
            if (attributes.get("host") != null) {
                attribute = (ArrayList)attributes.get("host");
                facility.setHost((ArrayList)attribute);
            }
            if (attributes.get("ipNetworkNumber") != null) {
                attribute = (String)attributes.get("ipNetworkNumber");
                facility.setIpNetworkNumber((String)attribute);
            }
            if (attributes.get("ccIpNetworkNumberV6") != null) {
                attribute = (String)attributes.get("ccIpNetworkNumberV6");
                facility.setIpNetworkNumberV6((String)attribute);
            }
            if (attributes.get("ipProtocolNumber") != null) {
                attribute = (Integer)attributes.get("ipProtocolNumber");
                facility.setIpProtocolNumber((Integer)attribute);
            }
            if (attributes.get("ccIpType") != null) {
                attribute = (Integer)attributes.get("ccIpType");
                facility.setIpType((Integer)attribute);
            }
            if (attributes.get("ccLogWatch") != null) {
                attribute = (Boolean)attributes.get("ccLogWatch");
                facility.setLogWatch((Boolean)attribute);
            }
            if (attributes.get("ccMachine") != null) {
                attribute = (String)attributes.get("ccMachine");
                facility.setMachine((String)attribute);
            }
            if (attributes.get("ccManagerContact") != null) {
                attribute = (String)attributes.get("ccManagerContact");
                facility.setManagerContact((String)attribute);
            }
            if (attributes.get("ccManagerName") != null) {
                attribute = (String)attributes.get("ccManagerName");
                facility.setManagerName((String)attribute);
            }
            if (attributes.get("ccModifiersName") != null) {
                attribute = (String)attributes.get("ccModifiersName");
                facility.setModifiersName((String)attribute);
            }
            if (attributes.get("ccModifyTimestamp") != null) {
                attribute = (Date)attributes.get("ccModifyTimestamp");
                facility.setModifyTimestamp((Date)attribute);
            }
            if (attributes.get("ccNodeName") != null) {
                attribute = (String)attributes.get("ccNodeName");
                facility.setNodeName((String)attribute);
            }
            if (attributes.get("ccOsName") != null) {
                attribute = (String)attributes.get("ccOsName");
                facility.setOsName((String)attribute);
            }
            if (attributes.get("ccOsRelease") != null) {
                attribute = (String)attributes.get("ccOsRelease");
                facility.setOsRelease((String)attribute);
            }
            if (attributes.get("ccOsVersion") != null) {
                attribute = (String)attributes.get("ccOsVersion");
                facility.setOsVersion((String)attribute);
            }
            if (attributes.get("ccPingWatch") != null) {
                attribute = (Boolean)attributes.get("ccPingWatch");
                facility.setPingWatch((Boolean)attribute);
            }
            if (attributes.get("ccPingWatchStatus") != null) {
                attribute = (Boolean)attributes.get("ccPingWatchStatus");
                facility.setPingWatchStatus((Boolean)attribute);
            }
            if (attributes.get("ccPlatform") != null) {
                attribute = (String)attributes.get("ccPlatform");
                facility.setPlatform((String)attribute);
            }
            if (attributes.get("ccStatusWatch") != null) {
                attribute = (Boolean)attributes.get("ccStatusWatch");
                facility.setStatusWatch((Boolean)attribute);
            }
            if (attributes.get("ccSnmpPort") != null) {
                attribute = (Integer)attributes.get("ccSnmpPort");
                facility.setSnmpPort((Integer)attribute);
            }
            if (attributes.get("ccSnmpCommunity") != null) {
                attribute = (String)attributes.get("ccSnmpCommunity");
                facility.setSnmpCommunity((String)attribute);
            }
            if (attributes.get("ccSnmpTimeout") != null) {
                attribute = (Integer)attributes.get("ccSnmpTimeout");
                facility.setSnmpTimeout((Integer)attribute);
            }
            if (attributes.get("ccSnmpVersion") != null) {
                attribute = (Integer)attributes.get("ccSnmpRetries");
                facility.setSnmpRetries((Integer)attribute);
            }
            if (attributes.get("ccSnmpProxy") != null) {
                attribute = (String)attributes.get("ccSnmpProxy");
                facility.setSnmpProxy((String)attribute);
            }
            if (attributes.get("ccNote") != null) {
                attribute = (ArrayList)attributes.get("ccNote");
                facility.setNote((ArrayList)attribute);
            }
            if (attributes.get("ccIconImage") != null) {
                attribute = (String)attributes.get("ccIconImage");
                facility.setIconImage((String)attribute);
            }
            if (attributes.get("ccVirtualizationNodeType") != null) {
                attribute = (String)attributes.get("ccVirtualizationNodeType");
                facility.setVirtNodeType((String)attribute);
            }
            if (attributes.get("ccVMManagementNode") != null) {
                attribute = (String)attributes.get("ccVMManagementNode");
                facility.setVMManagementNode((String)attribute);
            }
            if (attributes.get("ccVMINDEX") != null) {
                attribute = (Integer)attributes.get("ccVMINDEX");
                facility.setVmIndex((Integer)attribute);
            }
            if (attributes.get("ccVMName") != null) {
                attribute = (String)attributes.get("ccVMName");
                facility.setVmName((String)attribute);
            }
            if (attributes.get("ccVirtualizationSolution") != null) {
                attribute = (String)attributes.get("ccVirtualizationSolution");
                facility.setVirtSolution((String)attribute);
            }
            if (attributes.get("ccVMId") != null) {
                attribute = (String)attributes.get("ccVMId");
                facility.setVmId((String)attribute);
            }
            if (attributes.get("ccVMUser") != null) {
                attribute = (String)attributes.get("ccVMUser");
                facility.setVmUser((String)attribute);
            }
            if (attributes.get("ccVMUserPassword") != null) {
                attribute = (String)attributes.get("ccVMUserPassword");
                facility.setVmUserpassword((String)attribute);
            }
            if (attributes.get("ccVMProtocol") != null) {
                attribute = (String)attributes.get("ccVMProtocol");
                facility.setVmProtocol((String)attribute);
            }
            if (attributes.get("ccWbemUser") != null) {
                attribute = (String)attributes.get("ccWbemUser");
                facility.setWbemUser((String)attribute);
            }
            if (attributes.get("ccWbemUserPassword") != null) {
                attribute = (String)attributes.get("ccWbemUserPassword");
                facility.setWbemUserPassword((String)attribute);
            }
            if (attributes.get("ccWbemPort") != null) {
                attribute = (Integer)attributes.get("ccWbemPort");
                facility.setWbemPort((Integer)attribute);
            }
            if (attributes.get("ccWbemProtocol") != null) {
                attribute = (String)attributes.get("ccWbemProtocol");
                facility.setWbemProtocol((String)attribute);
            }
            if (attributes.get("ccWbemTimeout") != null) {
                attribute = (Integer)attributes.get("ccWbemTimeout");
                facility.setWbemTimeout((Integer)attribute);
            }
            if (attributes.get("ccWbemRetries") != null) {
                attribute = (Integer)attributes.get("ccWbemRetries");
                facility.setWbemRetries((Integer)attribute);
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)("setNodeDetail() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("setNodeDetail() : " + e.getMessage()));
            throw e;
        }
    }

    protected Integer checkInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    protected String checkString(Object value) {
        if (value instanceof String) {
            if (((String)value).compareTo("") == 0) {
                return null;
            }
            return (String)value;
        }
        return null;
    }

    protected ArrayList checkArrayList(Object value) {
        if (value instanceof ArrayList) {
            boolean checkNull = true;
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                if (this.checkString(list.get(i)) != null) {
                    list.set(i, this.checkString(list.get(i)));
                    checkNull = false;
                    continue;
                }
                if (this.checkInteger(list.get(i)) != null) {
                    list.set(i, this.checkInteger(list.get(i)));
                    checkNull = false;
                    continue;
                }
                list.set(i, null);
            }
            if (checkNull) {
                list = null;
            }
            return list;
        }
        return null;
    }
}

