/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobParamInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobParamInfoDAOImpl
implements JobParamInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobParamInfoDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobParamInfoPK pk, JobParamInfoBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getParam_id());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobParamInfo data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setDescription(res.getString("description"));
                ejb.setJob_id(res.getString("job_id"));
                ejb.setParam_id(res.getString("param_id"));
                ejb.setParam_type(res.getInt("param_type"));
                ejb.setSession_id(res.getString("session_id"));
                ejb.setValue(res.getString("value"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobParamInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_param_info SET ");
                sql.append("param_type = ?, ");
                sql.append("description = ?, ");
                sql.append("value = ? ");
                sql.append("WHERE session_id = ? ");
                sql.append("AND job_id = ? ");
                sql.append("AND param_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setInt(1, ejb.getParam_type());
                stmt.setString(2, ejb.getDescription());
                stmt.setString(3, ejb.getValue());
                stmt.setString(4, ejb.getSession_id());
                stmt.setString(5, ejb.getJob_id());
                stmt.setString(6, ejb.getParam_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobParamInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getParam_id());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobParamInfoPK create(JobParamInfoBean ejb) throws CreateException, EJBException {
        JobParamInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_param_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("param_id, ");
                sql.append("param_type, ");
                sql.append("description, ");
                sql.append("value) ");
                sql.append("VALUES (?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getSession_id());
                stmt.setString(2, ejb.getJob_id());
                stmt.setString(3, ejb.getParam_id());
                stmt.setInt(4, ejb.getParam_type());
                stmt.setString(5, ejb.getDescription());
                stmt.setString(6, ejb.getValue());
                int row = stmt.executeUpdate();
                pk = new JobParamInfoPK(ejb.getSession_id(), ejb.getJob_id(), ejb.getParam_id());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_param_info";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobParamInfoPK pk = new JobParamInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("param_id"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobParamInfoPK findByPrimaryKey(JobParamInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getParam_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobParamInfoPK jobParamInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobParamInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndJobId() start : " + session_id + ", " + job_id));
        ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, session_id);
                stmt.setString(2, job_id);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobParamInfoPK pk = new JobParamInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("param_id"));
                    ret.add(pk);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findBySessionIdAndJobId() end : " + session_id + ", " + job_id));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findBySessionIdAndParamId(String session_id, String param_id) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndParamId() start : " + session_id + ", " + param_id));
        ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND param_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, session_id);
                stmt.setString(2, param_id);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobParamInfoPK pk = new JobParamInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("param_id"));
                    ret.add(pk);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findBySessionIdAndParamId() error : " + session_id + ", " + param_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndParamId() error : " + session_id + ", " + param_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findBySessionIdAndParamId() error : " + session_id + ", " + param_id + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findBySessionIdAndParamId() end : " + session_id + ", " + param_id));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, String jobId, OutputNotifyGroupInfo info) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection connMaster = null;
        Statement stmt = null;
        Statement stmtMaster = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                connMaster = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_param_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("param_id, ");
                sql.append("param_type, ");
                sql.append("description, ");
                sql.append("value) ");
                sql.append("VALUES (?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                String topJobId = JobRelationMasterUtil.getLocalHome().getTopJobId(jobId);
                String sqlMaster = "SELECT * FROM cc_job_param_mst WHERE job_id = ?";
                stmtMaster = connMaster.prepareStatement(sqlMaster);
                stmtMaster.setString(1, topJobId);
                ResultSet resMaster = stmtMaster.executeQuery();
                while (resMaster.next()) {
                    String value;
                    block19: {
                        block18: {
                            int paramType = resMaster.getInt("param_type");
                            String paramId = resMaster.getString("param_id");
                            value = null;
                            if (paramType != 0) break block18;
                            int functionType = ParameterUtil.checkFunctionType(paramId);
                            if (functionType == 1) {
                                value = ParameterUtil.getJobParameterValue(sessionId, paramId);
                                break block19;
                            } else if (functionType == 2) {
                                value = ParameterUtil.getParameterValue(paramId, info);
                            }
                            break block19;
                        }
                        value = resMaster.getString("value");
                    }
                    stmt.setString(2, jobId);
                    stmt.setString(3, resMaster.getString("param_id"));
                    stmt.setInt(4, resMaster.getInt("param_type"));
                    stmt.setString(5, resMaster.getString("description"));
                    stmt.setString(6, value);
                    int row = stmt.executeUpdate();
                    if (row == 1) continue;
                    String msg = "result row is not 1";
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                    throw new EJBException(msg);
                }
                resMaster.close();
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (stmtMaster != null) {
            stmtMaster.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (connMaster != null) {
            connMaster.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

