/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.monitor.bean.ScopeInfoData;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.factory.SelectEvent;
import com.clustercontrol.monitor.factory.SelectStatus;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocalHome;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectScope {
    protected static Log m_log = LogFactory.getLog(SelectScope.class);

    public ArrayList<ScopeInfoData> getScopeList(String facilityId) throws CreateException, FinderException, NamingException {
        ArrayList<ScopeInfoData> list = new ArrayList<ScopeInfoData>();
        SelectStatus selectStatus = new SelectStatus();
        SelectEvent selectEvent = new SelectEvent();
        int parentPriority = 4;
        String parentFacilityId = null;
        String parentFacilityPath = null;
        Date parentOutputDate = null;
        try {
            EventLogLocal event;
            StatusInfoLocal status;
            ScopeInfoData scopeInfo;
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            FacilityTreeLocalHome ftHome = FacilityTreeUtil.getLocalHome();
            if (facilityId != null && !"".equals(facilityId) && (scopeInfo = this.getHighPriorityScope(status = selectStatus.getHighPriorityStatus(facilityId, -1), event = selectEvent.getHighPriorityEvent(facilityId, -1), repository, facilityId, facilityId)) != null) {
                parentPriority = scopeInfo.getPriority();
                parentFacilityId = scopeInfo.getFacilityId();
                parentFacilityPath = scopeInfo.getFacilityPath();
                parentOutputDate = scopeInfo.getOutputDate();
            }
            ArrayList facilityIdList = repository.getFacilityIdList(facilityId, 1);
            String[] facilityIds = null;
            if (facilityIdList != null && facilityIdList.size() > 0) {
                facilityIds = new String[facilityIdList.size()];
                facilityIdList.toArray(facilityIds);
            } else if (facilityId != null) {
                facilityIds = new String[]{facilityId};
            } else {
                return null;
            }
            boolean statusInfoFlg = false;
            boolean eventLogFlg = false;
            boolean highPriorityFlg = false;
            for (int index = 0; facilityIds != null && index < facilityIds.length; ++index) {
                EventLogLocal event2;
                StatusInfoLocal status2;
                ScopeInfoData scopeInfo2;
                if (!facilityIds[index].equals(facilityId) && (scopeInfo2 = this.getHighPriorityScope(status2 = selectStatus.getHighPriorityStatus(facilityIds[index], 0), event2 = selectEvent.getHighPriorityEvent(facilityIds[index], 0), repository, facilityIds[index], facilityId)) != null) {
                    Collection fts = ftHome.findByFacilityId(facilityIds[index]);
                    Iterator it = fts.iterator();
                    if (fts.size() != 0) {
                        FacilityTreeLocal ftl = (FacilityTreeLocal)it.next();
                        Integer sortValue = ftl.getSortValue();
                        scopeInfo2.setSortValue(sortValue);
                    }
                    list.add(scopeInfo2);
                    if (parentPriority > scopeInfo2.getPriority()) {
                        highPriorityFlg = true;
                    } else if (parentPriority == scopeInfo2.getPriority()) {
                        if (parentOutputDate != null) {
                            if (parentOutputDate.before(scopeInfo2.getOutputDate())) {
                                highPriorityFlg = true;
                            }
                        } else {
                            highPriorityFlg = true;
                        }
                    }
                    if (highPriorityFlg) {
                        parentPriority = scopeInfo2.getPriority();
                        parentOutputDate = scopeInfo2.getOutputDate();
                        if (parentFacilityId == null && facilityId != null && !"".equals(facilityId)) {
                            parentFacilityId = facilityId;
                            parentFacilityPath = repository.getFacilityPath(facilityId, facilityId);
                        }
                    }
                }
                statusInfoFlg = false;
                eventLogFlg = false;
                highPriorityFlg = false;
            }
            if (parentFacilityId != null) {
                ScopeInfoData scopeInfo3 = new ScopeInfoData(parentFacilityId, parentFacilityPath, parentPriority, parentOutputDate, 0);
                list.add(scopeInfo3);
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getScopeList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    private ScopeInfoData getHighPriorityScope(StatusInfoLocal status, EventLogLocal event, RepositoryControllerLocal repository, String facilityId, String parentFacilityId) throws CreateException, FinderException, NamingException {
        ArrayList info = new ArrayList();
        ScopeInfoData scopeInfo = new ScopeInfoData();
        boolean statusInfoFlg = false;
        boolean eventLogFlg = false;
        if (status == null && event == null) {
            return null;
        }
        if (status != null && event == null) {
            statusInfoFlg = true;
        } else if (status == null && event != null) {
            eventLogFlg = true;
        } else if (status != null && event != null) {
            if (status.getPriority() < event.getPriority()) {
                statusInfoFlg = true;
            } else if (status.getPriority() > event.getPriority()) {
                eventLogFlg = true;
            } else if (status.getPriority().intValue() == event.getPriority().intValue()) {
                if (status.getOutputDate().after(event.getOutputDate())) {
                    statusInfoFlg = true;
                } else {
                    eventLogFlg = true;
                }
            }
        }
        String facilityPath = repository.getFacilityPath(facilityId, parentFacilityId);
        if (statusInfoFlg) {
            scopeInfo.setPriority(status.getPriority());
            scopeInfo.setFacilityId(facilityId);
            scopeInfo.setFacilityPath(facilityPath);
            scopeInfo.setOutputDate(status.getOutputDate());
        } else if (eventLogFlg) {
            scopeInfo.setPriority(event.getPriority());
            scopeInfo.setFacilityId(facilityId);
            scopeInfo.setFacilityPath(facilityPath);
            scopeInfo.setOutputDate(event.getOutputDate());
        }
        return scopeInfo;
    }
}

