/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.entity.EventLogData;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class ModifyEventConfirm {
    protected static Log m_log = LogFactory.getLog(ModifyEventConfirm.class);
    public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    public static final String OBJECT_NAME = "jboss.j2ee:jndiName=EventLog,service=EJB";
    public static final String OPERATION_NAME = "flushCache";

    public void modifyConfirm(List list, int confirmType, String confirmUser) throws NamingException, FinderException {
        if (list != null && list.size() > 0) {
            Date confirmDate = null;
            if (confirmType == 1) {
                confirmDate = new Date();
            }
            EventLogData event2 = null;
            for (EventLogData event2 : list) {
                if (event2 == null) continue;
                this.modifyConfirm(event2.getMonitorId(), event2.getPluginId(), event2.getFacilityId(), new Date(event2.getOutputDate().getTime()), confirmDate, confirmType, confirmUser);
            }
        }
    }

    public void modifyConfirm(String monitorId, String pluginId, String facilityId, Date outputDate, Date confirmDate, int confirmType, String confirmUser) throws NamingException, FinderException {
        try {
            EventLogPK pk = new EventLogPK(monitorId, pluginId, facilityId, new Timestamp(outputDate.getTime()));
            EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);
            event.setConfirmFlg(new Integer(confirmType));
            if (confirmType == 1) {
                if (confirmDate == null) {
                    confirmDate = new Date();
                }
                event.setConfirmDate(new Timestamp(confirmDate.getTime()));
            }
            event.setConfirmUser(confirmUser);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, ConfirmConstant.typeToString((int)confirmType)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("modifyConfirm():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, monitorId, pluginId, ConfirmConstant.typeToString((int)confirmType)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("modifyConfirm():" + e.getMessage()));
            throw e;
        }
    }

    public void modifyBatchConfirm(int confirmType, String facilityId, Property property, String confirmUser) throws CreateException, NamingException, FinderException, SQLException {
        ArrayList values = null;
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        try {
            int priorityType;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    facilityIds = new String[]{facilityId};
                }
            }
            Integer selectConfirmFlg = null;
            if (confirmType == 1) {
                selectConfirmFlg = new Integer(0);
            } else if (confirmType == 0) {
                selectConfirmFlg = new Integer(1);
            }
            Integer confirmFlg = new Integer(confirmType);
            EventLogUtil.getLocalHome().batchConfirm(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, selectConfirmFlg, confirmFlg, confirmUser);
        }
        catch (CreateException e) {
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType, confirmUser);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType, confirmUser);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            this.setAplLogForBatchConfirmFailure(facilityId, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, facilityType, application, message, confirmType, confirmUser);
            m_log.debug((Object)("modifyBatchConfirm():" + e.getMessage()));
            throw e;
        }
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            server.invoke(name, OPERATION_NAME, null, null);
        }
        catch (NamingException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("modifyBatchConfirm() : " + e.getMessage()));
        }
    }

    private void setAplLogForBatchConfirmFailure(String facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String facilityType, String application, String message, int confirmType, String confirmUser) {
        int priorityInt = -1;
        String outputFromDateString = null;
        String outputToDateString = null;
        String generationFromDateString = null;
        String generationToDateString = null;
        if (priority != null) {
            priorityInt = priority;
        }
        if (outputFromDate != null) {
            outputFromDateString = outputFromDate.toString();
        }
        if (outputToDate != null) {
            outputToDateString = outputToDate.toString();
        }
        if (generationFromDate != null) {
            generationFromDateString = generationFromDate.toString();
        }
        if (generationToDate != null) {
            generationToDateString = generationToDate.toString();
        }
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmType), confirmUser};
        apllog.put("SYS", "005", args);
    }
}

