/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Log;

public final class PackageSorter {
    private PackageSorter() {
    }

    public static void sort(List list) {
        int n;
        int n2;
        SortModule sortModule;
        HashMap<String, SortModule> hashMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> arrayList = new ArrayList<PackageState>();
        ArrayList<SortModule> arrayList2 = new ArrayList<SortModule>();
        for (int i = 0; i < list.size(); ++i) {
            PackageState packageState = (PackageState)list.get(i);
            if (packageState.getState() == -2) {
                arrayList.add(packageState);
                continue;
            }
            sortModule = new SortModule(packageState);
            arrayList2.add(sortModule);
            hashMap.put(packageState.getModule().getModuleClass(), sortModule);
        }
        Object[] objectArray = arrayList2.toArray(new SortModule[arrayList2.size()]);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            sortModule = objectArray[n2];
            sortModule.setDependSubsystems(PackageSorter.collectSubsystemModules(sortModule.getState().getModule(), hashMap));
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n3 = PackageSorter.searchModulePosition((SortModule)object, hashMap);
                if (n3 == ((SortModule)object).getPosition()) continue;
                ((SortModule)object).setPosition(n3);
                n2 = 1;
            }
        }
        Arrays.sort(objectArray);
        list.clear();
        for (n = 0; n < objectArray.length; ++n) {
            list.add(((SortModule)objectArray[n]).getState());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list.add(arrayList.get(n));
        }
    }

    private static int searchModulePosition(SortModule sortModule, HashMap hashMap) {
        SortModule sortModule2;
        Object object;
        int n;
        Module module = sortModule.getState().getModule();
        int n2 = 0;
        ModuleInfo[] moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = moduleInfoArray[n].getModuleClass();
            sortModule2 = (SortModule)hashMap.get(object);
            if (sortModule2 == null || sortModule2.getPosition() < n2) continue;
            n2 = sortModule2.getPosition() + 1;
        }
        moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = moduleInfoArray[n].getModuleClass();
            sortModule2 = (SortModule)hashMap.get(object);
            if (sortModule2.getPosition() < n2) continue;
            n2 = sortModule2.getPosition() + 1;
        }
        String string = module.getSubSystem();
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            Module module2;
            sortModule2 = (SortModule)object.next();
            if (sortModule2.getState().getModule() == module || string.equals((module2 = sortModule2.getState().getModule()).getSubSystem()) || !sortModule.getDependSubsystems().contains(module2.getSubSystem()) || PackageSorter.isBaseModule(module2, module) || sortModule2.getPosition() < n2) continue;
            n2 = sortModule2.getPosition() + 1;
        }
        return n2;
    }

    private static boolean isBaseModule(Module module, ModuleInfo moduleInfo) {
        int n;
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            if (!moduleInfoArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            if (!moduleInfoArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        return false;
    }

    private static ArrayList collectSubsystemModules(Module module, HashMap hashMap) {
        Object object;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = (SortModule)hashMap.get(moduleInfoArray[n].getModuleClass());
            if (object == null) {
                Log.warn(new Log.SimpleMessage("A dependent module was not found in the list of known modules.", moduleInfoArray[n].getModuleClass()));
                continue;
            }
            arrayList.add(((SortModule)object).getState().getModule().getSubSystem());
        }
        moduleInfoArray = module.getOptionalModules();
        for (n = 0; n < moduleInfoArray.length; ++n) {
            object = (Module)hashMap.get(moduleInfoArray[n].getModuleClass());
            if (object == null) {
                Log.warn("A dependent module was not found in the list of known modules.");
                continue;
            }
            arrayList.add(object.getSubSystem());
        }
        return arrayList;
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        public SortModule(PackageState packageState) {
            this.state = packageState;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public void setDependSubsystems(ArrayList arrayList) {
            this.dependSubsystems = arrayList;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public PackageState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SortModule: ");
            stringBuffer.append(this.position);
            stringBuffer.append(" ");
            stringBuffer.append(this.state.getModule().getName());
            stringBuffer.append(" ");
            stringBuffer.append(this.state.getModule().getModuleClass());
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            SortModule sortModule = (SortModule)object;
            if (this.position > sortModule.position) {
                return 1;
            }
            if (this.position < sortModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

