/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.util.Messages;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class StringVerifyListener
implements VerifyListener {
    protected Integer length;

    public StringVerifyListener(int length) {
        this.length = new Integer(length);
    }

    public void verifyText(VerifyEvent e) {
        Text text = (Text)e.getSource();
        StringBuilder input = new StringBuilder(text.getText());
        if (e.keyCode == 0) {
            input.replace(e.start, e.end, e.text);
        } else if (e.character == '\b' || e.character == '\u007f') {
            input.delete(e.start, e.end);
        } else {
            input.replace(e.start, e.end, e.text);
        }
        this.checkLength(e, input.toString());
    }

    private void checkLength(VerifyEvent e, String inputText) {
        try {
            if (inputText.getBytes("UTF-8").length > this.length) {
                e.doit = false;
                Object[] args = new String[]{this.length.toString()};
                MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.hinemos.7", args));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            e.doit = false;
        }
    }
}

