/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.view;

import com.clustercontrol.accesscontrol.composite.UserListComposite;
import com.clustercontrol.accesscontrol.composite.action.UserListSelectionChangedListener;
import com.clustercontrol.bean.Property;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class UserListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.accesscontrol.view.UserListView";
    private UserListComposite m_userList = null;
    private Property m_condition = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_userList = new UserListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_userList.setLayoutData(gridData);
        this.createContextMenu();
        this.m_userList.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new UserListSelectionChangedListener());
        this.update();
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_userList.getTable());
        this.m_userList.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem userAdd = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.UserAddAction");
        ActionContributionItem userModify = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.UserModifyAction");
        ActionContributionItem userDelete = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.UserDeleteAction");
        ActionContributionItem modifyPassword = (ActionContributionItem)toolbar.find("com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction");
        manager.add(userAdd.getAction());
        manager.add(userModify.getAction());
        manager.add(userDelete.getAction());
        manager.add(modifyPassword.getAction());
    }

    public Property getFilterCondition() {
        return this.m_condition;
    }

    public void setFilterCondition(Property condition) {
        this.m_condition = condition;
    }

    public void update() {
        if (this.m_condition == null) {
            this.m_userList.update();
        } else {
            this.m_userList.update(this.m_condition);
        }
    }

    public void update(Property condition) {
        this.m_condition = condition;
        this.update();
    }

    public UserListComposite getComposite() {
        return this.m_userList;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserModifyAction", true);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserDeleteAction", true);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserModifyAction", false);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.UserDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.accesscontrol.view.action.ModifyPasswordAction", false);
        }
    }
}

