/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dialog;

import com.clustercontrol.performance.composite.RecordSetItemComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RealtimeSetDialog
extends Dialog {
    private Composite composite = null;
    private Composite composite2 = null;
    private RecordSetItemComposite itemComposite = null;
    private Group group4 = null;
    private Combo combo = null;
    private int comboSetting;
    private RealtimeCollectorInfo collectorInfo = null;
    private RealtimeCollectorItemInfo collectorItemInfo = null;
    private boolean isInterval = false;

    public RealtimeSetDialog(Shell parent) {
        super(parent);
        Display display = parent.getDisplay();
        parent.setLocation((display.getBounds().width - parent.getSize().x) / 2, (display.getBounds().height - parent.getSize().y) / 2);
        this.initialize();
    }

    private void initialize() {
    }

    public void update() {
        this.collectorItemInfo.refreshItemInfoForDialog();
        switch (this.collectorInfo.getInterval()) {
            case 5: {
                this.comboSetting = 0;
                break;
            }
            case 15: {
                this.comboSetting = 1;
                break;
            }
            case 30: {
                this.comboSetting = 2;
                break;
            }
            case 60: {
                this.comboSetting = 3;
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(450, 640);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SET_REALTIME_GRAPH_DIALOG_TITLE"));
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.composite.setLayout((Layout)new FormLayout());
        this.createComposite2();
        return this.composite;
    }

    private void createComposite2() {
        this.composite2 = new Composite(this.composite, 0);
        FormData composite2Data = new FormData();
        composite2Data.top = new FormAttachment(0, 0);
        composite2Data.bottom = new FormAttachment(100, 0);
        composite2Data.right = new FormAttachment(100, 0);
        composite2Data.left = new FormAttachment(0, 0);
        this.composite2.setLayoutData((Object)composite2Data);
        int i = 0;
        while (i < 4) {
            this.itemComposite = new RecordSetItemComposite(this.composite2, 0);
            GridLayout gridLayout00 = new GridLayout();
            gridLayout00.numColumns = 3;
            this.itemComposite.setLayout((Layout)gridLayout00);
            GridData gridDataGroup = new GridData(768);
            this.itemComposite.setLayoutData(gridDataGroup);
            this.itemComposite.setCollectorItemInfo(this.collectorItemInfo);
            this.itemComposite.update(i);
            ++i;
        }
        this.createIntervalGroup();
        this.composite2.setLayout((Layout)new GridLayout());
    }

    private void createIntervalGroup() {
        this.group4 = new Group(this.composite2, 0);
        GridData gridDataGroup4 = new GridData(768);
        this.group4.setLayoutData((Object)gridDataGroup4);
        this.group4.setText(Messages.getString("GRAPH_REFRESH_INTERVAL_IN_JP"));
        GridLayout gridLayoutRefresh = new GridLayout();
        this.group4.setLayout((Layout)gridLayoutRefresh);
        this.combo = new Combo((Composite)this.group4, 8);
        GridData gridDataRefresh = new GridData(1040);
        this.combo.setLayoutData((Object)gridDataRefresh);
        if (this.isInterval) {
            this.combo.add(Messages.getString("5SEC"));
            this.combo.add(Messages.getString("15SEC"));
            this.combo.add(Messages.getString("30SEC"));
            this.combo.add(Messages.getString("1MIN"));
            this.combo.select(this.comboSetting);
        }
        this.combo.setEnabled(this.isInterval);
    }

    protected void okPressed() {
        this.collectorItemInfo.copyItemInfoForDialog();
        if (this.isInterval) {
            if (this.combo.getSelectionIndex() == 0) {
                this.collectorInfo.setInterval(5);
                this.collectorInfo.setRequestInterval(5);
            } else if (this.combo.getSelectionIndex() == 1) {
                this.collectorInfo.setInterval(15);
                this.collectorInfo.setRequestInterval(15);
            } else if (this.combo.getSelectionIndex() == 2) {
                this.collectorInfo.setInterval(30);
                this.collectorInfo.setRequestInterval(30);
            } else if (this.combo.getSelectionIndex() == 3) {
                this.collectorInfo.setInterval(60);
                this.collectorInfo.setRequestInterval(60);
            }
        }
        super.okPressed();
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
        this.collectorInfo = collectorInfo;
    }

    public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
        this.collectorItemInfo = collectorItemInfo;
    }

    public void setInterval(boolean isInterval) {
        this.isInterval = isInterval;
    }
}

