/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public class ResolveExpression
extends CompositeExpression {
    private String fVariable;
    private Object[] fArgs;
    private static final String ATT_VARIABLE = "variable";
    private static final String ATT_ARGS = "args";

    public ResolveExpression(IConfigurationElement configElement) throws CoreException {
        this.fVariable = configElement.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable);
        this.fArgs = Expressions.getArguments(configElement, ATT_ARGS);
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object variable = context.resolveVariable(this.fVariable, this.fArgs);
        if (variable == null) {
            throw new CoreException((IStatus)new ExpressionStatus(301, Messages.format(ExpressionMessages.ResolveExpression_variable_not_defined, this.fVariable)));
        }
        return this.evaluateAnd(new EvaluationContext(context, variable));
    }
}

