/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapRunManagementLocal;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapRunManagementUtil;
import com.clustercontrol.snmptrap.factory.TrapSnmp;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.ReceiveRepositoryTopic;
import com.clustercontrol.snmptrap.util.ReceiveSnmpTrapTopic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapSnmpManager {
    protected static Log m_log = LogFactory.getLog(TrapSnmpManager.class);
    public static final String PLUGIN_ID = "SNMPTRAP";
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    public static final String REGEX_PREFIX = "%parm\\[#";
    public static final String REGEX_SUFFIX = "\\]%";
    protected static final ArrayList<String> m_attributeList = new ArrayList();
    protected Map<String, ArrayList<String>> m_ipAddressMap = new ConcurrentHashMap<String, ArrayList<String>>();
    protected Map<String, ArrayList<String>> m_hostNameMap = new ConcurrentHashMap<String, ArrayList<String>>();
    protected Map<String, SnmpTrapFacilityInfo> m_snmpTrapInfoMap = null;
    protected TrapSnmp m_trapSnmp = null;
    protected ReceiveRepositoryTopic m_receiveRepositoryTopic = null;
    protected ReceiveSnmpTrapTopic m_receiveSnmpTrapTopic = null;
    protected SendQueue m_sendQueue = null;
    protected RepositoryControllerLocal m_repository;

    public void exec() {
        try {
            this.m_sendQueue = new SendQueue("queue/clustercontrol/SnmpTrap/SnmpTrapNotify");
            this.m_repository = RepositoryControllerUtil.getLocalHome().create();
            this.updateCache();
            this.m_receiveRepositoryTopic = new ReceiveRepositoryTopic(this);
            this.m_receiveSnmpTrapTopic = new ReceiveSnmpTrapTopic(this);
            this.m_trapSnmp = new TrapSnmp(this);
            this.m_trapSnmp.exec();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (CreateException e) {
            e.printStackTrace();
        }
    }

    public void terminate() {
        if (this.m_trapSnmp != null) {
            this.m_trapSnmp.terminate();
        }
        if (this.m_receiveRepositoryTopic != null) {
            this.m_receiveRepositoryTopic.terminate();
        }
        if (this.m_receiveSnmpTrapTopic != null) {
            this.m_receiveSnmpTrapTopic.terminate();
        }
    }

    public boolean find(Date trapDate, String communityName, String trapOid, int genericId, int specificId, String[] varBind, ArrayList<String> facilityIdList, String agentAdder) {
        m_log.debug((Object)("find() : start" + trapOid));
        if (this.m_snmpTrapInfoMap == null) {
            return true;
        }
        Set<String> set = this.m_snmpTrapInfoMap.keySet();
        for (String monitorId : set) {
            String communityNameCache;
            SnmpTrapFacilityInfo info = this.m_snmpTrapInfoMap.get(monitorId);
            if (info == null || !(communityNameCache = info.getCommunityName()).equals(communityName)) continue;
            ArrayList<String> facilityIdListCache = info.getFacilityIdList();
            ArrayList<String> targetFacilityIdList = new ArrayList<String>(facilityIdList);
            targetFacilityIdList.retainAll(facilityIdListCache);
            if (targetFacilityIdList.size() <= 0) continue;
            if (info.getCheckMode() == 1 || info.getCheckMode() == 2) {
                for (int j = 0; j < targetFacilityIdList.size(); ++j) {
                    String facilityId = targetFacilityIdList.get(j);
                    SnmpTrapMessageInfo message = new SnmpTrapMessageInfo(monitorId, facilityId, trapDate, trapOid, genericId, specificId, varBind, agentAdder);
                    try {
                        this.m_sendQueue.put((Serializable)message);
                        continue;
                    }
                    catch (JMSException e) {
                        m_log.error((Object)("find() : \u901a\u77e5\u5931\u6557\u3002" + e.getMessage()));
                        return false;
                    }
                }
                continue;
            }
            ArrayList<SnmpTrapOidInfo> oidListCache = info.getOidList();
            for (int index = 0; index < oidListCache.size(); ++index) {
                SnmpTrapOidInfo oidInfo = oidListCache.get(index);
                if (!trapOid.equals(oidInfo.getTrapOid()) || genericId != oidInfo.getGenericId() || specificId != oidInfo.getSpecificId()) continue;
                for (int j = 0; j < targetFacilityIdList.size(); ++j) {
                    String facilityId = targetFacilityIdList.get(j);
                    SnmpTrapMessageInfo message = new SnmpTrapMessageInfo(monitorId, facilityId, trapDate, trapOid, genericId, specificId, varBind, agentAdder);
                    try {
                        this.m_sendQueue.put((Serializable)message);
                        continue;
                    }
                    catch (JMSException e) {
                        m_log.error((Object)("find() : \u901a\u77e5\u5931\u6557\u3002" + e.getMessage()));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void updateCache() {
        this.updateSnmpTrapInfo();
        this.updateRepositoryInfo();
    }

    public boolean updateCache(UpdateSnmpTrapInfo updateInfo) {
        String monitorId = updateInfo.getMonitorId();
        int type = updateInfo.getType();
        boolean updateRepositoryFlg = true;
        try {
            if (type == 0) {
                MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
                SnmpTrapFacilityInfo info = management.getSnmpTrapInfo(monitorId);
                if (info != null) {
                    this.m_snmpTrapInfoMap.put(monitorId, info);
                } else {
                    updateRepositoryFlg = false;
                }
            } else if (type == 1) {
                MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
                SnmpTrapFacilityInfo info = management.getSnmpTrapInfo(monitorId);
                if (info != null) {
                    SnmpTrapFacilityInfo infoCache = this.m_snmpTrapInfoMap.get(monitorId);
                    if (infoCache != null) {
                        String facilityIdCache = infoCache.getFacilityId();
                        if (facilityIdCache.equals(info.getFacilityId())) {
                            updateRepositoryFlg = false;
                        }
                        this.m_snmpTrapInfoMap.remove(monitorId);
                    }
                    this.m_snmpTrapInfoMap.put(monitorId, info);
                } else {
                    this.m_snmpTrapInfoMap.remove(monitorId);
                }
            } else if (type == 2) {
                this.m_snmpTrapInfoMap.remove(monitorId);
            }
            if (updateRepositoryFlg) {
                this.updateRepositoryInfo();
            }
            return true;
        }
        catch (CreateException e) {
            m_log.error((Object)("updateCache(UpdateSnmpTrapInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        catch (FinderException e) {
            m_log.error((Object)("updateCache(UpdateSnmpTrapInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.error((Object)("updateCache(UpdateSnmpTrapInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        this.m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
        return false;
    }

    public boolean updateCache(UpdateRepositoryInfo updateInfo) {
        ArrayList<String> facilityIdList = new ArrayList<String>();
        if (this.m_snmpTrapInfoMap != null) {
            try {
                RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                Set<String> set = this.m_snmpTrapInfoMap.keySet();
                for (String monitorId : set) {
                    SnmpTrapFacilityInfo info = this.m_snmpTrapInfoMap.get(monitorId);
                    if (info == null) continue;
                    String facilityId = info.getFacilityId();
                    ArrayList tmpFacilityIdList = null;
                    if (repository.isNode(facilityId)) {
                        tmpFacilityIdList = new ArrayList();
                        tmpFacilityIdList.add(facilityId);
                    } else if (facilityId.equals("UNREGISTERED")) {
                        tmpFacilityIdList = new ArrayList();
                        tmpFacilityIdList.add("UNREGISTERED");
                    } else {
                        tmpFacilityIdList = repository.getNodeFacilityIdList(facilityId, 0);
                    }
                    info.setFacilityIdList(tmpFacilityIdList);
                    if (tmpFacilityIdList == null || tmpFacilityIdList.size() <= 0) continue;
                    facilityIdList.addAll(tmpFacilityIdList);
                }
                this.updateRepositoryInfo(facilityIdList);
                return true;
            }
            catch (CreateException e) {
                m_log.error((Object)("updateCache(UpdateRepositoryInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
            }
            catch (FinderException e) {
                m_log.error((Object)("updateCache(UpdateRepositoryInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
            }
            catch (NamingException e) {
                m_log.error((Object)("updateCache(UpdateRepositoryInfo) : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
            }
            this.m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
            return false;
        }
        return true;
    }

    public boolean updateSnmpTrapInfo() {
        m_log.debug((Object)"updateSnmpTrapInfo(): start");
        this.m_snmpTrapInfoMap = new ConcurrentHashMap<String, SnmpTrapFacilityInfo>();
        try {
            MonitorSnmpTrapRunManagementLocal management = MonitorSnmpTrapRunManagementUtil.getLocalHome().create();
            this.m_snmpTrapInfoMap = management.getSnmpTrapMap();
            return true;
        }
        catch (CreateException e) {
            m_log.error((Object)("updateSnmpTrapInfo() : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.error((Object)("updateSnmpTrapInfo() : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        catch (FinderException e) {
            m_log.error((Object)("updateSnmpTrapInfo() : SNMPTRAP\u76e3\u8996\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        return false;
    }

    public boolean updateRepositoryInfo() {
        ArrayList<String> facilityIdList = new ArrayList<String>();
        if (this.m_snmpTrapInfoMap != null) {
            Set<String> set = this.m_snmpTrapInfoMap.keySet();
            for (String monitorId : set) {
                ArrayList<String> tmpFacilityIdList;
                SnmpTrapFacilityInfo info = this.m_snmpTrapInfoMap.get(monitorId);
                if (info == null || (tmpFacilityIdList = info.getFacilityIdList()) == null || tmpFacilityIdList.size() <= 0) continue;
                facilityIdList.addAll(tmpFacilityIdList);
            }
        }
        boolean result = this.updateRepositoryInfo(facilityIdList);
        return result;
    }

    public boolean updateRepositoryInfo(ArrayList<String> facilityIdList) {
        this.m_ipAddressMap = new ConcurrentHashMap<String, ArrayList<String>>();
        this.m_hostNameMap = new ConcurrentHashMap<String, ArrayList<String>>();
        try {
            if (facilityIdList != null && facilityIdList.size() > 0) {
                HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityIdList, m_attributeList);
                Set keySet = facilityAttrMap.keySet();
                for (String facilityId : keySet) {
                    ArrayList<String> tmpFacilityIdList;
                    HashMap map = (HashMap)facilityAttrMap.get(facilityId);
                    String ipNetworkNumber = (String)map.get("ipNetworkNumber");
                    String hostName = (String)facilityAttrMap.get("ccNodeName");
                    if (ipNetworkNumber != null && !"".equals(ipNetworkNumber)) {
                        tmpFacilityIdList = this.m_ipAddressMap.get(ipNetworkNumber);
                        if (tmpFacilityIdList == null) {
                            tmpFacilityIdList = new ArrayList();
                        }
                        if (!tmpFacilityIdList.contains(facilityId)) {
                            tmpFacilityIdList.add(facilityId);
                        }
                        this.m_ipAddressMap.put(ipNetworkNumber, tmpFacilityIdList);
                    }
                    if (hostName == null || "".equals(hostName)) continue;
                    tmpFacilityIdList = this.m_hostNameMap.get(hostName);
                    if (tmpFacilityIdList == null) {
                        tmpFacilityIdList = new ArrayList();
                    }
                    if (!tmpFacilityIdList.contains(facilityId)) {
                        tmpFacilityIdList.add(facilityId);
                    }
                    tmpFacilityIdList.add(facilityId);
                    this.m_hostNameMap.put(hostName, tmpFacilityIdList);
                }
            }
            return true;
        }
        catch (FinderException e) {
            m_log.error((Object)("updateRepositoryInfo() : \u30ea\u30dd\u30b8\u30c8\u30ea\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.error((Object)("updateRepositoryInfo() : \u30ea\u30dd\u30b8\u30c8\u30ea\u60c5\u5831\u66f4\u65b0\u5931\u6557\u3002" + e.getMessage()));
        }
        return false;
    }

    public ArrayList<String> getFacilityIdListByHostName(String hostName) {
        if (this.m_hostNameMap != null) {
            return this.m_hostNameMap.get(hostName);
        }
        return null;
    }

    public ArrayList<String> getFacilityIdListByIpAddress(String address) {
        if (this.m_ipAddressMap != null) {
            return this.m_ipAddressMap.get(address);
        }
        return null;
    }

    public Map<String, SnmpTrapFacilityInfo> getSnmpTrapInfoMap() {
        return this.m_snmpTrapInfoMap;
    }

    public Map<String, SnmpTrapFacilityInfo> getSnmpTrapInfoMap(String monitorId) {
        if (this.m_snmpTrapInfoMap != null) {
            this.m_snmpTrapInfoMap.get(monitorId);
        }
        return null;
    }

    static {
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
        m_attributeList.add("ccNodeName");
    }
}

