/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util.code;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.util.Messages;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCategoryInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

public class CollectorItemCodeTable {
    private static final ArrayList<CollectorItemCategoryInfo> m_categoryList = new ArrayList();
    private static final ArrayList<CollectorItemTreeItem> m_itemTree = new ArrayList();
    private static final HashMap<String, CollectorItemTreeItem> m_codeTable = new HashMap();

    public static String getItemName(String itemCode) {
        return m_codeTable.get(itemCode).getItemName();
    }

    public static String getFullItemName(String itemCode, String deviceName) {
        String name = deviceName == null || deviceName.equals(Messages.getString((String)"none")) ? m_codeTable.get(itemCode).getItemName() : m_codeTable.get(itemCode).getItemName() + "(" + deviceName + ")";
        return name;
    }

    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
        String itemCode = collectorItemInfo.getCollectorItemCode();
        if (CollectorItemCodeTable.isDeviceSupport(itemCode)) {
            return CollectorItemCodeTable.getFullItemName(collectorItemInfo.getCollectorItemCode(), collectorItemInfo.getDeviceName());
        }
        return CollectorItemCodeTable.getItemName(itemCode);
    }

    public static String getMeasure(String itemCode) {
        return m_codeTable.get(itemCode).getMeasure();
    }

    public static boolean isRangeFixed(String itemCode) {
        return m_codeTable.get(itemCode).isRangeFixed();
    }

    public static boolean isDeviceSupport(String itemCode) {
        return m_codeTable.get(itemCode).isDeviceFlag();
    }

    public static String getDeviceType(String itemCode) {
        return m_codeTable.get(itemCode).getDeviceType();
    }

    public static int getCategorySize() {
        return m_categoryList.size();
    }

    public static String getCategoryName(int index) {
        return m_categoryList.get(index).getCategoryName();
    }

    public static String getCategoryName(String itemCode) {
        return m_codeTable.get(itemCode).getCategory().getCategoryName();
    }

    public static String getCategoryCode(int index) {
        return m_categoryList.get(index).getCategoryCode();
    }

    public static String getCategoryCode(String itemCode) {
        return m_codeTable.get(itemCode).getCategory().getCategoryCode();
    }

    public static String[] getCodeAll() {
        TreeSet<String> set = new TreeSet<String>(m_codeTable.keySet());
        return set.toArray(new String[set.size()]);
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        List<DeviceData> deviceList;
        block8: {
            block7: {
                deviceList = new ArrayList();
                if (collectorId != null) break block7;
                if (facilityId == null) break block8;
                Repository repository = new Repository();
                if (repository.isNode(facilityId)) {
                    deviceList = repository.getDeviceList(facilityId);
                } else {
                    ArrayList nodeList = new ArrayList();
                    String nodeFacilityId = null;
                    List compDeviceList = new ArrayList();
                    boolean firstFlg = true;
                    boolean existFlg = false;
                    Iterator itr_d = null;
                    Iterator itr_cd = null;
                    DeviceData device = null;
                    DeviceData compDevice = null;
                    nodeList = repository.getNodeList(facilityId);
                    Iterator itr_n = nodeList.iterator();
                    while (itr_n.hasNext()) {
                        nodeFacilityId = ((ArrayList)itr_n.next()).get(0).toString();
                        if (firstFlg) {
                            deviceList = repository.getDeviceList(nodeFacilityId);
                            firstFlg = false;
                            continue;
                        }
                        compDeviceList = repository.getDeviceList(nodeFacilityId);
                        itr_d = deviceList.iterator();
                        device = null;
                        itr_cd = null;
                        while (itr_d.hasNext()) {
                            device = (DeviceData)itr_d.next();
                            itr_cd = compDeviceList.iterator();
                            existFlg = false;
                            while (itr_cd.hasNext()) {
                                compDevice = (DeviceData)itr_cd.next();
                                if (device.getDeviceName().compareTo(compDevice.getDeviceName()) != 0) continue;
                                existFlg = true;
                                break;
                            }
                            if (existFlg) continue;
                            itr_d.remove();
                        }
                    }
                }
                break block8;
            }
            DeviceDAO dao = new DeviceDAO();
            Collection devicList = dao.selectDeviceByCollectorID(collectorId);
            for (DeviceData device : devicList) {
                if (!device.getFacilityId().equals(facilityId)) continue;
                deviceList.add(device);
            }
        }
        return CollectorItemCodeTable.getCollectorTree(facilityId, deviceList);
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, List deviceList) {
        CollectorItemTreeItem[] returnTrees = new CollectorItemTreeItem[m_categoryList.size()];
        for (int i = 0; i < returnTrees.length; ++i) {
            CollectorItemTreeItem masterTree = m_itemTree.get(i);
            returnTrees[i] = new CollectorItemTreeItem(null, masterTree.getData(), null);
            ArrayList children = masterTree.getChildrens();
            for (CollectorItemTreeItem masterTreeChild : children) {
                CollectorItemCodeInfo masterCodeInfo = (CollectorItemCodeInfo)masterTreeChild.getData();
                if (masterCodeInfo.isDeviceFlag()) {
                    if (deviceList == null) continue;
                    String deviceType = masterCodeInfo.getDeviceType();
                    for (DeviceData device : deviceList) {
                        if (!device.getDeviceType().equals(deviceType)) continue;
                        CollectorItemCodeTable.makeTree(returnTrees[i], masterTreeChild, device);
                    }
                    continue;
                }
                CollectorItemCodeTable.makeTree(returnTrees[i], masterTreeChild, null);
            }
        }
        return returnTrees;
    }

    public static List getAvailableCollectorItemList(String facilityId) {
        List deviceList = new ArrayList();
        ArrayList<CollectorItemInfo> retItemList = new ArrayList<CollectorItemInfo>();
        int collectorItemId = 0;
        if (facilityId != null) {
            Repository repository = new Repository();
            if (repository.isNode(facilityId)) {
                deviceList = repository.getDeviceList(facilityId);
            } else {
                ArrayList nodeList = new ArrayList();
                String nodeFacilityId = null;
                List compDeviceList = new ArrayList();
                boolean firstFlg = true;
                boolean existFlg = false;
                Iterator itr_d = null;
                Iterator itr_cd = null;
                DeviceData device = null;
                DeviceData compDevice = null;
                nodeList = repository.getNodeList(facilityId);
                Iterator itr_n = nodeList.iterator();
                while (itr_n.hasNext()) {
                    nodeFacilityId = ((ArrayList)itr_n.next()).get(0).toString();
                    if (firstFlg) {
                        deviceList = repository.getDeviceList(nodeFacilityId);
                        firstFlg = false;
                        continue;
                    }
                    compDeviceList = repository.getDeviceList(nodeFacilityId);
                    itr_d = deviceList.iterator();
                    device = null;
                    itr_cd = null;
                    while (itr_d.hasNext()) {
                        device = (DeviceData)itr_d.next();
                        itr_cd = compDeviceList.iterator();
                        existFlg = false;
                        while (itr_cd.hasNext()) {
                            compDevice = (DeviceData)itr_cd.next();
                            if (device.getDeviceName().compareTo(compDevice.getDeviceName()) != 0) continue;
                            existFlg = true;
                            break;
                        }
                        if (existFlg) continue;
                        itr_d.remove();
                    }
                }
            }
        }
        String[] codes = CollectorItemCodeTable.getCodeAll();
        for (int i = 0; i < codes.length; ++i) {
            String itemCode = codes[i];
            CollectorItemInfo itemInfo = null;
            int deviceIndex = 0;
            String deviceName = Messages.getString((String)"none");
            if (!CollectorItemCodeTable.isDeviceSupport(itemCode)) {
                itemInfo = new CollectorItemInfo(null, collectorItemId, itemCode, deviceIndex, deviceName, false);
                retItemList.add(collectorItemId, itemInfo);
                ++collectorItemId;
                continue;
            }
            if (deviceList == null) continue;
            for (DeviceData deviceData : deviceList) {
                String deviceType = CollectorItemCodeTable.getDeviceType(itemCode);
                if (!deviceData.getDeviceType().equals(deviceType)) continue;
                deviceIndex = deviceData.getDeviceIndex();
                deviceName = deviceData.getDeviceName();
                itemInfo = new CollectorItemInfo(null, collectorItemId, itemCode, deviceIndex, deviceName, false);
                retItemList.add(collectorItemId, itemInfo);
                ++collectorItemId;
            }
        }
        return retItemList;
    }

    private static void makeTree(CollectorItemTreeItem parent, CollectorItemTreeItem masterItem, DeviceData deviceData) {
        CollectorItemTreeItem treeItem = new CollectorItemTreeItem(parent, masterItem.getData(), deviceData);
        ArrayList children = masterItem.getChildrens();
        for (CollectorItemTreeItem masterTreeChild : children) {
            CollectorItemCodeTable.makeTree(treeItem, masterTreeChild, deviceData);
        }
    }

    public static HashMap getItemCodeMap() {
        return m_codeTable;
    }

    static {
        HashMap<String, CollectorItemTreeItem> categoryTable = new HashMap<String, CollectorItemTreeItem>();
        Properties properties = new Properties();
        try {
            int i;
            Locale locale = Locale.getDefault();
            String homeDir = System.getProperty("jboss.server.home.dir");
            String confDir = homeDir + File.separator + "conf" + File.separator;
            String propertyFile = locale.getLanguage().equals("ja") ? confDir + "performance_ja.properties" : confDir + "performance.properties";
            properties.load(new FileInputStream(propertyFile));
            int num = Integer.parseInt(properties.getProperty("collector.category.num"));
            for (i = 0; i < num; ++i) {
                String categoryCode = properties.getProperty("collector.category.code." + i);
                String categoryName = properties.getProperty("collector.category.name." + i);
                if (categoryCode == null || categoryName == null) continue;
                CollectorItemCategoryInfo category = new CollectorItemCategoryInfo(categoryCode, categoryName);
                m_categoryList.add(category);
                CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null);
                m_itemTree.add(categoryItem);
                categoryTable.put(categoryCode, categoryItem);
            }
            num = Integer.parseInt(properties.getProperty("collector.item.num"));
            for (i = 0; i < num; ++i) {
                String itemCode = properties.getProperty("collector.item.code." + i);
                if (itemCode == null) continue;
                String categoryCode = properties.getProperty("collector.item.category.code." + i);
                String parentCode = properties.getProperty("collector.item.parent.code." + i);
                String itemName = properties.getProperty("collector.item.name." + i);
                String measure = properties.getProperty("collector.item.measure." + i);
                String deviceFlagString = properties.getProperty("collector.device.support." + i);
                String deviceType = properties.getProperty("collector.device.type." + i);
                String rangeFixedString = properties.getProperty("collector.graph.range." + i);
                if (itemCode == null || categoryCode == null || deviceFlagString == null || rangeFixedString == null) continue;
                boolean deviceFlag = Boolean.parseBoolean(deviceFlagString);
                boolean rangeFixed = rangeFixedString.equals("fix");
                CollectorItemTreeItem categoryTreeItem = (CollectorItemTreeItem)categoryTable.get(categoryCode);
                String category = null;
                if (categoryTreeItem != null) {
                    category = categoryTreeItem.getCategory().getCategoryName();
                }
                CollectorItemCodeInfo codeInfo = new CollectorItemCodeInfo(itemCode, categoryCode, parentCode, category, itemName, measure, deviceFlag, deviceType, rangeFixed);
                CollectorItemTreeItem parentItem = m_codeTable.get(parentCode);
                if (parentItem == null) {
                    parentItem = categoryTreeItem;
                }
                CollectorItemTreeItem ctItem = new CollectorItemTreeItem(parentItem, codeInfo, null);
                m_codeTable.put(itemCode, ctItem);
            }
        }
        catch (Exception e) {
            m_codeTable.clear();
            m_itemTree.clear();
            m_codeTable.clear();
            e.printStackTrace();
        }
    }
}

