/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite.action;

import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CopyTreeItemAction
extends Action {
    protected TreeComposite composite;

    public CopyTreeItemAction(TreeComposite composite) {
        this.composite = composite;
        this.setText(Messages.getString((String)"copy"));
        this.setToolTipText(Messages.getString((String)"copy"));
    }

    public void run() {
        TreeItem selectItem = this.composite.getSelectItem();
        if (selectItem instanceof TreeItem) {
            boolean copy = false;
            if (selectItem.getInfo().getType() == 0 || selectItem.getInfo().getType() == 1 || selectItem.getInfo().getType() == 2 || selectItem.getInfo().getType() == 3 || selectItem.getInfo().getType() == 4) {
                copy = true;
            }
            if (copy) {
                TreeItem copyItem = TreeItemUtil.copy((TreeItem)selectItem);
                TreeItem parent = selectItem.getParent();
                int maxOrderNo = TreeItemUtil.getMaxOrderNo((TreeItem)parent);
                ItemInfo copyInfo = copyItem.getInfo();
                copyInfo.setOrderNo(maxOrderNo + 1);
                selectItem.getParent().addChildren(copyItem);
                this.composite.setCreateItem(copyItem);
                this.composite.getTreeViewer().refresh((Object)selectItem.getParent());
                this.composite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)copyItem), true);
            }
        }
    }
}

