/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkCombo;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int arrowHandle;
    int entryHandle;
    int listHandle;
    int lastEventTime;
    int visibleCount = 5;
    int gdkEventKey = 0;
    String[] items = new String[0];
    boolean ignoreSelect;
    boolean lockText;
    static final int INNER_BORDER = 2;
    public static final int LIMIT = 65535;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        this.lockText = true;
        this.ignoreSelect = true;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int item = OS.gtk_list_item_new_with_label(buffer);
        int label = OS.gtk_bin_get_child(item);
        OS.gtk_widget_modify_fg(label, 0, this.getForegroundColor());
        OS.gtk_widget_modify_font(label, this.getFontDescription());
        OS.gtk_widget_set_direction(label, OS.gtk_widget_get_direction(this.handle));
        OS.gtk_widget_show(item);
        int items = OS.g_list_append(0, item);
        OS.gtk_list_insert_items(this.listHandle, items, index);
        this.lockText = false;
        this.ignoreSelect = false;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        int position = OS.gtk_editable_get_position(this.entryHandle);
        OS.gtk_editable_select_region(this.entryHandle, position, position);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        int layout = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_size(layout, w, h);
        int xborder = 2;
        int yborder = 2;
        int style = OS.gtk_widget_get_style(this.entryHandle);
        xborder += OS.gtk_style_get_xthickness(style);
        yborder += OS.gtk_style_get_ythickness(style);
        int[] property = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, property, 0);
        if (property[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, property, 0);
            xborder += property[0];
            yborder += property[0];
        }
        int width = OS.PANGO_PIXELS(w[0]) + xborder * 2;
        int height = OS.PANGO_PIXELS(h[0]) + yborder * 2;
        GtkRequisition arrowRequesition = new GtkRequisition();
        OS.gtk_widget_size_request(this.arrowHandle, arrowRequesition);
        GtkRequisition listRequesition = new GtkRequisition();
        int listParent = OS.gtk_widget_get_parent(this.listHandle);
        OS.gtk_widget_size_request(listParent != 0 ? listParent : this.listHandle, listRequesition);
        width = Math.max(listRequesition.width, width) + arrowRequesition.width + 4;
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard(this.entryHandle);
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_combo_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        GtkCombo combo = new GtkCombo();
        OS.memmove(combo, this.handle);
        this.entryHandle = combo.entry;
        this.listHandle = combo.list;
        int list = OS.gtk_container_get_children(this.handle);
        if (list != 0) {
            int i = 0;
            int count = OS.g_list_length(list);
            while (i < count) {
                int childHandle = OS.g_list_nth_data(list, i);
                if (childHandle != this.entryHandle && childHandle != this.listHandle) {
                    this.arrowHandle = childHandle;
                    break;
                }
                ++i;
            }
            OS.g_list_free(list);
        }
        boolean editable = (this.style & 8) == 0;
        OS.gtk_editable_set_editable(this.entryHandle, editable);
        OS.gtk_combo_disable_activate(this.handle);
        OS.gtk_combo_set_case_sensitive(this.handle, true);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard(this.entryHandle);
    }

    void deregister() {
        super.deregister();
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
        this.display.removeWidget(this.entryHandle);
        this.display.removeWidget(this.listHandle);
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean filterKey(int keyval, int event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        int imContext;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (imContext = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    int fontHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    int focusHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        if (OS.GTK_WIDGET_HAS_FOCUS(this.entryHandle)) {
            return true;
        }
        return OS.GTK_WIDGET_HAS_FOCUS(this.listHandle);
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        int windowProc4 = this.display.windowProc4;
        int windowProc5 = this.display.windowProc5;
        OS.g_signal_connect_after(this.entryHandle, OS.changed, windowProc2, 4);
        OS.g_signal_connect(this.entryHandle, OS.insert_text, windowProc5, 21);
        OS.g_signal_connect(this.entryHandle, OS.delete_text, windowProc4, 10);
        OS.g_signal_connect(this.entryHandle, OS.activate, windowProc2, 1);
        int eventMask = 13060;
        int[] handles = new int[]{this.arrowHandle, this.entryHandle, this.listHandle};
        int i = 0;
        while (i < handles.length) {
            int eventHandle = handles[i];
            if (eventHandle != 0) {
                OS.gtk_widget_add_events(eventHandle, eventMask);
                OS.g_signal_connect(eventHandle, OS.button_press_event, windowProc3, 2);
                OS.g_signal_connect(eventHandle, OS.button_release_event, windowProc3, 3);
                OS.g_signal_connect(eventHandle, OS.motion_notify_event, windowProc3, 28);
                OS.g_signal_connect(eventHandle, OS.enter_notify_event, windowProc3, 11);
                OS.g_signal_connect(eventHandle, OS.leave_notify_event, windowProc3, 24);
                OS.g_signal_connect_after(eventHandle, OS.button_press_event, windowProc3, -2);
                OS.g_signal_connect_after(eventHandle, OS.button_release_event, windowProc3, -3);
                OS.g_signal_connect_after(eventHandle, OS.motion_notify_event, windowProc3, -28);
                if (eventHandle != this.entryHandle) {
                    OS.g_signal_connect(eventHandle, OS.event_after, windowProc3, 13);
                }
            }
            ++i;
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect(imContext, OS.commit, windowProc3, 6);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched(imContext, blockMask, id, 0, 0, 0, this.entryHandle);
        }
    }

    int imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle);
    }

    public void deselect(int index) {
        boolean selected;
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        this.ignoreSelect = true;
        int children = OS.gtk_container_get_children(this.listHandle);
        int item = OS.g_list_nth_data(children, index);
        boolean bl = selected = OS.GTK_WIDGET_STATE(item) == 3;
        if (selected) {
            OS.gtk_list_unselect_all(this.listHandle);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        OS.g_list_free(children);
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        OS.gtk_list_unselect_all(this.listHandle);
        OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        this.ignoreSelect = false;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.listHandle != 0 ? this.listHandle : this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        OS.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        int children;
        this.checkWidget();
        int index = 0;
        int result = -1;
        int temp = children = OS.gtk_container_get_children(this.listHandle);
        while (temp != 0) {
            int item = OS.g_list_data(temp);
            if (OS.GTK_WIDGET_STATE(item) == 3) {
                result = index;
                break;
            }
            ++index;
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(children);
        return result;
    }

    public String getText() {
        this.checkWidget();
        int address = OS.gtk_entry_get_text(this.entryHandle);
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.entryHandle != 0 ? this.entryHandle : this.handle) + 8;
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = OS.gtk_entry_get_max_length(this.entryHandle);
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int widget) {
        if (!this.ignoreSelect) {
            int ptr = OS.gtk_entry_get_text(this.entryHandle);
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            String text = new String(Converter.mbcsToWcs(null, buffer));
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].equals(text)) {
                    this.postEvent(13);
                    break;
                }
                ++i;
            }
        }
        this.sendEvent(24);
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0, 0, 6);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0, 0, this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.entryHandle);
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String newText = this.verifyText("", start_pos, end_pos);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
            OS.gtk_editable_insert_text(this.entryHandle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
            OS.gtk_editable_set_position(this.entryHandle, pos[0]);
        }
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        boolean newSelection;
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove(buffer, new_text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4);
        if (pos[0] == -1) {
            int ptr = OS.gtk_entry_get_text(this.entryHandle);
            pos[0] = OS.g_utf8_strlen(ptr, -1);
        }
        int[] oldStart = new int[1];
        int[] oldEnd = new int[1];
        OS.gtk_editable_get_selection_bounds(this.entryHandle, oldStart, oldEnd);
        String newText = this.verifyText(oldText, pos[0], pos[0]);
        int[] newStart = new int[1];
        int[] newEnd = new int[1];
        OS.gtk_editable_get_selection_bounds(this.entryHandle, newStart, newEnd);
        boolean bl = newSelection = oldStart[0] != newStart[0] || oldEnd[0] != newEnd[0];
        if (newSelection) {
            if (newText == null) {
                newText = "";
            }
            pos[0] = newEnd[0];
        }
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        } else if (newText != oldText || newSelection) {
            byte[] buffer2 = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
            if (newSelection) {
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
                OS.gtk_editable_delete_selection(this.entryHandle);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
            }
            OS.gtk_editable_insert_text(this.entryHandle, buffer2, buffer2.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
            OS.memmove(position, pos, 4);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            result = 1;
        }
        this.gdkEventKey = 0;
        return result;
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer(0, x, y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.items.length) {
            return -1;
        }
        int i = start;
        while (i < this.items.length) {
            if (string.equals(this.items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard(this.entryHandle);
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        super.register();
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
        this.display.addWidget(this.entryHandle, this);
        this.display.addWidget(this.listHandle, this);
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.listHandle = 0;
        this.entryHandle = 0;
    }

    void releaseWidget() {
        this.fixIM();
        super.releaseWidget();
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.items = newItems;
        this.ignoreSelect = true;
        int children = OS.gtk_container_get_children(this.listHandle);
        int item = OS.g_list_nth_data(children, index);
        boolean selected = OS.GTK_WIDGET_STATE(item) == 3;
        int items = OS.g_list_append(0, item);
        OS.gtk_list_remove_items(this.listHandle, items);
        OS.g_list_free(items);
        OS.g_list_free(children);
        if (selected) {
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        this.ignoreSelect = false;
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.items = newItems;
        boolean selected = false;
        this.ignoreSelect = true;
        int items = 0;
        int children = OS.gtk_container_get_children(this.listHandle);
        int i = start;
        while (i <= end) {
            int item = OS.g_list_nth_data(children, i);
            selected |= OS.GTK_WIDGET_STATE(item) == 3;
            items = OS.g_list_append(items, item);
            ++i;
        }
        OS.gtk_list_remove_items(this.listHandle, items);
        OS.g_list_free(items);
        OS.g_list_free(children);
        if (selected) {
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        this.ignoreSelect = false;
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        OS.gtk_list_clear_items(this.listHandle, 0, -1);
        OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        this.items = new String[0];
        this.ignoreSelect = false;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        this.ignoreSelect = true;
        OS.gtk_list_select_item(this.listHandle, index);
        this.ignoreSelect = false;
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_base(this.entryHandle, 0, color);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_base(this.listHandle, 0, color);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = resize ? this.getTextHeight() : height;
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_font(this.entryHandle, font);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_font(this.listHandle, font);
            int itemsList = OS.gtk_container_get_children(this.listHandle);
            if (itemsList != 0) {
                int count = OS.g_list_length(itemsList);
                int i = count - 1;
                while (i >= 0) {
                    int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                    OS.gtk_widget_modify_font(widget, font);
                    --i;
                }
                OS.g_list_free(itemsList);
            }
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_text(this.entryHandle, 0, color);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_text(this.listHandle, 0, color);
            int itemsList = OS.gtk_container_get_children(this.listHandle);
            if (itemsList != 0) {
                int count = OS.g_list_length(itemsList);
                int i = count - 1;
                while (i >= 0) {
                    int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                    OS.gtk_widget_modify_fg(widget, 0, color);
                    --i;
                }
                OS.g_list_free(itemsList);
            }
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        this.ignoreSelect = true;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int children = OS.gtk_container_get_children(this.listHandle);
        int item = OS.g_list_nth_data(children, index);
        int label = OS.gtk_bin_get_child(item);
        OS.gtk_label_set_text(label, buffer);
        OS.g_list_free(children);
        this.ignoreSelect = false;
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        this.ignoreSelect = true;
        this.lockText = true;
        OS.gtk_list_clear_items(this.listHandle, 0, -1);
        int font = this.getFontDescription();
        GdkColor color = this.getForegroundColor();
        int direction = OS.gtk_widget_get_direction(this.handle);
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            int item = OS.gtk_list_item_new_with_label(buffer);
            int label = OS.gtk_bin_get_child(item);
            OS.gtk_widget_modify_fg(label, 0, color);
            OS.gtk_widget_modify_font(label, font);
            OS.gtk_widget_set_direction(label, direction);
            OS.gtk_container_add(this.listHandle, item);
            OS.gtk_widget_show(item);
            ++i2;
        }
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, i2);
        this.ignoreSelect = false;
        this.lockText = false;
        OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(this.listHandle, 2);
            OS.gtk_widget_set_direction(this.entryHandle, 2);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= ~flags;
        this.style |= orientation & flags;
        int dir = (orientation & 0x4000000) != 0 ? 2 : 1;
        OS.gtk_widget_set_direction(this.fixedHandle, dir);
        OS.gtk_widget_set_direction(this.handle, dir);
        OS.gtk_widget_set_direction(this.listHandle, dir);
        OS.gtk_widget_set_direction(this.entryHandle, dir);
        int itemsList = OS.gtk_container_get_children(this.listHandle);
        if (itemsList != 0) {
            int count = OS.g_list_length(itemsList);
            int i = count - 1;
            while (i >= 0) {
                int widget = OS.gtk_bin_get_child(OS.g_list_nth_data(itemsList, i));
                OS.gtk_widget_set_direction(widget, dir);
                --i;
            }
            OS.g_list_free(itemsList);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        OS.gtk_editable_set_position(this.entryHandle, selection.x);
        OS.gtk_editable_select_region(this.entryHandle, selection.x, selection.y);
    }

    public void setText(String string) {
        int ptr;
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0 && (index = this.indexOf(string)) == -1) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, OS.g_utf8_strlen(ptr = OS.gtk_entry_get_text(this.entryHandle), -1))) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 10);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
        OS.gtk_entry_set_text(this.entryHandle, buffer);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 4);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 10);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 21);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length(this.entryHandle, limit);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

