/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.commons.util;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommonSendTopic {
    protected static Log m_log = LogFactory.getLog(CommonSendTopic.class);
    protected String m_topicName;
    protected TopicConnectionFactory m_connectionFactory;
    protected TopicConnection m_connection;
    protected Topic m_topic;
    protected TopicSession m_session;

    public CommonSendTopic(String topicName) throws NamingException, JMSException {
        this.m_topicName = topicName;
        this.connect();
    }

    protected void connect() throws NamingException, JMSException {
        InitialContext context = null;
        try {
            String serverName = System.getProperty("jboss.server.name");
            if (serverName.equals("all")) {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                properties.put("java.naming.provider.url", "jnp://localhost:1100");
                context = new InitialContext(properties);
            } else {
                context = new InitialContext();
            }
            this.m_connectionFactory = (TopicConnectionFactory)context.lookup("java:/ConnectionFactory");
            this.m_connection = this.m_connectionFactory.createTopicConnection();
            this.m_session = this.m_connection.createTopicSession(false, 1);
            this.m_connection.start();
            this.m_topic = (Topic)context.lookup(this.m_topicName);
        }
        catch (NamingException e) {
            this.terminate();
            throw e;
        }
        catch (JMSException e) {
            this.terminate();
            throw e;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException e) {
                m_log.error((Object)("connect(): can not closed  TopicName:" + this.m_topicName + e.getMessage()), (Throwable)e);
            }
        }
        m_log.debug((Object)("connect() : end  TopicName:" + this.m_topicName));
    }

    public void terminate() {
        m_log.debug((Object)("terminate() : start  TopicName:" + this.m_topicName));
        try {
            if (this.m_connection != null) {
                this.m_connection.stop();
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate():  TopicName:" + this.m_topicName + e.getMessage()), (Throwable)e);
        }
        try {
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate():  TopicName:" + this.m_topicName + e.getMessage()), (Throwable)e);
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate():  TopicName:" + this.m_topicName + e.getMessage()), (Throwable)e);
        }
        m_log.debug((Object)("terminate(): end  TopicName:" + this.m_topicName));
    }
}

