/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue {
    private static final String QUEUE_CON_FACTORY = "ConnectionFactory";
    private static final String QUEUE_USER_NAME = "queue.user.name";
    private static final String QUEUE_USER_PASSWORD = "queue.user.password";
    private Properties m_props;
    private QueueConnection m_con;
    private Queue m_queue;
    private QueueSession m_session;
    private QueueConnectionFactory m_factory;
    private boolean m_isErr = false;
    private static Log log = LogFactory.getLog(SendQueue.class);

    public SendQueue(Properties props) {
        this.m_props = props;
        this.initial();
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.m_isErr = false;
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(RunResultInfo info) {
        if (this.m_isErr) {
            this.reInitial();
        }
        QueueSender sender = null;
        while (true) {
            try {
                sender = this.m_session.createSender(this.m_queue);
                ObjectMessage mess = this.m_session.createObjectMessage((Serializable)info);
                log.info((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1 : SessionID=" + info.getSessionId() + ", JobID=" + info.getJobId() + ", CommandType=" + info.getCommandType()));
                sender.send((Message)mess);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error((Object)e);
                log.info((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30ea\u30c8\u30e9\u30a4");
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                this.reInitial();
                continue;
            }
            finally {
                try {
                    if (sender == null) continue;
                    sender.close();
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (QueueConnectionFactory)con.lookup(QUEUE_CON_FACTORY);
            this.m_con = this.m_props.getProperty(QUEUE_USER_NAME) != null ? this.m_factory.createQueueConnection(this.m_props.getProperty(QUEUE_USER_NAME), this.m_props.getProperty(QUEUE_USER_PASSWORD)) : this.m_factory.createQueueConnection();
            this.m_session = this.m_con.createQueueSession(false, 1);
            this.m_con.start();
            this.m_queue = (Queue)con.lookup("queue/clustercontrol/JobManagement/status");
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.m_isErr = true;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }
}

