/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.bean;

import com.clustercontrol.util.Messages;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class NodeOperationEndStatusConstant {

	////////////////////////////////////
	// 終了状態(cc_vm_operation_detail.status)
	////////////////////////////////////

	//成功
	public static Short SUCCESS = Short.valueOf("10");
	
	//失敗
	public static Short FAIL = Short.valueOf("11");
	

	/**
	 * endStatusを名前に変える。
     * 仮想化[操作ログ]で利用される。
	 * @param endStatus
	 * @return
	 */
	public static String getName(Short endStatus) {
		if (endStatus == null) {
			return "";
		}
		if (endStatus.compareTo(SUCCESS) == 0) {
			return Messages.getString("message.vm.operation.3");
		} else if (endStatus.compareTo(FAIL) == 0) {
			return Messages.getString("message.vm.operation.4");
		} else { 
			return endStatus.toString();
		}
	}

}
