/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.bean.SharedTableConstant;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstUtil;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstUtil;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * ポーリングに関する情報をDBから取得するクラス<BR>
 *
 * @version 3.1.0
 * @since 3.1.0
 */
public class PollingDataManager {
	
	protected static Log m_log = LogFactory.getLog( PollingDataManager.class );
    
	private String m_platformId = "";
	private String m_subPlatformId = "";
	
	/** 
	 * コンストラクタ
	 * 
	 * @param ファシリティID
	 */ 
	public PollingDataManager(String facilityId){
		
		RepositoryControllerLocal repositoryLocal;
		try {
			repositoryLocal = RepositoryControllerUtil.getLocalHome().create();
			
			// プラットフォームIDとサブプラットフォームIDを問い合わせる
			ArrayList<String> attributeList = new ArrayList<String>();
			attributeList.add(FacilityAttributeConstant.PLATFORM);
			attributeList.add(FacilityAttributeConstant.VIRTSOLUTION);
			HashMap<String, String> facilityAttrMap = repositoryLocal.getNodeDetail(facilityId, attributeList);
			
			m_platformId = facilityAttrMap.get(FacilityAttributeConstant.PLATFORM);
			m_subPlatformId = facilityAttrMap.get(FacilityAttributeConstant.VIRTSOLUTION);
			
			// サブプラットフォームIDのnullチェック
			if(m_subPlatformId == null)
				m_subPlatformId = "";
			
		} catch (CreateException e) {
			m_log.error(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		} catch (FinderException e) {
			m_log.error(e.getMessage(), e);
		}
	}
	
	
	/**
	 * 収集方法（SNMP,WBEMなど）の取得
	 * 
	 * @return 収集方法
	 */
	
	public String getCollectMethod(){
		
		String collectMethod = "";
		
		try {
			
			m_log.debug("getColledtMethod() m_platformId : " + m_platformId + ", m_subPlatformId : " + m_subPlatformId);
			// 収集方法を取得する
			MonitorProcessMethodMstPK processPk = new MonitorProcessMethodMstPK(
					m_platformId,
					m_subPlatformId);
			MonitorProcessMethodMstLocal processLocal = 
				MonitorProcessMethodMstUtil.getLocalHome().findByPrimaryKey(processPk);
			
			collectMethod = processLocal.getCollectMethod();
			
		} catch (FinderException e) {
			m_log.error(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		}
		
		return collectMethod;
	}
	
	/**
	 * ポーリング対象の取得
	 * 
	 * @return ポーリング対象のリスト
	 */
	public List<String> getPollingTargets(String collectMethod){
		
		List<String> pollingTargets = new ArrayList<String>();
		
		try {
			Collection<MonitorProcessPollingMstLocal> pollingBeans = 
				MonitorProcessPollingMstUtil.getLocalHome().findByCollectMethodAndPlatformIdAndSubPlatformId(
						collectMethod, 
						m_platformId, 
						m_subPlatformId);
			
			Iterator<MonitorProcessPollingMstLocal> itr = pollingBeans.iterator();
			while(itr.hasNext()){
				m_log.debug("getPollingTargets() collectMethod : " + collectMethod + 
						", m_platformId : " + m_platformId + 
						", m_subPlatformId : " + m_subPlatformId);
				pollingTargets.add(itr.next().getPollingTarget());
			}
			
		} catch (FinderException e) {
			m_log.error(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error(e.getMessage(), e);
		}
		
		
		return pollingTargets;
	}


	/**
	 * インスタンス生成時に与えたファシリティIDのプラットフォームIDを取得する
	 * @return プラットフォームID
	 */
	public String getPlatformId() {
		return m_platformId;
	}

	/**
	 * インスタンス生成時に与えたファシリティIDのサブプラットフォームIDを取得する
	 * @return サブプラットフォームID
	 */
	public String getSubPlatformId() {
		return m_subPlatformId;
	}
}
