/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集毎の収集項目の情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorPollingMst"
 *           jndi-name="CollectorPollingMst"
 *           type="CMP"
 *           schema="CollectorPollingMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="collectMethod","platformId","subPlatformId","itemCode","variableId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_polling_mst"
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPollingMst as a"
 *    signature="java.util.Collection findAll()"
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPollingMst as a where a.platformId = ?1 AND a.itemCode = ?2"
 *    signature="java.util.Collection findByPlatformIdAndItemCode(java.lang.String platformId, java.lang.String itemCode)"
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPollingMst as a where a.collectMethod = ?1 AND a.platformId = ?2 AND a.itemCode = ?3"
 *    signature="java.util.Collection findByCollectMethodAndPlatformIdAndItemCode(java.lang.String collectMethod, java.lang.String platformId, java.lang.String itemCode)"
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorPollingMst as a where a.collectMethod = ?1 AND a.platformId = ?2 AND a.subPlatformId = ?3 AND a.itemCode = ?4"
 *    signature="java.util.Collection findByCollectMethodAndPlatformIdAndSubPlatformIdAndItemCode(java.lang.String collectMethod, java.lang.String platformId, java.lang.String subPlatformId, java.lang.String itemCode)"
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstPK"
 */
public abstract class CollectorPollingMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorPollingMstPK ejbCreate(
			String collectMethod,
			String platformId,
			String subPlatformId,
			String itemCode,
			String variableId,
			String entryKey,
			String valueType,
			String pollingTarge,
			String failureValue
			) throws javax.ejb.CreateException {
		
		this.setCollectMethod(collectMethod);
		this.setPlatformId(platformId);
		this.setSubPlatformId(subPlatformId);
		this.setItemCode(itemCode);
		this.setVariableId(variableId);
		this.setEntryKey(entryKey);
		this.setValueType(valueType);
		this.setPollingTarget(pollingTarge);
		this.setFailureValue(failureValue);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param collectMethod 収集方法
	 * @param platformId プラットフォーム
	 * @param subPlatformId サブプラットフォーム
	 * @param itemCode 収集項目コード
	 * @param variableId 変数名
	 * @param entryKey エントリーキー
	 * @param valueType 値の型
	 * @param pollingTarget ポーリング対象値
	 * @param failureValue 取得失敗時の値
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String collectMethod,
			String platformId,
			String subPlatformId,
			String itemCode,
			String variableId,
			String entryKey,
			String valueType,
			String pollingTarge,
			String failureValue
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 収集方法を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="collect_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the collectMethod.
	 */
	public abstract String getCollectMethod();

	/**
	 * 収集方法を設定します。
	 * 
	 * @param collectMethod The collectMethod to set.
	 */
	public abstract void setCollectMethod(String collectMethod);
	
	
	/**
	 * プラットフォームを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォームを設定します。
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * サブプラットフォームを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="sub_platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the subPlatformId.
	 */
	public abstract String getSubPlatformId();

	/**
	 * サブプラットフォームを設定します。
	 * 
	 * @param subPlatformId The subPlatformId to set.
	 */
	public abstract void setSubPlatformId(String subPlatformId);

	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the itemCode.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @param itemCode The itemCode to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * 変数名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="variable_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the variableId.
	 */
	public abstract String getVariableId();

	/**
	 * 変数名を設定します。
	 * 
	 * @param variableId The variableId to set.
	 */
	public abstract void setVariableId(String variableId);

	/**
	 * エントリーキーを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="entry_key"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the entryKey.
	 */
	public abstract String getEntryKey();

	/**
	 * エントリーキーを設定します。
	 * 
	 * @param entryKey The entryKey to set.
	 */
	public abstract void setEntryKey(String entryKey);

	/**
	 * 値の型を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="value_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the valueType.
	 */
	public abstract String getValueType();

	/**
	 * 値の型を設定します。
	 * 
	 * @param valueType The valueType to set.
	 */
	public abstract void setValueType(String valueType);

	/**
	 * ポーリング対象を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="polling_target"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the pollingTarget.
	 */
	public abstract String getPollingTarget();

	/**
	 * ポーリング対象を設定します。
	 * 
	 * @param pollingTarge The pollingTarge to set.
	 */
	public abstract void setPollingTarget(String pollingTarge);

	/**
	 * 取得失敗時の値を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="failure_value"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the failureValue.
	 */
	public abstract String getFailureValue();

	/**
	 * 取得失敗時の値を設定します。
	 * 
	 * @param failureValue The failureValue to set.
	 */
	public abstract void setFailureValue(String failureValue);

}
