/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.bean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapData;


/**
 * 各ファシリティから再帰的に性能値の算出をするのに必要なメソッドを定義したアブストラクトクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public abstract class Facility extends CollectorScopeSnapData implements Serializable, Comparable {
	/** 種別が「コンポジット」であることを表現する定数 */
	public static final String COMPOSITE = "comp";
    
	/** 種別が「スコープ」であることを表現する定数 */
	public static final String SCOPE = "scope";
	
	/** 種別が「ノード」であることを表現する定数 */
	public static final String NODE = "node";
	
//	protected String m_facilityID;
//	private String m_facilityName;
//	private int m_type;
	private HashSet<Facility> m_parents = null;
//	private HashMap m_calcValues;
	private HashMap<CollectorItemInfo, Double> m_calcTempValues;
	
	public Facility(String facilityID, String facilityName, String type) {
		setFacilityId(facilityID);
		setFacilityName(facilityName);
		setFacilityType(type);
		m_parents = new HashSet<Facility>();
//		m_calcValues = new HashMap();
		m_calcTempValues = new HashMap<CollectorItemInfo, Double>();
	}
	
	/**
	 * DB からの入力用コンストラクター
	 * 
	 * @param facilityID
	 * @param faclityName
	 * @param type
	 */
//	public Facility(String facilityId, String facilityName, String type) {
//		setFacilityId(facilityId);
//		setFacilityName(facilityName);
//		setFacilityType(type);
//		m_parents = new HashSet();
//	}
	
	/**
	 * 親要素を追加します。
	 * @param parent 親要素
	 */
	public void addParents(Facility parent){
		
		this.getParents().add(parent);
	}
	
	/**
	 *  このファシリティの以下のスコープに含まれるノードの数を返します。
	 * @return ノードの数
	 */
	protected int getNodeCount(){
		return 0;
	}

	/**
	 * 計算済み性能値を返します。
	 * @return 計算済み性能値
	 */
	abstract public double calcValue(final CollectorItemInfo itemInfo);

	
	/**
	 * ファシリティIDを取得します。
	 * @return FacilityID を戻します。
	 */
//	public String getFacilityID() {
//		return this.facilityId;
//	}
	
	/**
	 * ファシリティ名称を取得します。
	 * @return FacilityName ファシリティ名称
	 */
//	public String getFacilityName() {
//		return this.facilityName;
//	}
	
	/**
	 * 親のファシリティを取得します。
	 * @return Parents 親のファシリティ
	 */
	public HashSet<Facility> getParents() {
		return m_parents;
	}
	
	/**
	 * typeを取得します。
	 * @return Type 
	 */
//	public int getType() {
//		return this.facilityType;
//	}
	
	/**
	 * typeを取得します。
	 * @return Type "scope" or "node"
	 */
//	public String getTypeString() {
//		String returnValue = null;
//		if(this.facilityType == Facility.SCOPE){
//			returnValue = "scope";
//		} else if(this.facilityType == Facility.NODE){
//			returnValue = "node";	
//		}
//		return returnValue;
//	}

	/**
	 * ファシリティIDを設定します。
	 * @param facilityid ファシリティID
	 */
//	public void setFacilityID(String facilityid) {
//		this.facilityId = facilityid;
//	}
	
	/**
	 * typeを設定します。
	 * @param type "scope" or "node"
	 */
//	public void setTypeString(String type) {
//		if(type.equals("scope")){
//			this.facilityType = Facility.SCOPE;
//		} else if(type.equals("node")){
//			this.facilityType = Facility.NODE;		
//		}
//	}
	
	/**
	 * このファシリティと指定されたファシリティの順序を比較します。
	 * @param o 比較対象のファシリティ
	 * @return このオブジェクトが指定されたオブジェクトより小さい場合は負の整数、
	 *         等しい場合はゼロ、大きい場合は正の整数
	 */
	public int compareTo(Object o){
		return getFacilityId().compareTo(((Facility)o).getFacilityId());
	}
	
	/**
	 * バッファに保持されている前回収集時の性能値を取得する。
	 * 
	 * @param item 収集項目PK
	 * @return 前回収集時の性能値
	 */
	public double getCalcValueBuffer(CollectorItemInfo item){
		Double value = (Double)m_calcTempValues.get(item);
		
		if(value == null){
			return Double.NaN;
		} else {
			return value.doubleValue();
		}
	}
	
	/**
	 * 性能値をバッファとして保持する。
	 * 
	 * @param item 収集項目PK
	 * @return 前回収集時の性能値
	 */
	public void setCalcValueBuffer(CollectorItemInfo item, double data){
		m_calcTempValues.put(item, new Double(data));
	}
}
