/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.factory;

import java.lang.reflect.InvocationTargetException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.repository.ejb.entity.FacilityData;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.vm.NodeOperationActionInterface;
import com.clustercontrol.vm.VmException;
import com.clustercontrol.vm.bean.NodeOperationCommandConstant;
import com.clustercontrol.vm.bean.NodeOperationEndStatusConstant;
import com.clustercontrol.vm.bean.VmMethodTypeConstant;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailData;
import com.clustercontrol.vm.ejb.entity.VmMethodMstLocal;
import com.clustercontrol.vm.ejb.entity.VmMethodMstPK;
import com.clustercontrol.vm.ejb.entity.VmMethodMstUtil;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 * 
 */
public class NodeOperationController {

	protected static Log m_log = LogFactory.getLog( NodeOperationController.class );

    /**
     * 
     * @param data
     * @param status
     * @param endValue
     * @param message
     * @throws CreateException
     * @throws NamingException
     * @throws FinderException
     * @throws Exception
     */
	public void action(VmOperationDetailData data) 
		throws CreateException,NamingException,FinderException{

		if (data == null) {
			m_log.error("action(): VmOperationDetailData is null");
			return;
		}
		m_log.debug("action() : start sessionId = " + data.getSessionId() + ", facilityId = " + data.getFacilityId());
		
		//実行に必要な引数の設定
        FacilityData target = null;
        FacilityData host = null;
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        
        
        //処理の順番
        //1.対象ノードの情報取得(target)
        //2.対象ノードの管理ノード(Hostノード)情報取得(host)
        // -->対象がHost/Guestの何れの場合もあるが、Hostの場合も管理ノードが存在する場合がある。
        // -->管理ノードがいない場合はnullとなる。必要の有無のチェックは各仮想化ソフトの実装範囲内で判断。
        //3.ターゲットの仮想化ソリューション情報より実行クラス名をDBより取得
        //4.対象の仮想化ソフトのインスタンスを生成
        //5.コマンド種別で分岐して処理を実行
        // -->実行条件を満たしているか(必要な情報がそろっているか)を判定する。
        // --> 満たしていない場合はstatus=FAILで起動失敗で終了する
        // -->対象の仮想化ソフト用のクラスをnewする。
        // -->対象の仮想化ソフト用のクラスに対してcommandIdに該当するメソッドを実行する。
        
        
        //1.対象ノードの情報取得(target)
        target = repository.getNodeFacilityData(data.getFacilityId());
        if(target == null){
    		data.setMessage(data.getFacilityId() + " is not found");
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
			m_log.warn("action() : message = " + data.getMessage());
    		return;
        }
        
        if(!"guest".equals(target.getVirtNodeType())) {
        	m_log.error("action () : this node is not guest");
        	data.setMessage(Messages.getString("message.vm.operation.20"));
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
			return;
        }
        
        //2.対象ノードの管理ノード(Hostノード)情報取得(host)
        m_log.debug("action() : getVMManagementNode = " + target.getVMManagementNode());
        if(target.getVMManagementNode() != null && !target.getVMManagementNode().equals("")){
        	host = repository.getNodeFacilityData(target.getVMManagementNode());
    		m_log.debug("action() : host facilityId = " + host.getFacilityId());
        }
        else {
    		m_log.warn("action() : hostNode of " + data.getFacilityId() + " is not found");
		}

        
        //3.ターゲットの仮想化ソリューション情報より実行クラス名をDBより取得
        String className = null;
        m_log.debug("action() : getVirtSolution = " + target.getVirtSolution());
        if(target.getVirtSolution() != null && !target.getVirtSolution().equals("")){
        	VmMethodMstLocal local =VmMethodMstUtil.getLocalHome().findByPrimaryKey(new VmMethodMstPK(target.getVirtSolution(),VmMethodTypeConstant.NODEOPERATION)); 
        	
        	if(local != null){
            	className = local.getClassName();
            	m_log.debug("action() : className = " + className);
        	}else{
        		data.setMessage("Class of " + target.getVirtSolution() + "is not found at DB");
    			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
    			m_log.warn("action() : message = " + data.getMessage());
        		return ;
        	}
        	
        }else{
        	//仮想化ソリューション名称が登録されていない、または管理ノードの情報と異なる
        	data.setMessage("VirtSolution is not registed, or VirtSolution of guest differs from host");
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
    		m_log.warn("action() : message = " + data.getMessage());
        	return;
        }
        
        //4.対象の想化ソフトのインスタンスを生成
        NodeOperationActionInterface action = null;
        try{
            action = (NodeOperationActionInterface)Class.forName(className).getConstructor().newInstance();
            if(action != null) {
        		m_log.debug("action() : action class = " + action.getClass().getCanonicalName());
                action.init(target, host);
            } else {
            	m_log.warn("action() : action class is null");
            }
        } catch (VmException e) {
        	data.setMessage(e.getMessage());
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
        	return;
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			m_log.error("action() : message = " + e.getMessage());
			data.setMessage(className + " could not loaded");
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
    		return;
		}
        
        //5.コマンド種別で分岐して処理を実行
        try{
        	//ゲストノード用操作
            if(data.getCommandId().equals(NodeOperationCommandConstant.G_POWERON)){
            	//電源ONの場合
            	Short endStatus = action.guestPowerOn();
            	data.setEndStatus(endStatus);
            } else if (data.getCommandId().equals(NodeOperationCommandConstant.G_POWEROFF)) {
            	//電源OFFの場合
            	Short endStatus = action.guestPowerOff();
            	data.setEndStatus(endStatus);
    		} else {
    			m_log.error("command not found : " + data.getCommandId());
    		}
            //ホストOS用操作
            //将来作成予定
        } catch (VmException e) {
			data.setMessage(e.getMessage());
			data.setEndStatus(NodeOperationEndStatusConstant.FAIL);
        	m_log.error("VmException : " + e.getMessage());
        	return;
        }
        
		m_log.debug("action() : end sessionId = " + data.getSessionId() +
				", status = " + data.getStatus() +
				", endStatus = " + data.getEndStatus() +
				", facilityId = " + data.getFacilityId() +
				", message = " + data.getMessage());
	}
}