/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.vm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailBean;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailPK;

/**
 * 
 * @version 3.1.0
 * @since 3.1.0
 *
 */
public class VmOperationDetailDAOImpl implements VmOperationDetailDAO {

	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog(VmOperationDetailDAOImpl.class);

	
	/**
	 * INSERT文を発行します。
	 * 引数で指定されたEntity Beanの内容をデータベースに挿入し、プライマリキーを返します。
	 * 
	 */
	public VmOperationDetailPK create(VmOperationDetailBean ejb)
			throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSessionId() + ", " + ejb.getFacilityId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		VmOperationDetailPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_vm_operation_detail (");
			sql.append("session_id, ");//1
			sql.append("facility_id, ");//2
			sql.append("scope_text, ");//3
			sql.append("node_type, ");//4
			sql.append("command_id, ");//5
			sql.append("status, ");//6
			sql.append("start_date, ");//7
			sql.append("end_status, ");//8
			sql.append("end_date, ");//9
			sql.append("end_value, ");//10
			sql.append("message) ");//11
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSessionId());
			
			stmt.setString(2, ejb.getFacilityId());
			
			stmt.setString(3, ejb.getScopeText());
			
			stmt.setString(4, ejb.getNodeType());
			
			stmt.setString(5, ejb.getCommandId());
			
			if(ejb.getStatus() instanceof Short)
				stmt.setShort(6, ejb.getStatus());
			else
				stmt.setNull(6, Types.SMALLINT);

			
			if(ejb.getStartDate() instanceof java.util.Date)
				stmt.setTimestamp(7, new Timestamp(ejb.getStartDate().getTime()));
			else
				stmt.setTimestamp(7, null);
			
			if(ejb.getEndStatus() instanceof Short)
				stmt.setShort(8, ejb.getEndStatus());
			else
				stmt.setNull(8, Types.SMALLINT);

			if(ejb.getEndDate() instanceof java.util.Date)
				stmt.setTimestamp(9, new Timestamp(ejb.getEndDate().getTime()));
			else
				stmt.setTimestamp(9, null);

			
			if(ejb.getEndValue() instanceof Integer)
				stmt.setInt(10, ejb.getEndValue());
			else
				stmt.setNull(10, Types.INTEGER);
			
			stmt.setString(11, ejb.getMessage());
			
			int row =	stmt.executeUpdate();
			pk = new VmOperationDetailPK(
					ejb.getSessionId(),
					ejb.getFacilityId());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSessionId() + ", " + ejb.getFacilityId());
		return pk;

	}

	/**
	 * 全件取得するSELECT文を発行します。
	 * 取得したデータのプライマリキーをコレクションに格納し返します。
	 * 
	 */
	public ArrayList<VmOperationDetailPK> findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT session_id, facility_id FROM cc_vm_operation_detail";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				VmOperationDetailPK pk= new VmOperationDetailPK(
						res.getString("session_id"),
						res.getString("facility_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		
		return ret;
	}

	/**
	 * 
	 */
	public VmOperationDetailPK findByPrimaryKey(VmOperationDetailPK pk)
			throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "SELECT session_id, facility_id FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSessionId());
			stmt.setString(2, pk.getFacilityId());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}

	/**
	 * 
	 */
	public ArrayList<VmOperationDetailPK> findBySessionId(String sessionId) throws FinderException {
		m_log.debug("findBySessionId() start : " + sessionId);
		
		ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT session_id,facility_id FROM cc_vm_operation_detail WHERE session_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			stmt.setString(1, sessionId);
			res = stmt.executeQuery();
			
			while(res.next()) {
				VmOperationDetailPK pk= new VmOperationDetailPK(
						res.getString("session_id"),
						res.getString("facility_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findBySessionId() end : " + sessionId);
		
		return ret;
	}

	/**
	 * 
	 */
	public ArrayList<VmOperationDetailPK> findHistory(int history) throws FinderException {
		m_log.debug("findHistory() start : " + history);
		
		ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT session_id,facility_id FROM cc_vm_operation_detail ORDER By start_date DESC LIMIT ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			stmt.setInt(1, history);
			res = stmt.executeQuery();
			
			while(res.next()) {
				VmOperationDetailPK pk= new VmOperationDetailPK(
						res.getString("session_id"),
						res.getString("facility_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findHistory() end : " + history);
		
		return ret;
	}

	/**
	 * 
	 */
	public void init() {

	}

	/** 
	 * SELECT文を発行します。
	 * 引数で指定されたプライマリキーで検索し、取得したデータベースの内容をEntity Beanに反映します。
	 * 
	 */
	public void load(VmOperationDetailPK pk, VmOperationDetailBean ejb)
			throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "SELECT * FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ? ORDER BY start_date DESC, session_id, facility_id";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSessionId());
			stmt.setString(2, pk.getFacilityId());
			
			res = stmt.executeQuery();

			if (res.next()) {
				
				ejb.setSessionId(res.getString("session_id"));
				ejb.setFacilityId(res.getString("facility_id"));
				ejb.setScopeText(res.getString("scope_text"));
				ejb.setNodeType(res.getString("node_type"));
				ejb.setCommandId(res.getString("command_id"));
				ejb.setStatus(res.getShort("status"));
				if(res.getTimestamp("start_date") != null) {
					ejb.setStartDate(new Date(res.getTimestamp("start_date").getTime()));
				} else {
					ejb.setStartDate(null);
				}
				ejb.setEndStatus(res.getShort("end_status"));
				if(res.getTimestamp("end_date") != null) {
					ejb.setEndDate(new Date(res.getTimestamp("end_date").getTime()));
				} else {
					ejb.setEndDate(null);
				}
				ejb.setEndValue(res.getInt("end_value"));
				ejb.setMessage(res.getString("message"));
				
			} else {
				String msg = "VmOperationDetail data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//コネクション、結果セット、プリペアドステートメントのクローズ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());

	}

	/**
	 * DELETE文を発行します。
	 * 引数で指定されたプライマリキーでデータベースから削除します。
	 * 
	 */
	public void remove(VmOperationDetailPK pk) throws RemoveException,
			EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "DELETE FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSessionId());
			stmt.setString(2, pk.getFacilityId());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());

	}

	/**
	 * UPDATE文を発行します。
	 * 引数で指定されたEntity Beanの内容でデータベースを更新します。
	 * 
	 */
	public void store(VmOperationDetailBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSessionId() + ", " + ejb.getFacilityId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_vm_operation_detail SET ");
			sql.append("scope_text = ?, ");//1
			sql.append("node_type = ?, ");//2
			sql.append("command_id = ?, ");//3
			sql.append("status = ?, ");//4
			sql.append("start_date = ?, ");//5
			sql.append("end_status = ?, ");//6
			sql.append("end_date = ?, ");//7
			sql.append("end_value = ?, ");//8
			sql.append("message = ? ");//9
			sql.append("WHERE session_id = ? ");//10
			sql.append("AND facility_id = ?");//11
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getScopeText());
			
			stmt.setString(2, ejb.getNodeType());
			
			stmt.setString(3, ejb.getCommandId());
			
			if(ejb.getStatus() instanceof Short) {
				stmt.setShort(4, ejb.getStatus());
			} else {
				stmt.setNull(4, Types.SMALLINT);
			}
			if(ejb.getStartDate() instanceof java.util.Date)
				stmt.setTimestamp(5, new Timestamp(ejb.getStartDate().getTime()));
			else
				stmt.setTimestamp(5, null);
			
			if(ejb.getEndStatus() instanceof Short) {
				stmt.setShort(6, ejb.getEndStatus());
			} else {
				stmt.setNull(6, Types.SMALLINT);
			}
			if(ejb.getEndDate() instanceof java.util.Date) {
				stmt.setTimestamp(7, new Timestamp(ejb.getEndDate().getTime()));
			} else {
				stmt.setTimestamp(7, null);
			}
			if(ejb.getEndValue() instanceof Integer) {
				stmt.setInt(8, ejb.getEndValue());
			} else {
				stmt.setNull(8, Types.INTEGER);
			}
			stmt.setString(9, ejb.getMessage());
			
			stmt.setString(10, ejb.getSessionId());

			stmt.setString(11, ejb.getFacilityId());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSessionId() + ", " +  ejb.getFacilityId() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSessionId() + ", " +  ejb.getFacilityId() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクローズ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSessionId() + ", " +  ejb.getFacilityId() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSessionId() + ", " + ejb.getFacilityId());

	}

}
