/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.performance.composite.RecordSetItemComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;


/**
 * リアルタイムの表示設定を行うダイアログ 設定の項目はfacilityID 収集項目 更新間隔など。
 * このダイアログよりリアルタイム表示が開始される
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeSetDialog extends Dialog {	//CommonDialogをextendするよう仕様変更する.
	private Composite composite = null;
	
	private Composite composite2 = null;
	
	private RecordSetItemComposite itemComposite = null;
	
//	private Label label1 = null;
	
	private Group group4 = null;
	
	private Combo combo = null;
	
	private int comboSetting;
	
	private RealtimeCollectorInfo collectorInfo = null;
	
	private RealtimeCollectorItemInfo collectorItemInfo = null;
	
	
	private boolean isInterval = false;
	
	
	/**
	 * コンストラクター
	 * 
	 * @param parent
	 */
	public RealtimeSetDialog(Shell parent) {
		super(parent);
		
		// 画面中央に配置する(ダイアログ呼び出し側で逐一記述する手間をかけさせない).
		Display display = parent.getDisplay();
		parent.setLocation((display.getBounds().width - parent.getSize().x) / 2,
				(display.getBounds().height - parent.getSize().y) / 2);
		
		initialize();
	}
	
	private void initialize() {
	}
	
	public void update() {	
		
		collectorItemInfo.refreshItemInfoForDialog();
		
		switch (collectorInfo.getInterval()) {
		case 5:
			this.comboSetting = 0;
			break;
		case 10:
			this.comboSetting = 1;
			break;
		case 30:
			this.comboSetting = 2;
			break;
		case 60:
			this.comboSetting = 3;
			break;
		}
	}
	
	protected Point getInitialSize() {
		return new Point(450, 740);
	}
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("SET_REALTIME_GRAPH_DIALOG_TITLE"));
	}
	
	protected Control createDialogArea(Composite parent) {
		composite = (Composite) super.createDialogArea(parent);
		composite.setLayout(new FormLayout());
		createComposite2();
		return composite;
	}
	
	
	private void createComposite2() {
		composite2 = new Composite(composite, SWT.NONE);
		FormData composite2Data = new FormData();
		composite2Data.top = new FormAttachment(0, 0); // ダイアログ内のコンポジットの上に張りつく
		composite2Data.bottom = new FormAttachment(100, 0); // ダイアログ内のコンポジットの下に張りつく
		composite2Data.right = new FormAttachment(100, 0); // ダイアログ内のコンポジットの右に張りつく
		composite2Data.left = new FormAttachment(0, 0); // ダイアログ内のコンポジットの右に張りつく
		
		composite2.setLayoutData(composite2Data);
		
		// 暫定で固定4を入れておく。あとで動的にする。
		for (int i = 0; i < 4 ; i++) {
			
			/**
			 * グラフ表示させる情報の条件を指定する領域の生成
			 *  
			 */
			itemComposite = new RecordSetItemComposite(composite2, SWT.NONE);
			GridLayout gridLayout00 = new GridLayout();
			gridLayout00.numColumns = 3; //３列
			itemComposite.setLayout(gridLayout00);
			GridData gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
			itemComposite.setLayoutData(gridDataGroup);
			
			itemComposite.setCollectorItemInfo(collectorItemInfo);
			itemComposite.update(i);
		}
		
		createIntervalGroup();
		composite2.setLayout(new GridLayout());
	}
	
	/**
	 * グラフの更新間隔(秒)を指定する領域の生成
	 *  
	 */
	private void createIntervalGroup() {
		// 共通処理
		group4 = new Group(composite2, SWT.NONE);
		GridData gridDataGroup4 = new GridData(GridData.FILL_HORIZONTAL);
		group4.setLayoutData(gridDataGroup4);
		group4.setText(Messages.getString("GRAPH_REFRESH_INTERVAL_IN_JP"));
		
		GridLayout gridLayoutRefresh = new GridLayout();
		group4.setLayout(gridLayoutRefresh);
		
		// プルダウン
		combo = new Combo(group4, SWT.READ_ONLY);
		GridData gridDataRefresh;
		gridDataRefresh = new GridData(GridData.FILL_VERTICAL);
		combo.setLayoutData(gridDataRefresh);
		if (this.isInterval) {
			combo.add(Messages.getString("5SEC"));
			combo.add(Messages.getString("10SEC"));
			combo.add(Messages.getString("30SEC"));
			combo.add(Messages.getString("1MIN"));
			combo.select(comboSetting); //選択項目
		}
		combo.setEnabled(this.isInterval);
	}
	
	/**
	 * OKボタン押下時の処理
	 */
	protected void okPressed() {
		
		collectorItemInfo.copyItemInfoForDialog();
		
		if (this.isInterval) {
			if (combo.getSelectionIndex() == 0) {
				collectorInfo.setInterval(5);
				collectorInfo.setRequestInterval(5);
			} else if (combo.getSelectionIndex() == 1) {
				collectorInfo.setInterval(10);
				collectorInfo.setRequestInterval(10);
			} else if (combo.getSelectionIndex() == 2) {
				collectorInfo.setInterval(30);
				collectorInfo.setRequestInterval(30);
			} else if (combo.getSelectionIndex() == 3) {
				collectorInfo.setInterval(60);
				collectorInfo.setRequestInterval(60);
			}
		}
		super.okPressed();
	}
	
	public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
		this.collectorInfo = collectorInfo;
	}
	
	public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
		this.collectorItemInfo = collectorItemInfo;
	}
	
	public void setInterval(boolean isInterval) {
		this.isInterval = isInterval;
	}
	
}