/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.bean;

/**
 * 通知情報一覧のテーブル定義を定数として格納するクラス<BR>
 * 
 * 通知情報一覧ダイアログのテーブルの表示項目と表示順を定義します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NotifyTableDefine {
	
	/** チェックボックス。 */
	public static final int SELECTION = 0;
	
    /**
     * 有効／無効。
     * 
     * @see com.clustercontrol.bean.ValidConstant
     */
    public static final int VALID_FLG = 1;
	
    /** 通知ID。 */
    public static final int NOTIFY_ID = 2;

    /** 説明。 */
    public static final int DESCRIPTION = 3;
    
    /** 通知タイプ。 
     *
     * @see com.clustercontrol.bean.NotifyTypeConstant
     */
    public static final int NOTIFY_TYPE = 4;

    /** 更新日時。 */
    public static final int UPDATE_TIME = 5;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = NOTIFY_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

}
