/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.swt.SWT;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.bean.MaintenanceTableDefine;
import com.clustercontrol.maintenance.bean.ScheduleTableDefine;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoData;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;

import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.util.Messages;

/**
 * 
 * メンテナンス情報検索クラスです。
 * 
 * @since	3.0.0
 * @version	2.2.0
 *
 */
public class SelectMaintenanceInfo {
	
	
	public MaintenanceInfoDataImp getMaintenanceInfo(String maintenanceId) throws FinderException, NamingException, CreateException {
		
		// メンテナンス情報を取得
		MaintenanceInfoLocal infoLocal = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
		
		MaintenanceInfoDataImp info = new MaintenanceInfoDataImp();
		info.setMaintenance_id(infoLocal.getMaintenance_id());
		info.setDescription(infoLocal.getDescription());
		info.setType_id(infoLocal.getType_id());
		info.setKeep_id(infoLocal.getKeep_id());
		info.setCalendar_id(infoLocal.getCalendar_id());
		info.setSchedule_date(infoLocal.getSchedule_date());
		info.setNotifyGroupId(infoLocal.getNotifyGroupId());
		info.setApplication(infoLocal.getApplication());
		info.setValid_flg(infoLocal.getValid_flg());
		info.setRegUser(infoLocal.getRegUser());
		info.setRegDate(infoLocal.getRegDate());
		info.setUpdateUser(infoLocal.getUpdateUser());
		info.setUpdateDate(infoLocal.getUpdateDate());

		//通知情報の取得
		NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
		info.setNotifyId(nc.getNotifyRelation(info.getNotifyGroupId()));
	
		
		
		return info;
	}
	
	
	/**
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws SchedulerException 
	 */
	public ArrayList getMaintenanceList() throws FinderException, NamingException, CreateException, SchedulerException {
		
		// メンテナンス情報一覧を取得
		Collection ct = MaintenanceInfoUtil.getLocalHome().findAllOrderByMaintenanceId();
		
		// 2次元配列に変換
		ArrayList list = this.collectionToArray(ct);
		
		return list;
	}
	
	
	/**
	 * 
	 * @param locale
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getMaintenanceListTableDefine(Locale locale) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(MaintenanceTableDefine.MAINTENANCE_ID,
				new TableColumnInfo(Messages.getString("maintenance.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.DESCRIPTION,
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.TYPE_ID,
				new TableColumnInfo(Messages.getString("maintenance.type", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.KEEP_ID,
				new TableColumnInfo(Messages.getString("maintenance.keep", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.CALENDAR_ID,
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.SCHEDULE,
				new TableColumnInfo(Messages.getString("schedule", locale), TableColumnInfo.SCHEDULE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.VALID_FLG,
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 50, SWT.LEFT));
				
		tableDefine.add(MaintenanceTableDefine.CREATE_USER,
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));

		tableDefine.add(MaintenanceTableDefine.CREATE_TIME,
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 80, SWT.LEFT));

		tableDefine.add(MaintenanceTableDefine.UPDATE_USER,
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.UPDATE_TIME,
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		return tableDefine;
	}
	
	
	
	/**
	 * メンテナンス情報をObjectの2次元配列に格納
	 * 
	 * @param ct
	 * @return Objectの2次元配列
	 * @throws SchedulerException 
	 */
	@SuppressWarnings("unchecked")
	private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException, SchedulerException{
		
		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			MaintenanceInfoLocal maintenance = (MaintenanceInfoLocal)itr.next();
			
			ArrayList info = new ArrayList();
			info.add(maintenance.getMaintenance_id());
			info.add(maintenance.getDescription());
			info.add(maintenance.getType_id());
			info.add(maintenance.getKeep_id());
			info.add(maintenance.getCalendar_id());
			
			
//			info.add(new Date(maintenance.getSchedule_date().getTime()));
			SelectSchedule selectSchedule = new SelectSchedule();
			Schedule schedule = (Schedule)selectSchedule.getSchedule(maintenance.getMaintenance_id()).get(ScheduleTableDefine.SCHEDULE);
			info.add(schedule.getDate().getTime());
			
			info.add(maintenance.getValid_flg().intValue());
			info.add(maintenance.getRegUser());
			info.add(new Date(maintenance.getRegDate().getTime()));
			info.add(maintenance.getUpdateUser());
			info.add(new Date(maintenance.getUpdateDate().getTime()));
			list.add(info);
		}
		return list;
	}
	
}
