/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * ジョブの待ち条件に関する情報を保持するクラス<BR>
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class JobWaitRuleInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = -6362706494732152461L;

	/** 保留 */
	protected int suspend = YesNoConstant.TYPE_NO;
	
	/** スキップ */
	protected int skip = YesNoConstant.TYPE_NO;
	
	/** スキップ時終了状態 */
	protected int skipEndStatus;
	
	/** スキップ時終了値 */
	protected int skipEndValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** 判定対象の条件関係 */
	protected int condition = ConditionTypeConstant.TYPE_AND;
	
	/** ジョブ判定対象情報 */
	protected ArrayList<JobObjectInfo> object;
	
	/** 条件を満たさなければ終了する */
	protected int endCondition = YesNoConstant.TYPE_NO;
	
	/** 条件を満たさない時の終了状態 */
	protected int endStatus;
	
	/** 条件を満たさない時の終了値 */
	protected int endValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** カレンダ */
	protected int calendar = YesNoConstant.TYPE_NO;
	
	/** カレンダID */
	protected String calendarId;
	
	/** カレンダにより未実行時の終了値 */
	protected int calendarEndValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** 開始遅延 */
	protected int start_delay = YesNoConstant.TYPE_NO;
	
	/** 開始遅延セッション開始後の時間 */
	protected int start_delay_session = YesNoConstant.TYPE_NO;
	
	/** 開始遅延セッション開始後の時間の値 */
	protected int start_delay_session_value = 1;
	
	/** 開始遅延時刻 */
	protected int start_delay_time = YesNoConstant.TYPE_NO;
	
	/** 開始遅延時刻の値 */
	protected Date start_delay_time_value;
	
	/** 開始遅延判定対象の条件関係 */
	protected int start_delay_condition_type = ConditionTypeConstant.TYPE_AND;
	
	/** 開始遅延通知 */
	protected int start_delay_notify = YesNoConstant.TYPE_NO;
	
	/** 開始遅延通知重要度 */
	protected int start_delay_notify_priority;
	
	/** 開始遅延操作 */
	protected int start_delay_operation = YesNoConstant.TYPE_NO;
	
	/** 開始遅延操作種別 */
	protected int start_delay_operation_type;
	
	/** 開始遅延操作終了値 */
	protected int start_delay_operation_end_value = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** 終了遅延 */
	protected int end_delay = YesNoConstant.TYPE_NO;
	
	/** 終了遅延セッション開始後の時間 */
	protected int end_delay_session = YesNoConstant.TYPE_NO;
	
	/** 終了遅延セッション開始後の時間の値 */
	protected int end_delay_session_value = 1;
	
	/** 終了遅延ジョブ開始後の時間 */
	protected int end_delay_job = YesNoConstant.TYPE_NO;
	
	/** 終了遅延ジョブ開始後の時間の値 */
	protected int end_delay_job_value = 1;
	
	/** 終了遅延時刻 */
	protected int end_delay_time = YesNoConstant.TYPE_NO;
	
	/** 終了遅延時刻の値 */
	protected Date end_delay_time_value;
	
	/** 終了遅延判定対象の条件関係 */
	protected int end_delay_condition_type = ConditionTypeConstant.TYPE_AND;
	
	/** 終了遅延通知 */
	protected int end_delay_notify = YesNoConstant.TYPE_NO;
	
	/** 終了遅延通知重要度 */
	protected int end_delay_notify_priority;
	
	/** 終了遅延操作 */
	protected int end_delay_operation = YesNoConstant.TYPE_NO;
	
	/** 終了遅延操作種別 */
	protected int end_delay_operation_type;
	
	/** 終了遅延操作終了値 */
	protected int end_delay_operation_end_value = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/**
	 * ジョブのスキップをするかしないかを返す。<BR>
	 * @return スキップをするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getSkip() {
		return skip;
	}
	
	/**
	 * ジョブのスキップをするかしないかを設定する。<BR>
	 * @param skip スキップするかしないか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setSkip(int skip) {
		this.skip = skip;
	}
	
	/**
	 * スキップ時の終了状態を返す。<BR>
	 * @return スキップ時終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public int getSkipEndStatus() {
		return skipEndStatus;
	}
	
	/**
	 * スキップ時の終了状態を設定する。<BR>
	 * @param endStatus スキップ時終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setSkipEndStatus(int endStatus) {
		this.skipEndStatus = endStatus;
	}
	
	/**
	 * スキップ時の終了値を返す。<BR>
	 * @return スキップ時終了値
	 */
	public int getSkipEndValue() {
		return skipEndValue;
	}
	
	/**
	 * スキップ時の終了値を設定する。<BR>
	 * @param endValue スキップ時終了値
	 */
	public void setSkipEndValue(int endValue) {
		this.skipEndValue = endValue;
	}
	
	/**
	 * 判定対象の条件関係を返す。<BR>
	 * @return 判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public int getCondition() {
		return condition;
	}
	
	/**
	 * 判定対象の条件関係を返す。<BR>
	 * @param condition 判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setCondition(int condition) {
		this.condition = condition;
	}
	
	/**
	 * 待ち条件を満たさない時の終了状態を返す。<BR>
	 * @return 待ち条件を満たさない時の終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public int getEndStatus() {
		return endStatus;
	}
	
	/**
	 * 待ち条件を満たさない時の終了状態を設定する。<BR>
	 * @param endStatus 待ち条件を満たさない時の終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setEndStatus(int endStatus) {
		this.endStatus = endStatus;
	}
	
	/**
	 * 待ち条件を満たさない時の終了値を返す。<BR>
	 * @return 待ち条件を満たさない時の終了値
	 */
	public int getEndValue() {
		return endValue;
	}
	
	/**
	 * 待ち条件を満たさない時の終了値を設定する。<BR>
	 * @param endValue 待ち条件を満たさない時の終了値
	 */
	public void setEndValue(int endValue) {
		this.endValue = endValue;
	}
	
	/**
	 * ジョブ判定対象情報を返す。<BR>
	 * @return ジョブ判定対象情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobObjectInfo
	 */
	public ArrayList<JobObjectInfo> getObject() {
		return object;
	}
	
	/**
	 * ジョブ判定対象情報を設定する。<BR>
	 * @param object ジョブ判定対象情報のリスト
	 * @see com.clustercontrol.jobmanagement.bean.JobObjectInfo
	 */
	public void setObject(ArrayList<JobObjectInfo> object) {
		this.object = object;
	}
	
	/**
	 * 待ち条件を満たさなければ終了するかどうかを返す。<BR>
	 * 
	 * @return 待ち条件を満たさなければ終了するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEndCondition() {
		return endCondition;
	}
	
	/**
	 * まち条件を満たさなければ終了するかどうかを設定する。<BR>
	 * @param endCondition 待ち条件を満たさなければ終了するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEndCondition(int endCondition) {
		this.endCondition = endCondition;
	}
	
	/**
	 * 保留するかどうかを返す。<BR>
	 * @return 保留するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getSuspend() {
		return suspend;
	}
	
	/**
	 * 保留するかどうかを設定する。<BR>
	 * @param suspend 保留するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setSuspend(int suspend) {
		this.suspend = suspend;
	}
	
	/**
	 * カレンダを返す。<BR>
	 * @return カレンダ
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getCalendar() {
		return calendar;
	}
	
	/**
	 * カレンダを設定する。<BR>
	 * @param calendar カレンダ
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setCalendar(int calendar) {
		this.calendar = calendar;
	}
	
	/**
	 * カレンダIDを返す。<BR>
	 * @return カレンダID
	 */
	public String getCalendarId() {
		return calendarId;
	}
	
	/**
	 * カレンダIDを設定する。<BR>
	 * @param calendarId カレンダID
	 */
	public void setCalendarId(String calendarId) {
		this.calendarId = calendarId;
	}
	
	/**
	 * カレンダにより未実行となった場合の終了値を返す。<BR>
	 * @return カレンダにより未実行となった場合の終了値
	 */
	public int getCalendarEndValue() {
		return calendarEndValue;
	}
	
	/**
	 * カレンダにより未実行となった場合の終了値を設定する。<BR>
	 * @param calendarEndValue カレンダにより未実行となった場合の終了値
	 */
	public void setCalendarEndValue(int calendarEndValue) {
		this.calendarEndValue = calendarEndValue;
	}
	
	/**
	 * 終了遅延を監視するかどうかを返す。<BR>
	 * @return 終了遅延を監視するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay() {
		return end_delay;
	}

	/**
	 * 終了遅延を監視するかどうかを設定する。<BR>
	 * @param end_delay 終了遅延を監視するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay(int end_delay) {
		this.end_delay = end_delay;
	}

	/**
	 * 終了遅延判定対象の条件関係を返す。<BR>
	 * @return 終了遅延判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public int getEnd_delay_condition_type() {
		return end_delay_condition_type;
	}

	/**
	 * 終了遅延判定対象の条件関係を設定する。<BR>
	 * @param end_delay_condition_type 終了遅延判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setEnd_delay_condition_type(int end_delay_condition_type) {
		this.end_delay_condition_type = end_delay_condition_type;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * ジョブ開始後の時間で判定するかどうかを返す。<BR>
	 * @return ジョブ開始後の時間で終了遅延監視を行うかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay_job() {
		return end_delay_job;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * ジョブ開始後の時間で判定するかどうかを設定する。<BR>
	 * @param end_delay_job ジョブ開始後の時間で終了遅延監視を行うかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_job(int end_delay_job) {
		this.end_delay_job = end_delay_job;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * ジョブ開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するのかの値を返す。<BR>
	 * @return 終了遅延ジョブ開始後の時間の値
	 */
	public int getEnd_delay_job_value() {
		return end_delay_job_value;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * ジョブ開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するかの値を設定する。<BR>
	 * @param end_delay_job_value 終了遅延ジョブ開始後の時間の値
	 */
	public void setEnd_delay_job_value(int end_delay_job_value) {
		this.end_delay_job_value = end_delay_job_value;
	}

	/**
	 * 終了遅延を通知するかどうかを返す。<BR>
	 * @return 終了遅延を通知するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay_notify() {
		return end_delay_notify;
	}

	/**
	 * 終了遅延を通知するかどうかを設定する。<BR>
	 * @param end_delay_notify 終了遅延を通知するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_notify(int end_delay_notify) {
		this.end_delay_notify = end_delay_notify;
	}

	/**
	 * 終了遅延を通知する場合の重要度を返す。<BR>
	 * @return 終了遅延を通知する場合の重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getEnd_delay_notify_priority() {
		return end_delay_notify_priority;
	}

	/**
	 * 終了遅延を通知する場合の重要度を設定する。<BR>
	 * @param end_delay_notify_priority 終了遅延を通知する場合の重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setEnd_delay_notify_priority(int end_delay_notify_priority) {
		this.end_delay_notify_priority = end_delay_notify_priority;
	}

	/**
	 * 終了遅延時に操作するかどうかを返す。<BR>
	 * @return 終了遅延時に操作するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay_operation() {
		return end_delay_operation;
	}

	/**
	 * 終了遅延時に操作するかどうかを設定する。<BR>
	 * @param end_delay_operation 終了遅延時に操作するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_operation(int end_delay_operation) {
		this.end_delay_operation = end_delay_operation;
	}

	/**
	 * 終了遅延時に操作する場合の終了値を返す。<BR>
	 * @return 終了遅延時に操作する場合の終了値
	 */
	public int getEnd_delay_operation_end_value() {
		return end_delay_operation_end_value;
	}

	/**
	 * 終了遅延時に操作する場合の終了値を設定する。<BR>
	 * @param end_delay_operation_end_value 終了遅延時に操作する場合の終了値
	 */
	public void setEnd_delay_operation_end_value(int end_delay_operation_end_value) {
		this.end_delay_operation_end_value = end_delay_operation_end_value;
	}

	/**
	 * 終了遅延時に操作する場合の操作種別を返す。<BR>
	 * @return 終了遅延時の操作種別
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public int getEnd_delay_operation_type() {
		return end_delay_operation_type;
	}

	/**
	 * 終了遅延時に操作する場合の操作種別を設定する。<BR>
	 * @param end_delay_operation_type 終了遅延時の操作種別
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public void setEnd_delay_operation_type(int end_delay_operation_type) {
		this.end_delay_operation_type = end_delay_operation_type;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定するかどうかを返す。<BR>
	 * @return セッション開始後の時間で終了遅延監視を行うかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay_session() {
		return end_delay_session;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定するかどうかを設定する。<BR>
	 * @param end_delay_session セッション開始後の時間で終了遅延監視を行うかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_session(int end_delay_session) {
		this.end_delay_session = end_delay_session;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するかの値を返す。<BR>
	 * @return 終了遅延セッション開始後の時間の値
	 */
	public int getEnd_delay_session_value() {
		return end_delay_session_value;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するかの値を設定する。<BR>
	 * @param end_delay_session_value 終了遅延セッション開始後の時間の値
	 */
	public void setEnd_delay_session_value(int end_delay_session_value) {
		this.end_delay_session_value = end_delay_session_value;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * 時刻で判定するかどうかを返す。<BR>
	 * @return 終了遅延時刻
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getEnd_delay_time() {
		return end_delay_time;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * 時刻で判定するかどうかを設定する。<BR>
	 * @param end_delay_time 終了遅延時刻
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setEnd_delay_time(int end_delay_time) {
		this.end_delay_time = end_delay_time;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * 時刻で判定する場合の時刻を返す。<BR>
	 * @return 終了遅延時刻の値
	 */
	public Date getEnd_delay_time_value() {
		return end_delay_time_value;
	}

	/**
	 * 終了遅延の判定条件のうち、<BR>
	 * 時刻の判定する場合の値を設定する。<BR>
	 * @param end_delay_time_value 終了遅延時刻の値
	 */
	public void setEnd_delay_time_value(Date end_delay_time_value) {
		this.end_delay_time_value = end_delay_time_value;
	}

	/**
	 * 開始遅延を監視するかどうかを返す。<BR>
	 * @return 開始遅延を監視するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getStart_delay() {
		return start_delay;
	}

	/**
	 * 開始遅延を監視するかどうかを設定する。<BR>
	 * @param start_delay 開始遅延を監視するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay(int start_delay) {
		this.start_delay = start_delay;
	}

	/**
	 * 開始遅延判定対象の条件関係を返す。<BR>
	 * @return 開始遅延判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public int getStart_delay_condition_type() {
		return start_delay_condition_type;
	}

	/**
	 * 開始遅延判定対象の条件関係を設定する。<BR>
	 * @param start_delay_condition_type 開始遅延判定対象の条件関係
	 * @see com.clustercontrol.jobmanagement.bean.ConditionTypeConstant
	 */
	public void setStart_delay_condition_type(int start_delay_condition_type) {
		this.start_delay_condition_type = start_delay_condition_type;
	}

	/**
	 * 開始遅延を通知するかどうかを返す。<BR>
	 * @return 開始遅延を通知するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getStart_delay_notify() {
		return start_delay_notify;
	}

	/**
	 * 開始遅延を通知するかどうかを設定する。<BR>
	 * @param start_delay_notify 開始遅延通知
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_notify(int start_delay_notify) {
		this.start_delay_notify = start_delay_notify;
	}

	/**
	 * 開始遅延を通知する場合の重要度を返す。<BR>
	 * @return 開始遅延を通知する場合の重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getStart_delay_notify_priority() {
		return start_delay_notify_priority;
	}

	/**
	 * 開始遅延を通知する場合の重要度を設定する。<BR>
	 * @param start_delay_notify_priority 開始遅延を通知する場合の重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setStart_delay_notify_priority(int start_delay_notify_priority) {
		this.start_delay_notify_priority = start_delay_notify_priority;
	}

	/**
	 * 開始遅延時に操作するかどうかを返す。<BR>
	 * @return 開始遅延時に操作するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getStart_delay_operation() {
		return start_delay_operation;
	}

	/**
	 * 開始遅延時に操作するかどうかを設定する。<BR>
	 * @param start_delay_operation 開始遅延時に操作するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_operation(int start_delay_operation) {
		this.start_delay_operation = start_delay_operation;
	}

	/**
	 * 開始遅延時に操作する場合の終了値を返す。<BR>
	 * @return 開始遅延時に操作する場合の終了値
	 */
	public int getStart_delay_operation_end_value() {
		return start_delay_operation_end_value;
	}

	/**
	 * 開始遅延時に操作する場合の終了値を設定する。<BR>
	 * @param start_delay_operation_end_value 開始遅延時に操作する場合の終了値
	 */
	public void setStart_delay_operation_end_value(
			int start_delay_operation_end_value) {
		this.start_delay_operation_end_value = start_delay_operation_end_value;
	}

	/**
	 * 開始遅延時に操作する場合の操作種別を返す。<BR>
	 * @return 開始遅延時の操作種別
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public int getStart_delay_operation_type() {
		return start_delay_operation_type;
	}

	/**
	 * 開始遅延時に操作する場合の操作種別を返す。<BR>
	 * @param start_delay_operation_type 開始遅延時の操作種別
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public void setStart_delay_operation_type(int start_delay_operation_type) {
		this.start_delay_operation_type = start_delay_operation_type;
	}
	
	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定するかどうかを返す。<BR>
	 * @return 開始遅延セッション開始後の時間で判定するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getStart_delay_session() {
		return start_delay_session;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定するかどうかを設定する。<BR>
	 * @param start_delay_session 開始遅延セッション開始後の時間で判定するどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_session(int start_delay_session) {
		this.start_delay_session = start_delay_session;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するかの値を返す。<BR>
	 * @return 開始遅延セッション開始後の時間の値
	 */
	public int getStart_delay_session_value() {
		return start_delay_session_value;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * セッション開始後の時間で判定する場合、<BR>
	 * 開始後何分で監視するかの値を設定する。<BR>
	 * @param start_delay_session_value 開始遅延セッション開始後の時間の値
	 */
	public void setStart_delay_session_value(int start_delay_session_value) {
		this.start_delay_session_value = start_delay_session_value;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * 時刻で判定するかどうかを返す。<BR>
	 * @return 開始遅延時刻で判定するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getStart_delay_time() {
		return start_delay_time;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * 時刻で判定するかどうかを設定する。<BR>
	 * @param start_delay_time 開始遅延時刻で判定するかどうか
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setStart_delay_time(int start_delay_time) {
		this.start_delay_time = start_delay_time;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * 時刻で判定する場合の時刻を返す。<BR>
	 * @return 開始遅延時刻の値
	 */
	public Date getStart_delay_time_value() {
		return start_delay_time_value;
	}

	/**
	 * 開始遅延の判定条件のうち、<BR>
	 * 時刻で判定する場合の時刻を設定する。<BR>
	 * @param start_delay_time_value 開始遅延時刻の値
	 */
	public void setStart_delay_time_value(Date start_delay_time_value) {
		this.start_delay_time_value = start_delay_time_value;
	}

	/**
	 * ジョブ待ち条件情報のクローンを作成する。<BR>
	 * @return ジョブ待ち条件情報のクローン
	 * @see java.lang.Object#clone()
	 */
	@SuppressWarnings("unchecked")
	protected Object clone() {
		try {
			JobWaitRuleInfo clone = (JobWaitRuleInfo)super.clone();
			
			clone.setCondition(this.getCondition());
			clone.setEndCondition(this.getEndCondition());
			clone.setEndStatus(this.getEndStatus());
			clone.setEndValue(this.getEndValue());
			clone.setSkip(this.getSkip());
			clone.setSkipEndStatus(this.getSkipEndStatus());
			clone.setSkipEndValue(this.getSkipEndValue());
			clone.setSuspend(this.getSuspend());
			clone.setCalendar(this.getCalendar());
			clone.setCalendarId(this.getCalendarId());
			clone.setCalendarEndValue(this.getCalendarEndValue());
			clone.setStart_delay(this.getStart_delay());
			clone.setStart_delay_session(this.getStart_delay_session());
			clone.setStart_delay_session_value(this.getStart_delay_session_value());
			clone.setStart_delay_time(this.getStart_delay_time());
			clone.setStart_delay_time_value(this.getStart_delay_time_value());
            if(this.getStart_delay_time_value() instanceof Date){
                clone.setStart_delay_time_value((Date)this.getStart_delay_time_value().clone());
            }
			clone.setStart_delay_condition_type(this.getStart_delay_condition_type());
			clone.setStart_delay_notify(this.getStart_delay_notify());
			clone.setStart_delay_notify_priority(this.getStart_delay_notify_priority());
			clone.setStart_delay_operation(this.getStart_delay_operation());
			clone.setStart_delay_operation_type(this.getStart_delay_operation_type());
			clone.setStart_delay_operation_end_value(this.getStart_delay_operation_end_value());
			clone.setEnd_delay(this.getEnd_delay());
			clone.setEnd_delay_session(this.getEnd_delay_session());
			clone.setEnd_delay_session_value(this.getEnd_delay_session_value());
			clone.setEnd_delay_job(this.getEnd_delay_job());
			clone.setEnd_delay_job_value(this.getEnd_delay_job_value());
			clone.setEnd_delay_time(this.getEnd_delay_time());
            if(this.getEnd_delay_time_value() instanceof Date){
                clone.setEnd_delay_time_value((Date)this.getEnd_delay_time_value().clone());
            }
			clone.setEnd_delay_condition_type(this.getEnd_delay_condition_type());
			clone.setEnd_delay_notify(this.getEnd_delay_notify());
			clone.setEnd_delay_notify_priority(this.getEnd_delay_notify_priority());
			clone.setEnd_delay_operation(this.getEnd_delay_operation());
			clone.setEnd_delay_operation_type(this.getEnd_delay_operation_type());
			clone.setEnd_delay_operation_end_value(this.getEnd_delay_operation_end_value());
			
			ArrayList cloneList = new ArrayList();
			if(this.getObject() != null && this.getObject() instanceof ArrayList){
				for(int i = 0; i < this.getObject().size(); i++){
					Object source = this.getObject().get(i);
					if(source != null && source instanceof JobObjectInfo){
						cloneList.add(((JobObjectInfo)source).clone());
					}
				}
			}
			clone.setObject(cloneList);
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}