/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeKeeper implements Runnable {
    protected static Log m_log = LogFactory.getLog( TimeKeeper.class );
	long TIMEOUT = 15000l;
	
	long timeout; //msec
	long timerStart;
	
	boolean ldapResponse = false;
	Thread parent;
	Thread myThread = null;
	
	public TimeKeeper() {
		parent = Thread.currentThread();
		this.timeout = TIMEOUT;
	}
	
	public TimeKeeper(long timout) {
		parent = Thread.currentThread();
		this.timeout = timout;
	}
	
	public void run() {	
		synchronized (this){
			// スレッドとして動き出す前に既にLDAPからのリクエストが返っている場合
			if(ldapResponse){
				return;  // 何もせず終了
			} else {	
				myThread = Thread.currentThread();
			}
		}

		timerStart = System.currentTimeMillis();

		long waitTime = timeout;
		
		while (waitTime > 0) {
			try {
				Thread.sleep(waitTime);
			} catch (InterruptedException ie) {
				synchronized (this) {
					if (ldapResponse){
						break;
					}
				}
			}
			waitTime = timeout - (System.currentTimeMillis() - timerStart);
		}
		synchronized (this) {
			// LDAPからのアクセスがない場合は、親のスレッドをインタラプト
			if (!ldapResponse){
				m_log.error("LDAP Connection Timeout. [ " + timeout + " ms ]");
				parent.interrupt();
			}
			
			// スレッドプーリングを利用している場合スレッドのinterruptフラグが残ってしまう可能性があるためクリアしておく 
			myThread = null;
			Thread.interrupted();
		}
	}
	
	public void stop(){
		synchronized (this){
			ldapResponse = true;

			if(myThread != null){
				myThread.interrupt();
			}
		}
	}
}
