package org.postgresforest.constant;

/**
 * Forestが認識する各ユーザデータベースの状態を表す列挙型
 */
public enum UdbValidity {
    /** 整合性が保たれており、アクセスが行われている */
    VALID(1),
    /** 整合性は保たれているが、リカバリ作業のためにこのデータベースへのアクセスを抑制している */
    RECOVERY(0),
    /** 整合性が保たれておらず、アクセスが抑制されている */
    INVALID(-1);
    
    public static UdbValidity getEnum(int value) {
        switch (value) {
            case 1:
                return VALID;
                
            case 0:
                return RECOVERY;
                
            case -1:
                return INVALID;
                    
            default:
                return null;
        }
    }
    
    public int getInt() {
        return value;
    }
    
    private final int value;
    private UdbValidity(int value) {
        this.value = value;
    }
}
