/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.core.types;

import java.math.BigDecimal;
import org.postgresforest.core.types.PGBigDecimal;
import org.postgresforest.core.types.PGBoolean;
import org.postgresforest.core.types.PGDouble;
import org.postgresforest.core.types.PGInteger;
import org.postgresforest.core.types.PGLong;
import org.postgresforest.core.types.PGShort;
import org.postgresforest.core.types.PGString;
import org.postgresforest.core.types.PGType;
import org.postgresforest.core.types.PGUnknown;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class PGFloat
implements PGType {
    private Float val;

    protected PGFloat(Float x) {
        this.val = x;
    }

    public static PGType castToServerType(Float val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    return new PGBoolean(val.floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(val.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(val.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(val.toString());
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val.doubleValue()));
                }
                case 7: {
                    return new PGFloat(val);
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val.toString()));
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

