/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.postgresforest.Driver;
import org.postgresforest.core.BaseResultSet;
import org.postgresforest.jdbc1.AbstractJdbc1Connection;
import org.postgresforest.jdbc1.AbstractJdbc1ResultSet;
import org.postgresforest.jdbc3.AbstractJdbc3Statement;
import org.postgresforest.jdbc3.Jdbc3Connection;
import org.postgresforest.jdbc3.Jdbc3ResultSet;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;
import org.postgresforest.vm.AbstractForestConnection;
import org.postgresforest.vm.ColumnInfo;
import org.postgresforest.vm.ForestPSQLException;
import org.postgresforest.vm.ForestSQLState;
import org.postgresforest.vm.GSCdata;
import org.postgresforest.vm.Lock;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.NoPartitionReWriter;
import org.postgresforest.vm.NullKey;
import org.postgresforest.vm.OrderInfo;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;
import org.postgresforest.vm.SelectColumnInfo;
import org.postgresforest.vm.StatementSub;
import org.postgresforest.vm.StatementThreadMng;

public abstract class AbstractForestStatement
extends AbstractJdbc3Statement {
    private boolean isFunction;
    private String m_statementName = null;
    private String[] m_origSqlFragments;
    private String[] m_executeSqlFragments;
    protected LogUtil m_logUtil;
    private static final short UNKNOWN = 0;
    private static final short NO = 1;
    private static final short YES = 2;
    private short m_isSingleDML = 0;
    private short m_isSingleSelect = 0;
    private short m_isSingleStatement = 0;
    private boolean returnTypeSet;
    private static final String PG_TEXT = "text";
    private static int m_preparedCount = 1;
    private StringBuffer sbuf = new StringBuffer(32);
    private boolean m_useServerPrepare = false;
    private int functionReturnType;
    private NoPartitionReWriter m_noPartitionReWriter;
    private ReWriter m_reWriter;

    public AbstractForestStatement(AbstractForestConnection c) {
        super(c);
        this.m_logUtil = c.getLogUtil();
    }

    public AbstractForestStatement(AbstractForestConnection connection, String sql) throws SQLException {
        super(connection, sql);
        this.m_logUtil = connection.getLogUtil();
    }

    /*
     * Loose catch block
     */
    public boolean execute() throws SQLException {
        block86: {
            ReWriter rw;
            ResultSet rs;
            if (this.isFunction && !this.returnTypeSet) {
                throw new PSQLException("postgresql.call.noreturntype", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
            }
            if (this.isFunction) {
                this.m_binds[0] = "";
                this.m_bindTypes[0] = PG_TEXT;
            }
            if (this.result != null && (rs = this.getResultSet()) != null) {
                rs.close();
            }
            String[] fragments = this.getQueryFragments();
            GSCdata gsc = ((Jdbc3Connection)this.connection).m_gsc;
            StatementThreadMng threadMng = ((Jdbc3Connection)this.connection).m_threadMng;
            if (gsc == null) {
                return super.execute();
            }
            ((AbstractForestConnection)this.connection).chkRollBack();
            if (!gsc.hasPartition() && gsc.canPartitionMode()) {
                if (Driver.logInfo) {
                    this.m_logUtil.info("NoPartitionReWriter was selected..");
                }
                rw = new NoPartitionReWriter(gsc);
            } else {
                if (Driver.logInfo) {
                    this.m_logUtil.info("ReWriter was selected.");
                }
                rw = new ReWriter(gsc);
            }
            StringBuffer strSql = new StringBuffer();
            for (int i = 0; i < this.m_binds.length; ++i) {
                if (this.m_binds[i] == null) {
                    throw new PSQLException("postgresql.prep.param", new Integer(i + 1));
                }
                strSql.append(this.m_sqlFragments[i]);
                strSql.append(this.m_binds[i]);
            }
            strSql.append(this.m_sqlFragments[this.m_binds.length]);
            rw.setSrcSql(strSql.toString());
            if (Driver.logInfo) {
                this.m_logUtil.info("ReWriter was completed. (" + strSql.toString() + ")");
            }
            this.result = null;
            boolean flg = true;
            ArrayList queryinfoList = rw.getQueryInfo();
            if (this.connection.getAutoCommit() && !gsc.isTableAvailable()) {
                while (!gsc.isTableAvailable()) {
                    try {
                        if (Driver.logInfo) {
                            this.m_logUtil.info("Sleeping 3 secs before retrying...");
                        }
                        Thread.sleep(3000L);
                    }
                    catch (Exception ex) {
                        throw new PSQLException("postgresql.forest.execute.internal", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)ex);
                    }
                }
            }
            if (!(((AbstractForestConnection)this.connection).getAutoCommit() || ((AbstractForestConnection)this.connection).isTransactionOpened() || strSql.toString().toLowerCase().startsWith("begin"))) {
                ((AbstractForestConnection)this.connection).begin();
            }
            int threadCnt = queryinfoList.size();
            StatementSub[] th = new StatementSub[threadCnt];
            Lock lock = new Lock(threadCnt);
            for (int i = 0; i < threadCnt; ++i) {
                QueryInfo qi = (QueryInfo)queryinfoList.get(i);
                StatementSub statementSub = threadMng.getStatementSub();
                statementSub.execute((Statement)((Object)this), qi, gsc, rw, lock);
                th[i] = statementSub;
            }
            try {
                block85: {
                    switch (rw.getQueryType()) {
                        case 0: {
                            try {
                                lock.waitAllEnd();
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            for (int i = 0; i < threadCnt; ++i) {
                                StatementSub statementSub = th[i];
                                if (statementSub.m_nErrCode != 0) {
                                    throw statementSub.m_stesql;
                                }
                                if (statementSub.m_res == null) continue;
                                this.result = (BaseResultSet)((Object)this.getResultJoint(statementSub.m_res, (ResultSet)((Object)this.result)));
                                if (!Driver.logInfo) continue;
                                this.m_logUtil.info(statementSub.getName() + ": The query execution result was collected.");
                            }
                            if (threadCnt <= 1) break;
                            if (rw.hasGroupBy() || rw.hasExecFunction()) {
                                ArrayList<Object> grpRowList = new ArrayList<Object>();
                                Vector rows = ((Jdbc3ResultSet)this.result).getRows();
                                if (rw.hasGroupBy()) {
                                    ArrayList groupList = rw.getGroupList();
                                    TreeMap sortMap = new TreeMap();
                                    while (this.result.next()) {
                                        if (Driver.logDebug) {
                                            this.m_logUtil.debug("Row:" + ((Jdbc3ResultSet)this.result).getRow());
                                        }
                                        this.sortRows(sortMap, groupList, 0, rows);
                                    }
                                    this.getGroupRows(sortMap, groupList, 0, grpRowList);
                                } else {
                                    grpRowList.add(rows.clone());
                                }
                                rows.clear();
                                ArrayList selectList = rw.getSelectList();
                                for (int i = 0; i < grpRowList.size(); ++i) {
                                    Vector groupRows = new Vector((Collection)grpRowList.get(i));
                                    Jdbc3ResultSet tmpRes = ((Jdbc3ResultSet)this.result).Copy((Statement)((Object)this));
                                    tmpRes.setRows(groupRows);
                                    rows.add(groupRows.get(0));
                                    ((Jdbc3ResultSet)this.result).last();
                                    tmpRes.next();
                                    while (tmpRes.next()) {
                                        for (int j = 0; j < selectList.size(); ++j) {
                                            SelectColumnInfo selectColumnInfo = (SelectColumnInfo)selectList.get(j);
                                            int columnIndex = selectColumnInfo.getNumber();
                                            Comparable tmpValue = null;
                                            Comparable srcValue = null;
                                            Comparable<Long> distValue = null;
                                            switch (selectColumnInfo.getFunctionType()) {
                                                case 2: {
                                                    long tmpLongValue = tmpRes.getLong(columnIndex);
                                                    long srcLongValue = ((Jdbc3ResultSet)this.result).getLong(columnIndex);
                                                    distValue = new Long(tmpLongValue + srcLongValue);
                                                    break;
                                                }
                                                case 0: {
                                                    tmpValue = (Comparable)tmpRes.getObject(columnIndex);
                                                    srcValue = (Comparable)((Jdbc3ResultSet)this.result).getObject(columnIndex);
                                                    if (tmpValue != null && srcValue != null) {
                                                        if (tmpValue.compareTo(srcValue) > 0) {
                                                            distValue = tmpValue;
                                                            break;
                                                        }
                                                        distValue = srcValue;
                                                        break;
                                                    }
                                                    if (tmpValue != null) {
                                                        distValue = tmpValue;
                                                        break;
                                                    }
                                                    if (srcValue == null) break;
                                                    distValue = srcValue;
                                                    break;
                                                }
                                                case 1: {
                                                    tmpValue = (Comparable)tmpRes.getObject(columnIndex);
                                                    srcValue = (Comparable)((Jdbc3ResultSet)this.result).getObject(columnIndex);
                                                    if (tmpValue != null && srcValue != null) {
                                                        if (tmpValue.compareTo(srcValue) < 0) {
                                                            distValue = tmpValue;
                                                            break;
                                                        }
                                                        distValue = srcValue;
                                                        break;
                                                    }
                                                    if (tmpValue != null) {
                                                        distValue = tmpValue;
                                                        break;
                                                    }
                                                    if (srcValue == null) break;
                                                    distValue = srcValue;
                                                    break;
                                                }
                                                case 3: {
                                                    long srcLongValue;
                                                    long tmpLongValue;
                                                    ResultSetMetaData rmeta = ((Jdbc3ResultSet)this.result).getMetaData();
                                                    switch (rmeta.getColumnType(columnIndex)) {
                                                        case -5: 
                                                        case 4: 
                                                        case 5: {
                                                            tmpLongValue = tmpRes.getLong(columnIndex);
                                                            srcLongValue = ((Jdbc3ResultSet)this.result).getLong(columnIndex);
                                                            distValue = new Long(tmpLongValue + srcLongValue);
                                                            break;
                                                        }
                                                        case 2: {
                                                            BigDecimal tmpBigDecimal = (BigDecimal)tmpRes.getObject(columnIndex);
                                                            BigDecimal srcBigDecimal = (BigDecimal)((Jdbc3ResultSet)this.result).getObject(columnIndex);
                                                            distValue = srcBigDecimal.add(tmpBigDecimal);
                                                            break;
                                                        }
                                                        case 6: 
                                                        case 7: 
                                                        case 8: {
                                                            double tmpDoubleValue = tmpRes.getDouble(columnIndex);
                                                            double srcDoubleValue = ((Jdbc3ResultSet)this.result).getDouble(columnIndex);
                                                            distValue = new Double(tmpDoubleValue + srcDoubleValue);
                                                        }
                                                    }
                                                    break;
                                                }
                                            }
                                            if (distValue == null) continue;
                                            ((Jdbc3ResultSet)this.result).setObject(columnIndex, distValue);
                                        }
                                    }
                                }
                                ((Jdbc3ResultSet)this.result).beforeFirst();
                            }
                            if (rw.hasOrderBy()) {
                                ArrayList orderList = rw.getOrderList();
                                TreeMap sortMap = new TreeMap();
                                Vector rows = ((Jdbc3ResultSet)this.result).getRows();
                                while (this.result.next()) {
                                    if (Driver.logDebug) {
                                        this.m_logUtil.debug("Row:" + ((Jdbc3ResultSet)this.result).getRow());
                                    }
                                    this.sortRows(sortMap, orderList, 0, rows);
                                }
                                Vector sortRows = new Vector(this.getSortRows(sortMap, orderList, 0));
                                ((Jdbc3ResultSet)this.result).setRows(sortRows);
                                ((Jdbc3ResultSet)this.result).beforeFirst();
                            }
                            if (!rw.hasLimit()) break;
                            Vector rows = ((Jdbc3ResultSet)this.result).getRows();
                            int rowCount = rw.getLimitCount();
                            if (rows.size() < rowCount) {
                                rowCount = rows.size();
                            }
                            rows = new Vector(rows.subList(0, rowCount));
                            ((Jdbc3ResultSet)this.result).setRows(rows);
                            break;
                        }
                        case 1: {
                            try {
                                lock.waitEnd();
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            StatementSub statementSub = th[0];
                            if (statementSub.m_nErrCode != 0) {
                                throw statementSub.m_stesql;
                            }
                            if (statementSub.m_res == null) break;
                            this.result = (BaseResultSet)((Object)this.getResultJoint(statementSub.m_res, (ResultSet)((Object)this.result)));
                            if (!Driver.logInfo) break;
                            this.m_logUtil.info(statementSub.getName() + ": The query execution result was collected.");
                            break;
                        }
                        case 2: {
                            flg = true;
                            while (flg) {
                                int i;
                                StatementSub statementSub;
                                if (gsc.getUpdateSyncMode()) {
                                    try {
                                        lock.waitAllEnd();
                                    }
                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                    for (int i2 = 0; i2 < threadCnt; ++i2) {
                                        statementSub = th[i2];
                                        if (statementSub.m_nErrCode != 0) {
                                            throw statementSub.m_stesql;
                                        }
                                        if (statementSub.m_res != null && flg) {
                                            this.result = (BaseResultSet)((Object)this.getResultJoint(statementSub.m_res, (ResultSet)((Object)this.result)));
                                        }
                                        flg = false;
                                    }
                                    continue;
                                }
                                try {
                                    lock.waitEnd();
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                boolean allErr = true;
                                for (i = 0; i < threadCnt; ++i) {
                                    statementSub = th[i];
                                    if (!statementSub.isExecuted()) {
                                        allErr = false;
                                        continue;
                                    }
                                    if (statementSub.m_nErrCode != 0) continue;
                                    if (statementSub.m_res != null) {
                                        this.result = (BaseResultSet)((Object)this.getResultJoint(statementSub.m_res, (ResultSet)((Object)this.result)));
                                    }
                                    flg = false;
                                    break;
                                }
                                if (flg && allErr) {
                                    ForestPSQLException err = new ForestPSQLException("postgresql.forest.execute.allfailure", ForestSQLState.INTERNAL_ERROR);
                                    for (int i3 = 0; i3 < threadCnt; ++i3) {
                                        err.setNextException(th[i3].m_stesql, th[i3].m_con.getURL(), th[i3].m_sqlFragments[0]);
                                    }
                                    throw err;
                                }
                                if (flg) continue;
                                for (i = 0; i < threadCnt; ++i) {
                                    th[i].setServerBrokenChk(true);
                                }
                                break block85;
                            }
                            break;
                        }
                    }
                }
                Object var36_53 = null;
            }
            catch (Throwable throwable) {
                Object var36_54 = null;
                for (int i = 0; i < threadCnt; ++i) {
                    threadMng.closeStatementSub(th[i]);
                }
                ((AbstractForestConnection)this.connection).chkRollBack();
                throw throwable;
            }
            for (int i = 0; i < threadCnt; ++i) {
                threadMng.closeStatementSub(th[i]);
            }
            {
                break block86;
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw new PSQLException("postgresql.forest.execute.internal", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)e);
                }
            }
        }
        ((AbstractForestConnection)this.connection).chkRollBack();
        if (this.isFunction) {
            if (!this.result.reallyResultSet()) {
                throw new PSQLException("postgresql.call.noreturnval", PSQLState.NO_DATA);
            }
            if (!this.result.next()) {
                throw new PSQLException("postgresql.call.noreturnval", PSQLState.NO_DATA);
            }
            this.callResult = this.result.getObject(1);
            int columnType = this.result.getMetaData().getColumnType(1);
            if (columnType != this.functionReturnType) {
                throw new PSQLException("postgresql.call.wrongrtntype", PSQLState.DATA_TYPE_MISMATCH, new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType});
            }
            this.result.close();
            return true;
        }
        return this.result != null && this.result.reallyResultSet();
    }

    protected void sortRows(TreeMap sortMap, ArrayList grpList, int index, Vector rows) throws SQLException {
        ColumnInfo columnInfo = (ColumnInfo)grpList.get(index);
        Object objKey = this.result.getObject(columnInfo.getNumber());
        if (objKey == null) {
            objKey = new NullKey();
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug("TREE:[" + index + "]" + objKey.toString());
        }
        if (grpList.size() == index + 1) {
            Object value = rows.get(((ResultSet)((Object)this.result)).getRow() - 1);
            if (sortMap.containsKey(objKey)) {
                ArrayList values = (ArrayList)sortMap.get(objKey);
                values.add(value);
            } else {
                ArrayList values = new ArrayList();
                values.add(value);
                sortMap.put(objKey, values);
            }
        } else {
            TreeMap subTreeMap = null;
            if (sortMap.containsKey(objKey)) {
                subTreeMap = (TreeMap)sortMap.get(objKey);
                this.sortRows(subTreeMap, grpList, ++index, rows);
            } else {
                subTreeMap = new TreeMap();
                this.sortRows(subTreeMap, grpList, index + 1, rows);
                sortMap.put(objKey, subTreeMap);
            }
        }
    }

    protected Collection getSortRows(TreeMap sortMap, ArrayList cols, int index) throws SQLException {
        OrderInfo orderInfo = (OrderInfo)cols.get(index);
        ArrayList sortRows = new ArrayList();
        ArrayList keys = new ArrayList(sortMap.keySet());
        if (orderInfo.getSort() == 1) {
            Collections.reverse(keys);
        }
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (Driver.logDebug) {
                this.m_logUtil.debug(key.toString());
            }
            if (cols.size() == index + 1) {
                sortRows.addAll((Collection)sortMap.get(key));
                continue;
            }
            TreeMap subSortMap = (TreeMap)sortMap.get(key);
            sortRows.addAll(this.getSortRows(subSortMap, cols, index + 1));
        }
        return sortRows;
    }

    protected void getGroupRows(Map sortMap, ArrayList cols, int index, Collection sortRows) throws SQLException {
        OrderInfo orderInfo = (OrderInfo)cols.get(index);
        ArrayList keys = new ArrayList(sortMap.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (Driver.logDebug) {
                this.m_logUtil.debug(key.toString());
            }
            if (cols.size() == index + 1) {
                sortRows.add((Collection)sortMap.get(key));
                continue;
            }
            Map subMap = (Map)sortMap.get(key);
            this.getGroupRows(subMap, cols, index + 1, sortRows);
        }
    }

    public ResultSet executeQueryGD(String p_sql) throws SQLException {
        this.deallocateQuery();
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        return this.executeQueryGD();
    }

    public ResultSet executeQueryGD() throws SQLException {
        super.execute();
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult", PSQLState.NO_DATA);
        }
        return (ResultSet)((Object)this.result);
    }

    public int executeUpdateGD(String p_sql) throws SQLException {
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            ((AbstractJdbc1Connection)this.connection).execSQL("DEALLOCATE " + this.m_statementName);
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
        }
        return this.executeUpdateGD();
    }

    public int executeUpdateGD() throws SQLException {
        super.execute();
        if (((AbstractJdbc1ResultSet)this.result).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public ResultSet getResultJoint(ResultSet res1, ResultSet res2) {
        if (res2 == null) {
            res2 = ((Jdbc3ResultSet)res1).Copy((Statement)((Object)this));
        } else {
            ((Jdbc3ResultSet)res2).getRows().addAll(((Jdbc3ResultSet)res1).getRows());
        }
        return res2;
    }

    private void deallocateQuery() {
        if (this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_statementName = null;
        this.m_cursorName = null;
        this.m_executeSqlFragments = null;
        this.m_isSingleDML = 0;
        this.m_isSingleSelect = 0;
        this.m_isSingleStatement = 0;
    }

    private String[] getQueryFragments() {
        if (this.fetchSize > 0 && !this.connection.getAutoCommit() && this.isSingleSelect()) {
            return this.transformToCursorFetch();
        }
        if (this.isUseServerPrepare() && this.isSingleDML()) {
            return this.transformToServerPrepare();
        }
        return this.m_sqlFragments;
    }

    private String[] transformToCursorFetch() {
        this.m_cursorName = "JDBC_CURS_" + m_preparedCount++;
        int len = this.m_sqlFragments.length;
        String[] cursorBasedSql = new String[len];
        System.arraycopy(this.m_sqlFragments, 0, cursorBasedSql, 0, len);
        cursorBasedSql[0] = "DECLARE " + this.m_cursorName + " CURSOR FOR " + cursorBasedSql[0];
        int n = len - 1;
        cursorBasedSql[n] = cursorBasedSql[n] + "; FETCH FORWARD " + this.fetchSize + " FROM " + this.m_cursorName;
        if (Driver.logDebug) {
            Driver.debug("using cursor based sql with cursor name " + this.m_cursorName);
        }
        return cursorBasedSql;
    }

    private boolean isSingleSelect() {
        if (this.m_isSingleSelect == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleSelect == 2;
    }

    private boolean isSingleDML() {
        if (this.m_isSingleDML == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleDML == 2;
    }

    private void analyzeStatementType() {
        if (!this.isSingleStatement()) {
            this.m_isSingleDML = 1;
            this.m_isSingleSelect = 1;
            return;
        }
        String compare = this.m_sqlFragments[0].trim().toLowerCase();
        if (compare.startsWith("select")) {
            this.m_isSingleDML = (short)2;
            this.m_isSingleSelect = (short)2;
            return;
        }
        this.m_isSingleSelect = 1;
        if (!(compare.startsWith("update") || compare.startsWith("delete") || compare.startsWith("insert"))) {
            this.m_isSingleDML = 1;
            return;
        }
        this.m_isSingleDML = (short)2;
    }

    private boolean isSingleStatement() {
        if (this.m_isSingleStatement != 0) {
            return this.m_isSingleStatement == 2;
        }
        for (int i = 0; i < this.m_sqlFragments.length; ++i) {
            if (this.m_sqlFragments[i].indexOf(59) == -1) continue;
            this.m_isSingleStatement = 1;
            return false;
        }
        this.m_isSingleStatement = (short)2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] transformToServerPrepare() {
        if (this.m_statementName != null) {
            return this.m_executeSqlFragments;
        }
        this.m_statementName = "JDBC_STATEMENT_" + m_preparedCount++;
        this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
        this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
        if (this.m_sqlFragments.length > 1) {
            this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
            for (int i = 1; i < this.m_bindTypes.length; ++i) {
                this.m_executeSqlFragments[i] = ", ";
            }
            this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
        }
        String[] prepareSqlFragments = new String[this.m_sqlFragments.length];
        System.arraycopy(this.m_sqlFragments, 0, prepareSqlFragments, 0, this.m_sqlFragments.length);
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            int i;
            this.sbuf.setLength(0);
            this.sbuf.append("PREPARE ");
            this.sbuf.append(this.m_statementName);
            if (this.m_sqlFragments.length > 1) {
                this.sbuf.append("(");
                for (i = 0; i < this.m_bindTypes.length; ++i) {
                    if (i != 0) {
                        this.sbuf.append(", ");
                    }
                    this.sbuf.append(this.m_bindTypes[i]);
                }
                this.sbuf.append(")");
            }
            this.sbuf.append(" AS ");
            this.sbuf.append(this.m_sqlFragments[0]);
            for (i = 1; i < this.m_sqlFragments.length; ++i) {
                this.sbuf.append(" $");
                this.sbuf.append(i);
                this.sbuf.append(" ");
                this.sbuf.append(this.m_sqlFragments[i]);
            }
            this.sbuf.append("; ");
            this.sbuf.append(this.m_executeSqlFragments[0]);
            prepareSqlFragments[0] = this.sbuf.toString();
        }
        System.arraycopy(this.m_executeSqlFragments, 1, prepareSqlFragments, 1, prepareSqlFragments.length - 1);
        return prepareSqlFragments;
    }
}

