/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.util.JRColorUtil;

public abstract class BorderStyle
extends Style {
    private static final String[] border = new String[]{"top", "left", "bottom", "right"};
    protected static final int TOP_BORDER = 0;
    protected static final int LEFT_BORDER = 1;
    protected static final int BOTTOM_BORDER = 2;
    protected static final int RIGHT_BORDER = 3;
    protected JRPrintElement element = null;
    private String[] borderColor = new String[4];
    private String[] borderWidth = new String[4];
    private String[] borderStyle = new String[4];
    private String[] borderPadding = new String[4];

    public BorderStyle(Writer styleWriter, JRPrintElement element) {
        super(styleWriter);
        this.element = element;
    }

    public void setBox(JRBox box) throws IOException {
        if (box != null) {
            this.appendBorder(box.getTopBorder(), box.getTopBorderColor() == null ? this.element.getForecolor() : box.getTopBorderColor(), box.getTopPadding(), 0);
            this.appendBorder(box.getLeftBorder(), box.getLeftBorderColor() == null ? this.element.getForecolor() : box.getLeftBorderColor(), box.getLeftPadding(), 1);
            this.appendBorder(box.getBottomBorder(), box.getBottomBorderColor() == null ? this.element.getForecolor() : box.getBottomBorderColor(), box.getBottomPadding(), 2);
            this.appendBorder(box.getRightBorder(), box.getRightBorderColor() == null ? this.element.getForecolor() : box.getRightBorderColor(), box.getRightPadding(), 3);
        }
    }

    public String getId() {
        return this.borderWidth[0] + "|" + this.borderColor[0] + "|" + this.borderStyle[0] + "|" + this.borderPadding[0] + "|" + this.borderWidth[1] + "|" + this.borderColor[1] + "|" + this.borderStyle[1] + "|" + this.borderPadding[1] + "|" + this.borderWidth[2] + "|" + this.borderColor[2] + "|" + this.borderStyle[2] + "|" + this.borderPadding[2] + "|" + this.borderWidth[3] + "|" + this.borderColor[3] + "|" + this.borderStyle[3] + "|" + this.borderPadding[3];
    }

    protected void writeBorder(int side) throws IOException {
        if (this.borderWidth[side] != null) {
            this.styleWriter.write(" fo:border-");
            this.styleWriter.write(border[side]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderWidth[side]);
            this.styleWriter.write("in ");
            this.styleWriter.write(this.borderStyle[side]);
            this.styleWriter.write(" #");
            this.styleWriter.write(this.borderColor[side]);
            this.styleWriter.write("\"");
        }
        if (this.borderPadding[side] != null) {
            this.styleWriter.write(" fo:padding-");
            this.styleWriter.write(border[side]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderPadding[side]);
            this.styleWriter.write("\"");
        }
    }

    private void appendBorder(byte pen, Color color, int padding, int side) throws IOException {
        String style = null;
        double width = 0.0;
        switch (pen) {
            case 4: {
                style = "dashed";
                width = 1.0;
                break;
            }
            case 3: {
                style = "solid";
                width = 4.0;
                break;
            }
            case 2: {
                style = "solid";
                width = 2.0;
                break;
            }
            case 5: {
                style = "solid";
                width = 0.5;
                break;
            }
            case 0: {
                style = "none";
                break;
            }
            default: {
                style = "solid";
                width = 1.0;
            }
        }
        this.borderStyle[side] = style;
        this.borderWidth[side] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(width));
        this.borderColor[side] = JRColorUtil.getColorHexa(color);
        this.borderPadding[side] = String.valueOf(Utility.translatePixelsToInchesWithNoRoundOff(padding));
    }
}

