/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.client.operations.CIMOperation;

public class BatchResult {
    protected CIMOperation[] operations;
    protected int[] failureIds;
    protected int[] successIds;

    public BatchResult(Object[] results) {
        if (!(results instanceof CIMOperation[])) {
            throw new IllegalArgumentException("Results argument not an instance of CIMOperation[]");
        }
        this.operations = (CIMOperation[])results;
        int[] failure = new int[this.operations.length];
        int[] success = new int[this.operations.length];
        int totalFailure = 0;
        int totalSuccess = 0;
        for (int i = 0; i < this.operations.length; ++i) {
            if (!this.operations[i].isException()) {
                success[totalSuccess++] = i;
                continue;
            }
            failure[totalFailure++] = i;
        }
        this.failureIds = new int[totalFailure];
        System.arraycopy(failure, 0, this.failureIds, 0, totalFailure);
        this.successIds = new int[totalSuccess];
        System.arraycopy(success, 0, this.successIds, 0, totalSuccess);
    }

    public int[] getFailureIds() {
        return this.failureIds;
    }

    public Object getResult(int operationID) throws CIMException {
        if (operationID < 0 || operationID >= this.operations.length) {
            throw new IllegalArgumentException("operation ID out of range");
        }
        return this.operations[operationID].getResult();
    }

    public int[] getSuccessIds() {
        return this.successIds;
    }
}

