/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.ejb.session;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.performance.bean.CollectMethodConstant;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectedDataSet;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorLockKey;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.bean.DeviceDataSet;
import com.clustercontrol.performance.dao.CalculatedDataDAO;
import com.clustercontrol.performance.dao.CollectorItemDAO;
import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import com.clustercontrol.performance.ejb.bmp.CollectorUtil;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoUtil;
import com.clustercontrol.performance.util.FacilityTreeDB;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.util.LockManager;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.performance.util.code.CollectorItemCodeTable;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectorControllerBean
implements SessionBean,
CheckFacility {
    protected static Log m_log = LogFactory.getLog(CollectorControllerBean.class);
    public static final int CURRENT_SCOPE = 0;
    public static final int SUB_SCOPE = 1;
    public static final String COLLECT_METHOD = CollectMethodConstant.SNMP;
    private String m_collectorID;
    private int m_collectorType;

    public void ejbCreate() throws CreateException {
        this.m_collectorType = 0;
    }

    public void ejbRemove() {
        m_log.debug((Object)("ejbRemove() start : " + this.m_collectorID));
        if (this.m_collectorType == 1) {
            try {
                CollectorHome home = JNDIConnectionManager.getCollectorHome();
                Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
                myBean.stopCollect();
                myBean.remove();
            }
            catch (FinderException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (NamingException e) {
                throw new EJBException(e.getMessage(), (Exception)e);
            }
            catch (EJBException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (RemoveException e) {
                throw new EJBException(e.getMessage(), (Exception)((Object)e));
            }
            catch (RemoteException e) {
                throw new EJBException(e.getMessage(), (Exception)e);
            }
        }
        m_log.debug((Object)("ejbRemove() end : " + this.m_collectorID));
    }

    public void ejbPassivate() {
    }

    public void createRealtimeColletor(String facilityID, int interval, List<CollectorItemInfo> colletorItemList) {
        String collectorID;
        this.m_collectorType = 1;
        this.m_collectorID = collectorID = CollectorUtil.generateGUID(this);
        m_log.debug((Object)("createRealtimeColletor() start : " + Thread.currentThread().getName() + "\t" + collectorID));
        try {
            RecordCollectorData data = new RecordCollectorData();
            data.setCollectorID(collectorID);
            data.setCollectorType(1);
            data.setLabel(Thread.currentThread().getName());
            data.setFacilityID(facilityID);
            data.setIntervalSec(interval);
            data.setPeriodMin(-1);
            Repository repository = new Repository();
            FacilityTreeItem facilityTree = repository.getFacilityTree(facilityID);
            data.setFacilityTree(facilityTree);
            if (facilityTree == null) {
                return;
            }
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.create(data, colletorItemList);
            myBean.startCollect();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)("createRealtimeColletor() end : " + Thread.currentThread().getName() + "\t" + collectorID));
    }

    public Collection<CollectedDataInfo> getRealtimeCollectedData(String facilityID, String itemCode, String deviceName, int option) {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
            if (option == 0) {
                CollectedDataInfo data = myBean.getValue(facilityID, new CollectorItemInfo(this.m_collectorID, COLLECT_METHOD, itemCode, deviceName));
                ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
                ret.add(data);
                return ret;
            }
            if (option == 1) {
                return myBean.getSubScopeValues(facilityID, new CollectorItemInfo(this.m_collectorID, COLLECT_METHOD, itemCode, deviceName));
            }
            return null;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Collection<CollectedDataInfo> getRealtimeCollectedDataAll(String facilityID) {
        try {
            CollectedDataInfo[] returnData = null;
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(this.m_collectorID));
            returnData = myBean.getValueAll(facilityID);
            return Arrays.asList(returnData);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public CollectorProperty getCollectorProperty(String collectorID) {
        this.m_collectorID = collectorID;
        CollectorProperty property = new CollectorProperty();
        RecordCollectorData collectorData = null;
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            collectorData = myBean.getRecordColletorData();
            property.setDeviceSet(this.getDeviceSet(collectorID));
            collectorData.setFacilityTree(this.getFacilityTree(collectorID));
            property.setCollectorData(collectorData);
            CollectorItemDAO dao = new CollectorItemDAO();
            ArrayList<CollectorItemInfo> itemList = new ArrayList<CollectorItemInfo>(dao.selectCollectorItemByCollectorID(collectorID));
            property.setItemList(itemList);
            return property;
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void createRecordColletor(CollectorProperty collectorDef) throws DuplicateKeyException {
        m_log.debug((Object)("createRecordColletor() start : " + Thread.currentThread().getName() + "\t" + this.m_collectorID));
        this.m_collectorType = 2;
        this.m_collectorID = collectorDef.getCollectorData().getCollectorID();
        RecordCollectorData collectorData = collectorDef.getCollectorData();
        collectorData.setCollectorType(this.m_collectorType);
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector collector = home.create(collectorData, collectorDef.getItemList());
            collector.startCollect();
        }
        catch (DuplicateKeyException e) {
            throw e;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)("createRecordColletor() end : " + Thread.currentThread().getName() + "\t" + collectorDef.getCollectorData().getCollectorID()));
    }

    public void stopRecordCollector(String collectorID) {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            myBean.stopCollect();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public List<CollectedDataInfo> getRecordCollectedData(CollectorItemInfo item, String facilityID, Date startDate, Date endDate) {
        m_log.debug((Object)("getRecordCollectedData() " + facilityID));
        CalculatedDataDAO dao = new CalculatedDataDAO();
        List<CollectedDataInfo> data = dao.select(item.getCollectorId(), item.getCollectMethod(), item.getItemCode(), item.getDeviceName(), facilityID, startDate, endDate);
        return data;
    }

    public List<CollectedDataInfo> getRecordCollectedData(String collectorID, String facilityID, Date startDate, Date stopDate) {
        m_log.debug((Object)("getRecordCollectedData() " + facilityID));
        CalculatedDataDAO dao = new CalculatedDataDAO();
        ArrayList<CollectedDataInfo> data = dao.select(collectorID, facilityID, startDate, stopDate);
        return data;
    }

    public CollectedDataSet getRecordCollectedData(String[] facilityIDs, CollectorItemInfo[] itemInfos, Date startDate, Date endDate) {
        CollectedDataSet ret = new CollectedDataSet();
        for (int j = 0; j < facilityIDs.length; ++j) {
            for (int i = 0; i < itemInfos.length; ++i) {
                List<CollectedDataInfo> dataList = this.getRecordCollectedData(itemInfos[i], facilityIDs[j], startDate, endDate);
                ret.setCollectedDataList(facilityIDs[j], itemInfos[i], dataList);
            }
        }
        return ret;
    }

    public void deleteRecordCollector(String collectorID) throws RemoveException {
        m_log.debug((Object)("deleteRecordCollector() start : " + Thread.currentThread().getName() + "\t" + collectorID));
        if (LockManager.isLocked(collectorID)) {
            m_log.debug((Object)("deleteRecordCollector()  : " + collectorID + " is locked."));
            throw new RemoveException(collectorID + " is locked.");
        }
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
            if (myBean.getStatus() == 100) {
                m_log.debug((Object)("deleteRecordCollector()  : " + collectorID + " is running."));
                throw new RemoveException(collectorID + " is running.");
            }
            myBean.remove();
        }
        catch (FinderException e) {
            throw new RemoveException(e.getMessage());
        }
        catch (NamingException e) {
            throw new RemoveException(e.getMessage());
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new RemoveException(e.getMessage());
        }
        m_log.debug((Object)("deleteRecordCollector() end : " + Thread.currentThread().getName() + "\t" + collectorID));
    }

    public FacilityTreeItem getFacilityTree(String collectorID) {
        return new FacilityTreeDB().getFacilityTree(collectorID);
    }

    public DeviceDataSet getCurrentDeviceSet(String facilityID) {
        DeviceDataSet dataSet = new DeviceDataSet();
        Repository repository = new Repository();
        List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(facilityID);
        Iterator<CollectorDeviceInfoData> itr = deviceList.iterator();
        while (itr.hasNext()) {
            dataSet.putDeviceList(itr.next());
        }
        return dataSet;
    }

    public DeviceDataSet getDeviceSet(String collectorId) throws FinderException, NamingException {
        DeviceDataSet dataSet = new DeviceDataSet();
        Collection col = CollectorDeviceInfoUtil.getLocalHome().findByCollectorId(collectorId);
        for (CollectorDeviceInfoLocal bean : col) {
            dataSet.putDeviceList(new CollectorDeviceInfoData(bean.getCollectorId(), bean.getFacilityId(), bean.getDeviceName(), bean.getIndex(), bean.getDeviceId(), bean.getDeviceType()));
        }
        return dataSet;
    }

    public void lock(String collectorID, CollectorLockKey key) {
        LockManager.lock(collectorID, key);
    }

    public void unlock(CollectorLockKey key) {
        LockManager.unlock(key);
    }

    public ArrayList getCollectionListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 0, 70, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"error.status", (Locale)locale), 11, 70, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"collection.id", (Locale)locale), -1, 200, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 220, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 220, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"collection.start.date", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"collection.stop.date", (Locale)locale), -1, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"collection.interval", (Locale)locale), -1, 70, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"collection.count", (Locale)locale), -1, 70, 16384));
        return tableDefine;
    }

    public ArrayList<ArrayList<Object>> getCollectionList() {
        m_log.debug((Object)"getCollectionList() start : ");
        ArrayList<ArrayList<Object>> list = new ArrayList<ArrayList<Object>>();
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collection myBeans = home.findByCollectorType(2);
            for (Collector myBean : myBeans) {
                RecordCollectorData data = myBean.getRecordColletorData();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(new Integer(data.getStatus()));
                info.add(new Integer(data.getEndStatus()));
                info.add(data.getCollectorID());
                info.add(data.getLabel());
                info.add(data.getScopePath());
                info.add(data.getStartDate());
                info.add(data.getStopDate());
                info.add(data.getIntervalSec());
                info.add(data.getCount());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        m_log.debug((Object)"getCollectionList() end   : ");
        return list;
    }

    public HashMap<String, CollectorItemTreeItem> getItemCodeMap() {
        return CollectorItemCodeTable.getItemCodeMap();
    }

    public CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        return CollectorItemCodeTable.getCollectorTree(facilityId, collectorId);
    }

    public List<CollectorItemInfo> getAvailableCollectorItemList(String facilityId) {
        ArrayList<CollectorItemInfo> itemInfo = new ArrayList<CollectorItemInfo>();
        CollectorItemTreeItem[] itemTree = CollectorItemCodeTable.getCollectorTree(facilityId, null);
        for (int i = 0; i < itemTree.length; ++i) {
            CollectorItemTreeItem item = itemTree[i];
            this.setAvailableCollectorItemList(item, itemInfo);
        }
        return itemInfo;
    }

    private void setAvailableCollectorItemList(CollectorItemTreeItem item, List<CollectorItemInfo> itemInfoList) {
        if (!item.isCategoryItem()) {
            String deviceName = null;
            CollectorDeviceInfoData deviceData = item.getDeviceData();
            deviceName = deviceData != null ? deviceData.getDeviceName() : "";
            itemInfoList.add(new CollectorItemInfo(null, CollectMethodConstant.SNMP, item.getItemCode(), deviceName));
        }
        ArrayList<CollectorItemInfo> childrenList = new ArrayList<CollectorItemInfo>();
        ArrayList<CollectorItemTreeItem> children = item.getChildren();
        for (CollectorItemTreeItem childItem : children) {
            this.setAvailableCollectorItemList(childItem, childrenList);
        }
        CollectorItemInfo[] list = childrenList.toArray(new CollectorItemInfo[0]);
        Arrays.sort(list, new Comparator<CollectorItemInfo>(){

            @Override
            public int compare(CollectorItemInfo o1, CollectorItemInfo o2) {
                return o1.getItemCode().compareTo(o2.getItemCode());
            }
        });
        itemInfoList.addAll(Arrays.asList(list));
    }

    public boolean checkPermissionRead() {
        return true;
    }

    public boolean checkPerformanceWrite() {
        return true;
    }

    public boolean checkPermissionExecute() {
        return true;
    }

    public void isUseFacilityId(String facilityId) throws UsedFacilityException {
        try {
            Collection ct = null;
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            ct = home.findByCollectorTypeAndFacilityId(1, facilityId);
            if (ct != null && ct.size() > 0) {
                throw new UsedFacilityException(4);
            }
            ct = null;
            ct = home.findByCollectorTypeAndFacilityId(2, facilityId);
            if (ct != null && ct.size() > 0) {
                for (Collector collector : ct) {
                    if (collector.getStatus() != 100) continue;
                    throw new UsedFacilityException(4);
                }
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
        catch (RemoteException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
    }
}

