/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.repository.dao.FileSystemInfoDAO;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoBean;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoPK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemInfoDAOImpl
implements FileSystemInfoDAO {
    protected static Log m_log = LogFactory.getLog(FileSystemInfoDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_FILE_SYSTEM_INFO = "ccFileSystemInfo";
    private static int MAX_RETRY = 3;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load(FileSystemInfoPK pk, FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block20: {
                this.clearBean(ejb);
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                ejb.setDn(pk.getDn());
                ejb.setCn(new Integer((String)attrs.get("cn").get(0)));
                if (attrs.get("ccSnmpOID") != null) {
                    ejb.setSnmpOID((String)attrs.get("ccSnmpOID").get(0));
                }
                if (attrs.get("ccFileSystemMountPoint") != null) {
                    ejb.setFileSystemMountPoint((String)attrs.get("ccFileSystemMountPoint").get(0));
                }
                if (attrs.get("ccFileSystemType") != null) {
                    ejb.setFileSystemType((String)attrs.get("ccFileSystemType").get(0));
                }
                if (attrs.get("description") != null) {
                    ejb.setDescription((String)attrs.get("description").get(0));
                }
                String dn = ejb.getDn();
                dn = dn.replaceFirst("[^,]*,", "");
                dn = dn.replaceFirst(",[\\s\\w=]*", "");
                dn = dn.replaceFirst("ccFacilityId=", "");
                ejb.setFacilityId(dn);
                Object var8_8 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block20;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                }
                break block20;
                {
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("load(): catch NamingException" + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var8_8 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"load() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var8_8 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("load() context close failed : " + e2.getMessage()));
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void store(FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block36: {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                Attributes attrs = ctx.getAttributes(ejb.getDn());
                BasicAttributes addAttrs = new BasicAttributes();
                BasicAttributes replaceAttrs = new BasicAttributes();
                BasicAttributes removeAttrs = new BasicAttributes();
                if (attrs.get("description") == null && ejb.getDescription() != null) {
                    addAttrs.put("description", ejb.getDescription());
                } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                    removeAttrs.put("description", null);
                } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                    replaceAttrs.put("description", ejb.getDescription());
                }
                if (attrs.get("ccSnmpOID") == null && ejb.getSnmpOID() != null) {
                    addAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() == null) {
                    removeAttrs.put("ccSnmpOID", null);
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() != null) {
                    replaceAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                }
                if (attrs.get("ccFileSystemMountPoint") == null && ejb.getFileSystemMountPoint() != null) {
                    addAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() == null) {
                    removeAttrs.put("ccFileSystemMountPoint", null);
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() != null) {
                    replaceAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                }
                if (attrs.get("ccFileSystemType") == null && ejb.getFileSystemType() != null) {
                    addAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() == null) {
                    removeAttrs.put("ccFileSystemType", null);
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() != null) {
                    replaceAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                }
                ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
                ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
                ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
                Object var9_7 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block36;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                }
                break block36;
                {
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var9_7 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"store() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var9_7 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_7 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("store() context close failed : " + e2.getMessage()));
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(FileSystemInfoPK pk) throws RemoveException, EJBException {
        block14: {
            ctx = null;
            retryCount = 0;
            while (FileSystemInfoDAOImpl.MAX_RETRY > retryCount) {
                try {
                    try {
                        ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                        ctx.destroySubcontext(pk.getDn());
                        var8_9 = null;
                        break block14;
                    }
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        apllog = new AplLogger("REP", "rep");
                        args = new String[]{pk.getDn()};
                        apllog.put("SYS", "004", args);
                        if (++retryCount >= FileSystemInfoDAOImpl.MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var8_9 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e) {
                            FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                        }
                    }
                    catch (NullPointerException e) {
                        FileSystemInfoDAOImpl.m_log.debug((Object)"remove() : LDAP query result is null");
                        if (++retryCount >= FileSystemInfoDAOImpl.MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var8_9 = null;
                        ** try [egrp 2[TRYBLOCK] [6 : 160->173)] { 
lbl33:
                        // 1 sources

                        if (ctx == null) continue;
                        ctx.close();
lbl36:
                        // 1 sources

                        catch (NamingException e) {
                            FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                        }
                    }
                }
                catch (Throwable var7_11) {
                    var8_9 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 160->173)] { 
lbl43:
                    // 1 sources

                    if (ctx == null) throw var7_11;
                    ctx.close();
                    throw var7_11;
lbl46:
                    // 1 sources

                    catch (NamingException e) {
                        FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                    }
                    throw var7_11;
                }
            }
            return;
        }
        ** try [egrp 2[TRYBLOCK] [6 : 160->173)] { 
lbl52:
        // 1 sources

        if (ctx == null) return;
        ctx.close();
        return;
lbl55:
        // 1 sources

        catch (NamingException e) {
            FileSystemInfoDAOImpl.m_log.error((Object)("remove() context close failed : " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public FileSystemInfoPK create(FileSystemInfoBean ejb) throws CreateException, EJBException {
        FileSystemInfoPK pk = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(OBJECTCLASS, OBJECT_CLASS_FILE_SYSTEM_INFO);
            attrs.put("cn", ejb.getCn().toString());
            StringBuffer dn = new StringBuffer();
            dn.append("cn");
            dn.append("=");
            dn.append(ejb.getCn());
            dn.append(",");
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            FileSystemInfoPK fileSystemInfoPK = pk = new FileSystemInfoPK(ejb.getDn());
            Object var9_10 = null;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                m_log.error((Object)("create() context close failed : " + e2.getMessage()));
            }
            {
                return fileSystemInfoPK;
                catch (NamingException ex) {
                    if (ex instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    AplLogger apllog = new AplLogger("REP", "rep");
                    Object[] args = new String[]{ejb.getDn()};
                    apllog.put("SYS", "003", args);
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)ex);
                    }
                    var9_10 = null;
                    try {
                        if (ctx == null) continue;
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    m_log.debug((Object)"create() : LDAP query result is null");
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e);
                    }
                    var9_10 = null;
                    try {
                        if (ctx == null) continue;
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_10 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e2) {
                    m_log.error((Object)("create() context close failed : " + e2.getMessage()));
                }
                throw throwable;
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findAll() throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            NamingException e222;
            Object var10_11;
            block24: {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results != null) break block24;
                m_log.debug((Object)"findAll() : No Search Result");
                ArrayList<FileSystemInfoPK> arrayList = ret;
                var10_11 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                }
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
            var10_11 = null;
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx == null) continue;
                ctx.close();
            }
            catch (NamingException e222) {
                m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
            }
            continue;
            {
                catch (NamingException e3) {
                    if (e3 instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    m_log.debug((Object)("findAll() : " + e3.getMessage()));
                    ret.clear();
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e3);
                    }
                    var10_11 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx == null) continue;
                        ctx.close();
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    continue;
                }
                catch (NullPointerException e4) {
                    m_log.debug((Object)"findAll() : LDAP query result is null");
                    ret.clear();
                    if (++retryCount >= MAX_RETRY) {
                        throw new EJBException((Exception)e4);
                    }
                    var10_11 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx == null) continue;
                        ctx.close();
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_11 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findAll() context close failed : " + e222.getMessage()));
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSystemInfoPK findByPrimaryKey(FileSystemInfoPK pk) throws FinderException {
        Context ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block16: {
                m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                Object var6_7 = null;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block16;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                }
                break block16;
                {
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var6_7 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var6_7 = null;
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                    }
                    throw throwable;
                }
            }
            return pk;
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block27: {
                NamingException e222;
                Object var12_12;
                block25: {
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results != null) break block25;
                    m_log.warn((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                    ArrayList<FileSystemInfoPK> arrayList = ret;
                    var12_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
                var12_12 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block27;
                }
                catch (NamingException e222) {
                    m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                }
                break block27;
                {
                    catch (NamingException e3) {
                        if (e3 instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByFacilityId() : " + e3.getMessage()));
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e3);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        continue;
                    }
                    catch (NullPointerException e4) {
                        m_log.debug((Object)"findByFacilityId() : LDAP query result is null");
                        ret.clear();
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e4);
                        }
                        var12_12 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e222) {
                            m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e222) {
                        m_log.error((Object)("findByFacilityId() context close failed : " + e222.getMessage()));
                    }
                    throw throwable;
                }
            }
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSystemInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
        m_log.debug((Object)("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(name);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FileSystemInfoPK pk = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block21: {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (!results.hasMoreElements()) {
                    throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
                }
                SearchResult aResult = (SearchResult)results.nextElement();
                pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                Object var12_13 = null;
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block21;
                }
                catch (NamingException e2) {
                    m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                }
                break block21;
                {
                    catch (NamingException ex) {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByFacilityIdAndName() : " + ex.getMessage()));
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)ex);
                        }
                        var12_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                        if (++retryCount >= MAX_RETRY) {
                            throw new EJBException((Exception)e);
                        }
                        var12_13 = null;
                        try {
                            if (results != null) {
                                results.close();
                            }
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (NamingException e2) {
                            m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e2) {
                        m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e2.getMessage()));
                    }
                    throw throwable;
                }
            }
            return pk;
        }
        return pk;
    }

    protected void clearBean(FileSystemInfoBean ejb) {
        ejb.setCn(null);
        ejb.setDescription(null);
        ejb.setFileSystemMountPoint(null);
        ejb.setFileSystemType(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setSnmpOID(null);
    }
}

