/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.SelectSchedule;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class SelectMonitor {
    protected static Log m_log = LogFactory.getLog(SelectMonitor.class);
    protected MonitorInfoLocal m_monitor;
    protected MonitorInfo m_monitorInfo;
    protected String m_monitorTypeId;
    protected String m_monitorId;

    public MonitorInfo getMonitor(String monitorTypeId, String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        MonitorInfo bean = null;
        try {
            MonitorInfoPK pk = new MonitorInfoPK(this.m_monitorId, this.m_monitorTypeId);
            this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            String facilityPath = repository.getFacilityPath(this.m_monitor.getFacilityId(), null);
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
            Collection notifyId = nc.getNotifyRelation(this.m_monitor.getNotifyGroupId());
            int valid = new SelectSchedule().getValid(this.m_monitorTypeId, this.m_monitorId);
            bean = new MonitorInfo(this.m_monitor.getApplication(), this.m_monitor.getCalendarId(), this.m_monitor.getDescription(), this.m_monitor.getDeterminationId(), facilityPath, this.m_monitor.getFacilityId(), this.m_monitor.getFailurePriority().intValue(), this.m_monitor.getMonitorBlock().intValue(), this.m_monitorId, this.m_monitorTypeId, this.m_monitor.getMonitorType().intValue(), this.m_monitor.getRegDate(), this.m_monitor.getRegUser(), this.m_monitor.getRunInterval().intValue(), this.m_monitor.getTimeout().intValue(), this.m_monitor.getFailureMessageId(), this.m_monitor.getFailureMessage(), this.m_monitor.getNotifyGroupId(), notifyId, this.m_monitor.getUpdateDate(), this.m_monitor.getUpdateUser(), valid, this.getJudgementInfo(), this.getCheckInfo());
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getMonitor()", "010");
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getMonitor()", "010");
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "getMonitor()", "010");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getMonitor()", "010");
            throw e;
        }
        return bean;
    }

    public abstract ArrayList getJudgementInfo() throws FinderException, NamingException;

    public abstract MonitorCheckInfo getCheckInfo() throws FinderException, NamingException;

    public ArrayList getMonitorList(String monitorTypeId) throws CreateException, FinderException, SchedulerException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = MonitorInfoUtil.getLocalHome().findAll(monitorTypeId);
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "getMonitorList()", "011");
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "getMonitorList()", "011");
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "getMonitorList()", "011");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "getMonitorList()", "011");
            throw e;
        }
        return list;
    }

    public ArrayList getMonitorListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"monitor.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 200, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"monitor.type", (Locale)locale), -1, 80, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"calendar", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"run.interval", (Locale)locale), -1, 60, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 80, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 130, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 130, 16384));
        return tableDefine;
    }

    public ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, SchedulerException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        SelectSchedule schedule = new SelectSchedule();
        ArrayList list = new ArrayList();
        for (MonitorInfoLocal monitor : ct) {
            String facilityPath = repository.getFacilityPath(monitor.getFacilityId(), null);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(monitor.getMonitorId());
            info.add(monitor.getDescription());
            info.add(facilityPath);
            info.add(MonitorTypeConstant.typeToString((int)monitor.getMonitorType()));
            info.add(monitor.getCalendarId());
            info.add(RunIntervalConstant.typeToString((int)monitor.getRunInterval()));
            info.add(schedule.getValid(monitor.getMonitorTypeId(), monitor.getMonitorId()));
            info.add(monitor.getRegUser());
            info.add(monitor.getRegDate() == null ? null : new Date(monitor.getRegDate().getTime()));
            info.add(monitor.getUpdateUser());
            info.add(monitor.getUpdateDate() == null ? null : new Date(monitor.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }

    private void outputLog(Exception e, String method, String index) {
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{this.m_monitorTypeId, this.m_monitorId};
        apllog.put("SYS", index, args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

