/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.util;

import com.clustercontrol.util.Messages;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpV2Error;
import org.opennms.protocols.snmp.SnmpVarBind;

public class RequestSnmp
implements SnmpHandler {
    protected static Log m_log = LogFactory.getLog(RequestSnmp.class);
    private int m_version = 1;
    private String m_community = "public";
    int m_retries = -1;
    int m_timeout = 1000;
    int m_port = -1;
    private String m_ipAddress;
    private SnmpObjectId m_oid;
    private String m_oidText;
    private String m_value;
    private long m_date;
    private String m_message = null;
    boolean m_waitFlg;
    private int m_errorCode = 0;
    private final int Normal = 0;
    private final int TimeOutError = 1;
    private final int InternalError = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean polling(InetAddress ipAddress, String community, int portNumber, String oidText, int version, int timeout, int retries) {
        m_log.debug((Object)("polling() start :" + ipAddress.toString()));
        this.m_errorCode = 0;
        this.m_ipAddress = ipAddress.toString();
        this.m_community = community;
        this.m_port = portNumber;
        this.m_oidText = oidText;
        this.m_version = version;
        this.m_timeout = timeout;
        this.m_retries = retries;
        this.m_waitFlg = true;
        SnmpPeer peer = new SnmpPeer(ipAddress);
        if (this.m_port != -1) {
            peer.setPort(this.m_port);
        }
        if (this.m_timeout != -1) {
            peer.setTimeout(this.m_timeout);
        }
        if (this.m_retries != -1) {
            peer.setRetries(this.m_retries);
        }
        SnmpParameters parms = peer.getParameters();
        parms.setVersion(this.m_version);
        parms.setReadCommunity(this.m_community);
        SnmpSession session = null;
        try {
            session = new SnmpSession(peer);
        }
        catch (SocketException e) {
            m_log.debug((Object)("polling():" + this.m_ipAddress + " SocketException creating the SNMP session"));
            this.m_message = Messages.getString((String)"message.snmp.7") + " (" + e.getMessage() + ")";
            return false;
        }
        session.setDefaultHandler((SnmpHandler)this);
        try {
            SnmpPduRequest pdu = new SnmpPduRequest(160);
            this.m_oid = new SnmpObjectId(this.m_oidText);
            pdu.addVarBind(new SnmpVarBind(this.m_oid));
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.send((SnmpPduPacket)pdu);
                if (this.m_waitFlg) {
                    session.wait();
                }
            }
        }
        catch (InterruptedException e) {
            m_log.debug((Object)("polling():" + this.m_ipAddress + " polling failed at InterruptedException"));
            this.m_message = Messages.getString((String)"message.snmp.7") + " (" + e.getMessage() + ")";
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                session.close();
            }
            catch (Exception e) {
                m_log.warn((Object)("polling():" + this.m_ipAddress + " Session close failed"));
            }
        }
        return this.m_errorCode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
        try {
            long time = System.currentTimeMillis();
            m_log.debug((Object)("snmpReceivedPdu():" + session.toString()));
            SnmpPduRequest req = null;
            if (pdu instanceof SnmpPduRequest) {
                req = (SnmpPduRequest)pdu;
            }
            if (pdu.getCommand() != 162) {
                m_log.debug((Object)("snmpReceivedPdu():" + session.toString() + "  Received non-response command " + pdu.getCommand()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    this.m_message = Messages.getString((String)"message.snmp.7") + " Received non-response command " + pdu.getCommand();
                    session.notify();
                }
                return;
            }
            if (req.getErrorStatus() != 0) {
                m_log.error((Object)("snmpReceivedPdu():" + session.toString() + "  Error Status " + req.getErrorStatus()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    this.m_message = Messages.getString((String)"message.snmp.7") + " Error Status:" + req.getErrorStatus();
                    session.notify();
                }
                return;
            }
            SnmpVarBind[] vars = pdu.toVarBindArray();
            for (int x = 0; x < vars.length; ++x) {
                m_log.debug((Object)(vars[x].getName().toString() + " " + time + " " + vars[x].getValue().getClass().getName() + " " + vars[x].getValue().toString()));
                if (!this.m_oid.isRootOf(vars[x].getName())) continue;
                if (vars[x].getValue() instanceof SnmpV2Error) {
                    this.m_errorCode = 2;
                    this.m_message = Messages.getString((String)"message.snmp.7") + " SnmpV2Error. Value:" + vars[x].getValue().toString();
                    continue;
                }
                if (vars[x].getValue() instanceof SnmpTimeTicks) {
                    this.m_value = ((SnmpUInt32)vars[x].getValue()).toString();
                    this.m_date = time;
                    continue;
                }
                m_log.debug((Object)("snmpReceivedPdu():" + vars[x].getName().toString() + " ," + time + " ," + vars[x].getValue().toString()));
                this.m_value = vars[x].getValue().toString();
                this.m_date = time;
            }
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                session.notify();
            }
            return;
        }
        catch (Exception e) {
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                this.m_errorCode = 2;
                this.m_message = Messages.getString((String)"message.snmp.7") + " (" + e.getMessage() + ")";
                session.notify();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        m_log.warn((Object)("snmpInternalError():" + session.toString() + " snmpInternalError. The error code is " + err));
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 2;
            this.m_waitFlg = false;
            this.m_message = Messages.getString((String)"message.snmp.7") + " snmpInternalError. The error code is " + err;
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        m_log.warn((Object)("snmpTimeoutError():" + session.getPeer().getPeer().toString() + " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName() + " polling failed at TimeoutError"));
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 1;
            this.m_message = Messages.getString((String)"message.snmp.7") + " snmpTimeoutError." + session.getPeer().getPeer().toString() + " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName();
            session.notify();
        }
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getValue() {
        return this.m_value;
    }

    public long getDate() {
        return this.m_date;
    }
}

