/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable;

import com.clustercontrol.sharedtable.TableEntry;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
implements Cloneable {
    private AtomicReference<ConcurrentHashMap<String, TableEntry>> m_hm;
    private volatile long lastModify;

    public void putValue(String key, long date, Object value) {
        if (this.m_hm == null) {
            this.m_hm = new AtomicReference(new ConcurrentHashMap());
        }
        this.m_hm.get().put(key, new TableEntry(key, date, value));
        this.lastModify = System.currentTimeMillis();
    }

    public TableEntry getValue(String key) {
        if (this.m_hm == null) {
            return null;
        }
        TableEntry entry = this.m_hm.get().get(key);
        return entry;
    }

    public Set<TableEntry> getValueSetStartWith(String prefix) {
        HashSet<TableEntry> set = new HashSet<TableEntry>();
        if (this.m_hm == null) {
            return null;
        }
        for (String key : this.m_hm.get().keySet()) {
            if (!key.startsWith(prefix)) continue;
            set.add(this.m_hm.get().get(key));
        }
        return set;
    }

    public TableEntry removeValue(String key) {
        if (this.m_hm == null) {
            return null;
        }
        TableEntry entry = this.m_hm.get().remove(key);
        this.lastModify = System.currentTimeMillis();
        return entry;
    }

    public Set<String> keySet() {
        if (this.m_hm == null) {
            return new HashSet<String>();
        }
        return this.m_hm.get().keySet();
    }

    public long getLastModify() {
        return this.lastModify;
    }
}

