/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.snmp;

import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.poller.FacilityNotFoundException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.snmp.SnmpConfig;
import com.clustercontrol.poller.snmp.SnmpPoller;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnmpPollerManager {
    private static Log m_log = LogFactory.getLog(SnmpPollerManager.class);
    private String m_quartzJndiName = "QuartzRAM";
    private String m_managerName;
    private ConcurrentHashMap<PollerInfo, SnmpPoller> m_pollerTable;

    public SnmpPollerManager(String managerName) {
        this.m_managerName = managerName;
        this.m_pollerTable = new ConcurrentHashMap();
    }

    public SnmpPoller createPoller(String group, String facilityId, boolean indexCheckFlg, String tableGroup, String tableName) throws NotInitializedException, DataTableNotFoundException, FacilityNotFoundException {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("create poller    PollerGroup : " + group + ", " + "FacilityId : " + facilityId + ", " + "IndexCheckFlg : " + indexCheckFlg + ", " + "TableGroup : " + tableGroup + ", " + "TableName : " + tableName));
        }
        SnmpConfig snmpConfig = this.createSnmpConfig(facilityId);
        SnmpPoller poller = new SnmpPoller(group, facilityId, snmpConfig, indexCheckFlg, tableGroup, tableName);
        poller.setQuartzJndiName(this.m_quartzJndiName);
        this.m_pollerTable.put(new PollerInfo(group, facilityId), poller);
        return poller;
    }

    public void removePoller(String group, String facilityId) {
        PollerInfo info = new PollerInfo(group, facilityId);
        SnmpPoller poller = this.m_pollerTable.get(info);
        if (poller != null) {
            poller.stopPollingAll();
        }
        this.m_pollerTable.remove(new PollerInfo(group, facilityId));
    }

    private SnmpConfig createSnmpConfig(String facilityId) throws FacilityNotFoundException {
        m_log.debug((Object)("createSnmpConfig() start " + facilityId));
        try {
            Integer timeout;
            RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("ipProtocolNumber");
            attributes.add("ipNetworkNumber");
            attributes.add("ccIpNetworkNumberV6");
            attributes.add("ccSnmpCommunity");
            attributes.add("ccSnmpPort");
            attributes.add("ccSnmpVersion");
            attributes.add("ccSnmpTimeout");
            attributes.add("ccSnmpRetries");
            attributes.add("ccModifyTimestamp");
            HashMap nodeInfo = bean.getNodeDetail(facilityId, attributes);
            bean.remove();
            Integer ipProtNum = (Integer)nodeInfo.get("ipProtocolNumber");
            String ipAddress = null;
            ipAddress = ipProtNum != null && ipProtNum == 6 ? (String)nodeInfo.get("ccIpNetworkNumberV6") : (String)nodeInfo.get("ipNetworkNumber");
            SnmpConfig snmpConfig = new SnmpConfig(InetAddress.getByName(ipAddress));
            String community = (String)nodeInfo.get("ccSnmpCommunity");
            m_log.debug((Object)("community : " + community));
            if (community != null) {
                snmpConfig.setComunity(community);
            }
            Integer port = (Integer)nodeInfo.get("ccSnmpPort");
            m_log.debug((Object)("port      : " + port));
            if (port != null) {
                snmpConfig.setPort(port);
            }
            String versionStr = (String)nodeInfo.get("ccSnmpVersion");
            m_log.debug((Object)("version   : " + versionStr));
            if (versionStr != null && versionStr != "") {
                Integer version = SnmpVersionConstant.stringToType((String)versionStr);
                if (versionStr != null) {
                    if (version == -1) {
                        version = 1;
                    }
                    snmpConfig.setVersion(version);
                }
            }
            if ((timeout = (Integer)nodeInfo.get("ccSnmpTimeout")) != null) {
                m_log.debug((Object)("timeout   : " + timeout));
                snmpConfig.setTimeout(timeout);
            }
            Integer retries = (Integer)nodeInfo.get("ccSnmpRetries");
            m_log.debug((Object)("retries   : " + retries));
            if (retries != null) {
                snmpConfig.setRetries(retries);
            }
            m_log.debug((Object)("createSnmpConfig() end " + facilityId));
            return snmpConfig;
        }
        catch (FinderException e) {
            throw new FacilityNotFoundException(facilityId);
        }
        catch (EJBException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            if (e.getCausedByException() instanceof NameNotFoundException) {
                throw new FacilityNotFoundException(facilityId);
            }
            throw e;
        }
        catch (Exception e) {
            String message = "Couldn't get Snmp Config : " + facilityId;
            throw new EJBException(message);
        }
    }

    public void refreshSnmpConfig() {
        for (PollerInfo key : this.m_pollerTable.keySet()) {
            SnmpConfig config;
            String facilityId = key.getPollerName();
            try {
                config = this.createSnmpConfig(facilityId);
            }
            catch (FacilityNotFoundException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            this.m_pollerTable.get(key).getPollingConfig().setSnmpConfig(config);
        }
    }

    public SnmpPoller getPoller(String pollerGroup, String pollerName) {
        return this.m_pollerTable.get(new PollerInfo(pollerGroup, pollerName));
    }

    public String getManagerName() {
        return this.m_managerName;
    }

    public String getQuartzJndiName() {
        return this.m_quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.m_quartzJndiName = jndiName;
    }

    public String getPollerDebugInfo() {
        String debugStr = "";
        for (PollerInfo info : this.m_pollerTable.keySet()) {
            int minInterval = this.m_pollerTable.get(info).getPollingConfig().getMinPollingInterval();
            debugStr = debugStr + info.getPollerGroup() + ", " + info.getPollerName() + ", " + minInterval + "\n";
            debugStr = debugStr + this.m_pollerTable.get(info).getPollingConfig().getDebugInfo();
        }
        return debugStr;
    }

    private class PollerInfo {
        private String m_pollerGroup;
        private String m_pollerName;

        public PollerInfo(String pollerGroup, String pollerName) {
            this.m_pollerGroup = pollerGroup;
            this.m_pollerName = pollerName;
        }

        public String getPollerGroup() {
            return this.m_pollerGroup;
        }

        public String getPollerName() {
            return this.m_pollerName;
        }

        public boolean equals(Object other) {
            if (other instanceof PollerInfo) {
                PollerInfo info = (PollerInfo)other;
                if (this.m_pollerGroup == null && this.m_pollerName == null) {
                    if (info.m_pollerGroup == null && info.m_pollerName == null) {
                        return true;
                    }
                } else if (this.m_pollerGroup == null && this.m_pollerName != null) {
                    if (info.m_pollerGroup == null && this.m_pollerName.equals(info.m_pollerName)) {
                        return true;
                    }
                } else if (this.m_pollerGroup != null && this.m_pollerName == null) {
                    if (this.m_pollerGroup.equals(info.m_pollerGroup) && info.m_pollerName == null) {
                        return true;
                    }
                } else if (this.m_pollerGroup.equals(info.m_pollerGroup)) {
                    return this.m_pollerName.equals(info.m_pollerName);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.m_pollerGroup != null ? this.m_pollerGroup.hashCode() : 0);
            result = 37 * result + (this.m_pollerName != null ? this.m_pollerName.hashCode() : 0);
            return result;
        }
    }
}

