/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.ws.annotation.EndpointConfig;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSProviderMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXWSServerMetaDataBuilder
extends JAXWSMetaDataBuilder {
    static void setupProviderOrWebService(ArchiveDeployment dep, UnifiedMetaData umd, Class<?> beanClass, String beanName) throws Exception {
        if (beanClass.isAnnotationPresent(WebService.class)) {
            JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
            builder.buildWebServiceMetaData((Deployment)dep, umd, beanClass, beanName);
        } else if (beanClass.isAnnotationPresent(WebServiceProvider.class)) {
            JAXWSProviderMetaDataBuilder builder = new JAXWSProviderMetaDataBuilder();
            builder.buildProviderMetaData(dep, umd, beanClass, beanName);
        }
    }

    protected void processEndpointConfig(Class<?> wsClass, String linkName, ServerEndpointMetaData sepMetaData) {
        EndpointConfig anEndpointConfig = wsClass.getAnnotation(EndpointConfig.class);
        if (anEndpointConfig == null) {
            return;
        }
        String configName = null;
        String configFile = null;
        if (anEndpointConfig.configName().length() > 0) {
            configName = anEndpointConfig.configName();
        }
        if (anEndpointConfig.configFile().length() > 0) {
            configFile = anEndpointConfig.configFile();
        }
        if (configName != null || configFile != null) {
            sepMetaData.setConfigName(configName, configFile);
        }
    }

    protected void processWebContext(Deployment dep, Class<?> wsClass, String linkName, ServerEndpointMetaData sepMetaData) {
        boolean isJSEEndpoint;
        WebContext anWebContext = wsClass.getAnnotation(WebContext.class);
        if (anWebContext == null) {
            return;
        }
        boolean bl = isJSEEndpoint = dep.getType() == Deployment.DeploymentType.JAXWS_JSE;
        if (anWebContext.contextRoot().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)"@WebContext.contextRoot is only valid on EJB endpoints");
            } else {
                String contextRoot = anWebContext.contextRoot();
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                sepMetaData.setContextRoot(contextRoot);
            }
        }
        if (anWebContext.urlPattern().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)"@WebContext.urlPattern is only valid on EJB endpoints");
            } else {
                String urlPattern = anWebContext.urlPattern();
                sepMetaData.setURLPattern(urlPattern);
            }
        }
        if (anWebContext.authMethod().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)"@WebContext.authMethod is only valid on EJB endpoints");
            } else {
                String authMethod = anWebContext.authMethod();
                sepMetaData.setAuthMethod(authMethod);
            }
        }
        if (anWebContext.transportGuarantee().length() > 0) {
            if (isJSEEndpoint) {
                log.warn((Object)"@WebContext.transportGuarantee is only valid on EJB endpoints");
            } else {
                String transportGuarantee = anWebContext.transportGuarantee();
                sepMetaData.setTransportGuarantee(transportGuarantee);
            }
        }
        sepMetaData.setSecureWSDLAccess(anWebContext.secureWSDLAccess());
        String[] virtualHosts = anWebContext.virtualHosts();
        if (virtualHosts != null & virtualHosts.length > 0) {
            sepMetaData.setVirtualHosts(virtualHosts);
        }
    }
}

